/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageActionType {
    RESEND("RESEND"),
    SUPPRESS("SUPPRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageActionType> VALUE_MAP;
    private final String value;

    private MessageActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageActionType> knownValues() {
        EnumSet<MessageActionType> knownValues = EnumSet.allOf(MessageActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageActionType.class, MessageActionType::toString);
    }
}

