/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LinksTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsEnforcementType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TermsSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTermsRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateTermsRequest> {
    private static final SdkField<String> TERMS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsId").getter(UpdateTermsRequest.getter(UpdateTermsRequest::termsId)).setter(UpdateTermsRequest.setter(Builder::termsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsId").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(UpdateTermsRequest.getter(UpdateTermsRequest::userPoolId)).setter(UpdateTermsRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> TERMS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsName").getter(UpdateTermsRequest.getter(UpdateTermsRequest::termsName)).setter(UpdateTermsRequest.setter(Builder::termsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsName").build()}).build();
    private static final SdkField<String> TERMS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TermsSource").getter(UpdateTermsRequest.getter(UpdateTermsRequest::termsSourceAsString)).setter(UpdateTermsRequest.setter(Builder::termsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsSource").build()}).build();
    private static final SdkField<String> ENFORCEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Enforcement").getter(UpdateTermsRequest.getter(UpdateTermsRequest::enforcementAsString)).setter(UpdateTermsRequest.setter(Builder::enforcement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforcement").build()}).build();
    private static final SdkField<Map<String, String>> LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Links").getter(UpdateTermsRequest.getter(UpdateTermsRequest::links)).setter(UpdateTermsRequest.setter(Builder::links)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_ID_FIELD, USER_POOL_ID_FIELD, TERMS_NAME_FIELD, TERMS_SOURCE_FIELD, ENFORCEMENT_FIELD, LINKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTermsRequest.memberNameToFieldInitializer();
    private final String termsId;
    private final String userPoolId;
    private final String termsName;
    private final String termsSource;
    private final String enforcement;
    private final Map<String, String> links;

    private UpdateTermsRequest(BuilderImpl builder) {
        super(builder);
        this.termsId = builder.termsId;
        this.userPoolId = builder.userPoolId;
        this.termsName = builder.termsName;
        this.termsSource = builder.termsSource;
        this.enforcement = builder.enforcement;
        this.links = builder.links;
    }

    public final String termsId() {
        return this.termsId;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String termsName() {
        return this.termsName;
    }

    public final TermsSourceType termsSource() {
        return TermsSourceType.fromValue(this.termsSource);
    }

    public final String termsSourceAsString() {
        return this.termsSource;
    }

    public final TermsEnforcementType enforcement() {
        return TermsEnforcementType.fromValue(this.enforcement);
    }

    public final String enforcementAsString() {
        return this.enforcement;
    }

    public final boolean hasLinks() {
        return this.links != null && !(this.links instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> links() {
        return this.links;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.termsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.termsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforcementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinks() ? this.links() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTermsRequest)) {
            return false;
        }
        UpdateTermsRequest other = (UpdateTermsRequest)((Object)obj);
        return Objects.equals(this.termsId(), other.termsId()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.termsName(), other.termsName()) && Objects.equals(this.termsSourceAsString(), other.termsSourceAsString()) && Objects.equals(this.enforcementAsString(), other.enforcementAsString()) && this.hasLinks() == other.hasLinks() && Objects.equals(this.links(), other.links());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTermsRequest").add("TermsId", (Object)this.termsId()).add("UserPoolId", (Object)this.userPoolId()).add("TermsName", (Object)this.termsName()).add("TermsSource", (Object)this.termsSourceAsString()).add("Enforcement", (Object)this.enforcementAsString()).add("Links", this.hasLinks() ? this.links() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TermsId": {
                return Optional.ofNullable(clazz.cast(this.termsId()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "TermsName": {
                return Optional.ofNullable(clazz.cast(this.termsName()));
            }
            case "TermsSource": {
                return Optional.ofNullable(clazz.cast(this.termsSourceAsString()));
            }
            case "Enforcement": {
                return Optional.ofNullable(clazz.cast(this.enforcementAsString()));
            }
            case "Links": {
                return Optional.ofNullable(clazz.cast(this.links()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TermsId", TERMS_ID_FIELD);
        map.put("UserPoolId", USER_POOL_ID_FIELD);
        map.put("TermsName", TERMS_NAME_FIELD);
        map.put("TermsSource", TERMS_SOURCE_FIELD);
        map.put("Enforcement", ENFORCEMENT_FIELD);
        map.put("Links", LINKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTermsRequest, T> g) {
        return obj -> g.apply((UpdateTermsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String termsId;
        private String userPoolId;
        private String termsName;
        private String termsSource;
        private String enforcement;
        private Map<String, String> links = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTermsRequest model) {
            super(model);
            this.termsId(model.termsId);
            this.userPoolId(model.userPoolId);
            this.termsName(model.termsName);
            this.termsSource(model.termsSource);
            this.enforcement(model.enforcement);
            this.links(model.links);
        }

        public final String getTermsId() {
            return this.termsId;
        }

        public final void setTermsId(String termsId) {
            this.termsId = termsId;
        }

        @Override
        public final Builder termsId(String termsId) {
            this.termsId = termsId;
            return this;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getTermsName() {
            return this.termsName;
        }

        public final void setTermsName(String termsName) {
            this.termsName = termsName;
        }

        @Override
        public final Builder termsName(String termsName) {
            this.termsName = termsName;
            return this;
        }

        public final String getTermsSource() {
            return this.termsSource;
        }

        public final void setTermsSource(String termsSource) {
            this.termsSource = termsSource;
        }

        @Override
        public final Builder termsSource(String termsSource) {
            this.termsSource = termsSource;
            return this;
        }

        @Override
        public final Builder termsSource(TermsSourceType termsSource) {
            this.termsSource(termsSource == null ? null : termsSource.toString());
            return this;
        }

        public final String getEnforcement() {
            return this.enforcement;
        }

        public final void setEnforcement(String enforcement) {
            this.enforcement = enforcement;
        }

        @Override
        public final Builder enforcement(String enforcement) {
            this.enforcement = enforcement;
            return this;
        }

        @Override
        public final Builder enforcement(TermsEnforcementType enforcement) {
            this.enforcement(enforcement == null ? null : enforcement.toString());
            return this;
        }

        public final Map<String, String> getLinks() {
            if (this.links instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.links;
        }

        public final void setLinks(Map<String, String> links) {
            this.links = LinksTypeCopier.copy(links);
        }

        @Override
        public final Builder links(Map<String, String> links) {
            this.links = LinksTypeCopier.copy(links);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTermsRequest build() {
            return new UpdateTermsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTermsRequest> {
        public Builder termsId(String var1);

        public Builder userPoolId(String var1);

        public Builder termsName(String var1);

        public Builder termsSource(String var1);

        public Builder termsSource(TermsSourceType var1);

        public Builder enforcement(String var1);

        public Builder enforcement(TermsEnforcementType var1);

        public Builder links(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

