/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescriptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeEnvironmentsResponse> {
    private static final SdkField<List<EnvironmentDescription>> ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeEnvironmentsResponse.getter(DescribeEnvironmentsResponse::environments)).setter(DescribeEnvironmentsResponse.setter(Builder::environments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEnvironmentsResponse.getter(DescribeEnvironmentsResponse::nextToken)).setter(DescribeEnvironmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EnvironmentDescription> environments;
    private final String nextToken;

    private DescribeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasEnvironments() {
        return this.environments != null && !(this.environments instanceof SdkAutoConstructList);
    }

    public List<EnvironmentDescription> environments() {
        return this.environments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsResponse)) {
            return false;
        }
        DescribeEnvironmentsResponse other = (DescribeEnvironmentsResponse)((Object)obj);
        return Objects.equals(this.environments(), other.environments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentsResponse").add("Environments", this.environments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Environments": {
                return Optional.ofNullable(clazz.cast(this.environments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentDescription> environments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsResponse model) {
            super(model);
            this.environments(model.environments);
            this.nextToken(model.nextToken);
        }

        public final Collection<EnvironmentDescription.Builder> getEnvironments() {
            return this.environments != null ? (Collection)this.environments.stream().map(EnvironmentDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environments(Collection<EnvironmentDescription> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(EnvironmentDescription ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Consumer<EnvironmentDescription.Builder> ... environments) {
            this.environments(Stream.of(environments).map(c -> (EnvironmentDescription)((EnvironmentDescription.Builder)EnvironmentDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironments(Collection<EnvironmentDescription.BuilderImpl> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copyFromBuilder(environments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEnvironmentsResponse build() {
            return new DescribeEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentsResponse> {
        public Builder environments(Collection<EnvironmentDescription> var1);

        public Builder environments(EnvironmentDescription ... var1);

        public Builder environments(Consumer<EnvironmentDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

