/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddJobFlowStepsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, AddJobFlowStepsRequest> {
    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddJobFlowStepsRequest.getter(AddJobFlowStepsRequest::jobFlowId)).setter(AddJobFlowStepsRequest.setter(Builder::jobFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()}).build();
    private static final SdkField<List<StepConfig>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddJobFlowStepsRequest.getter(AddJobFlowStepsRequest::steps)).setter(AddJobFlowStepsRequest.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_ID_FIELD, STEPS_FIELD));
    private final String jobFlowId;
    private final List<StepConfig> steps;

    private AddJobFlowStepsRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowId = builder.jobFlowId;
        this.steps = builder.steps;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    public boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public List<StepConfig> steps() {
        return this.steps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.steps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsRequest)) {
            return false;
        }
        AddJobFlowStepsRequest other = (AddJobFlowStepsRequest)((Object)obj);
        return Objects.equals(this.jobFlowId(), other.jobFlowId()) && Objects.equals(this.steps(), other.steps());
    }

    public String toString() {
        return ToString.builder((String)"AddJobFlowStepsRequest").add("JobFlowId", (Object)this.jobFlowId()).add("Steps", this.steps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowId": {
                return Optional.ofNullable(clazz.cast(this.jobFlowId()));
            }
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddJobFlowStepsRequest, T> g) {
        return obj -> g.apply((AddJobFlowStepsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String jobFlowId;
        private List<StepConfig> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddJobFlowStepsRequest model) {
            super(model);
            this.jobFlowId(model.jobFlowId);
            this.steps(model.steps);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final Collection<StepConfig.Builder> getSteps() {
            return this.steps != null ? (Collection)this.steps.stream().map(StepConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<StepConfig.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (StepConfig)((StepConfig.Builder)StepConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSteps(Collection<StepConfig.BuilderImpl> steps) {
            this.steps = StepConfigListCopier.copyFromBuilder(steps);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddJobFlowStepsRequest build() {
            return new AddJobFlowStepsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddJobFlowStepsRequest> {
        public Builder jobFlowId(String var1);

        public Builder steps(Collection<StepConfig> var1);

        public Builder steps(StepConfig ... var1);

        public Builder steps(Consumer<StepConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

