/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.StepCancellationOption;
import software.amazon.awssdk.services.emr.model.StepIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelStepsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, CancelStepsRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelStepsRequest.getter(CancelStepsRequest::clusterId)).setter(CancelStepsRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<List<String>> STEP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CancelStepsRequest.getter(CancelStepsRequest::stepIds)).setter(CancelStepsRequest.setter(Builder::stepIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STEP_CANCELLATION_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelStepsRequest.getter(CancelStepsRequest::stepCancellationOptionAsString)).setter(CancelStepsRequest.setter(Builder::stepCancellationOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepCancellationOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, STEP_IDS_FIELD, STEP_CANCELLATION_OPTION_FIELD));
    private final String clusterId;
    private final List<String> stepIds;
    private final String stepCancellationOption;

    private CancelStepsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepIds = builder.stepIds;
        this.stepCancellationOption = builder.stepCancellationOption;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public boolean hasStepIds() {
        return this.stepIds != null && !(this.stepIds instanceof SdkAutoConstructList);
    }

    public List<String> stepIds() {
        return this.stepIds;
    }

    public StepCancellationOption stepCancellationOption() {
        return StepCancellationOption.fromValue(this.stepCancellationOption);
    }

    public String stepCancellationOptionAsString() {
        return this.stepCancellationOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepCancellationOptionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsRequest)) {
            return false;
        }
        CancelStepsRequest other = (CancelStepsRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.stepIds(), other.stepIds()) && Objects.equals(this.stepCancellationOptionAsString(), other.stepCancellationOptionAsString());
    }

    public String toString() {
        return ToString.builder((String)"CancelStepsRequest").add("ClusterId", (Object)this.clusterId()).add("StepIds", this.stepIds()).add("StepCancellationOption", (Object)this.stepCancellationOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "StepIds": {
                return Optional.ofNullable(clazz.cast(this.stepIds()));
            }
            case "StepCancellationOption": {
                return Optional.ofNullable(clazz.cast(this.stepCancellationOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelStepsRequest, T> g) {
        return obj -> g.apply((CancelStepsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private List<String> stepIds = DefaultSdkAutoConstructList.getInstance();
        private String stepCancellationOption;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.stepIds(model.stepIds);
            this.stepCancellationOption(model.stepCancellationOption);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepIds() {
            return this.stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String ... stepIds) {
            this.stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
        }

        public final String getStepCancellationOption() {
            return this.stepCancellationOption;
        }

        @Override
        public final Builder stepCancellationOption(String stepCancellationOption) {
            this.stepCancellationOption = stepCancellationOption;
            return this;
        }

        @Override
        public final Builder stepCancellationOption(StepCancellationOption stepCancellationOption) {
            this.stepCancellationOption(stepCancellationOption == null ? null : stepCancellationOption.toString());
            return this;
        }

        public final void setStepCancellationOption(String stepCancellationOption) {
            this.stepCancellationOption = stepCancellationOption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelStepsRequest build() {
            return new CancelStepsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelStepsRequest> {
        public Builder clusterId(String var1);

        public Builder stepIds(Collection<String> var1);

        public Builder stepIds(String ... var1);

        public Builder stepCancellationOption(String var1);

        public Builder stepCancellationOption(StepCancellationOption var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

