/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.DefinitionDocument;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.MetricsConfiguration;
import software.amazon.awssdk.services.iotthingsgraph.model.Tag;
import software.amazon.awssdk.services.iotthingsgraph.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSystemInstanceRequest
extends IoTThingsGraphRequest
implements ToCopyableBuilder<Builder, CreateSystemInstanceRequest> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateSystemInstanceRequest.getter(CreateSystemInstanceRequest::tags)).setter(CreateSystemInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateSystemInstanceRequest.getter(CreateSystemInstanceRequest::definition)).setter(CreateSystemInstanceRequest.setter(Builder::definition)).constructor(DefinitionDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSystemInstanceRequest.getter(CreateSystemInstanceRequest::targetAsString)).setter(CreateSystemInstanceRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> GREENGRASS_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSystemInstanceRequest.getter(CreateSystemInstanceRequest::greengrassGroupName)).setter(CreateSystemInstanceRequest.setter(Builder::greengrassGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupName").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSystemInstanceRequest.getter(CreateSystemInstanceRequest::s3BucketName)).setter(CreateSystemInstanceRequest.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<MetricsConfiguration> METRICS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateSystemInstanceRequest.getter(CreateSystemInstanceRequest::metricsConfiguration)).setter(CreateSystemInstanceRequest.setter(Builder::metricsConfiguration)).constructor(MetricsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsConfiguration").build()}).build();
    private static final SdkField<String> FLOW_ACTIONS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSystemInstanceRequest.getter(CreateSystemInstanceRequest::flowActionsRoleArn)).setter(CreateSystemInstanceRequest.setter(Builder::flowActionsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowActionsRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, DEFINITION_FIELD, TARGET_FIELD, GREENGRASS_GROUP_NAME_FIELD, S3_BUCKET_NAME_FIELD, METRICS_CONFIGURATION_FIELD, FLOW_ACTIONS_ROLE_ARN_FIELD));
    private final List<Tag> tags;
    private final DefinitionDocument definition;
    private final String target;
    private final String greengrassGroupName;
    private final String s3BucketName;
    private final MetricsConfiguration metricsConfiguration;
    private final String flowActionsRoleArn;

    private CreateSystemInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.definition = builder.definition;
        this.target = builder.target;
        this.greengrassGroupName = builder.greengrassGroupName;
        this.s3BucketName = builder.s3BucketName;
        this.metricsConfiguration = builder.metricsConfiguration;
        this.flowActionsRoleArn = builder.flowActionsRoleArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public DefinitionDocument definition() {
        return this.definition;
    }

    public DeploymentTarget target() {
        return DeploymentTarget.fromValue(this.target);
    }

    public String targetAsString() {
        return this.target;
    }

    public String greengrassGroupName() {
        return this.greengrassGroupName;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public MetricsConfiguration metricsConfiguration() {
        return this.metricsConfiguration;
    }

    public String flowActionsRoleArn() {
        return this.flowActionsRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.greengrassGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowActionsRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSystemInstanceRequest)) {
            return false;
        }
        CreateSystemInstanceRequest other = (CreateSystemInstanceRequest)((Object)obj);
        return Objects.equals(this.tags(), other.tags()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.targetAsString(), other.targetAsString()) && Objects.equals(this.greengrassGroupName(), other.greengrassGroupName()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.metricsConfiguration(), other.metricsConfiguration()) && Objects.equals(this.flowActionsRoleArn(), other.flowActionsRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateSystemInstanceRequest").add("Tags", this.tags()).add("Definition", (Object)this.definition()).add("Target", (Object)this.targetAsString()).add("GreengrassGroupName", (Object)this.greengrassGroupName()).add("S3BucketName", (Object)this.s3BucketName()).add("MetricsConfiguration", (Object)this.metricsConfiguration()).add("FlowActionsRoleArn", (Object)this.flowActionsRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.targetAsString()));
            }
            case "greengrassGroupName": {
                return Optional.ofNullable(clazz.cast(this.greengrassGroupName()));
            }
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "metricsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.metricsConfiguration()));
            }
            case "flowActionsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.flowActionsRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSystemInstanceRequest, T> g) {
        return obj -> g.apply((CreateSystemInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphRequest.BuilderImpl
    implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private DefinitionDocument definition;
        private String target;
        private String greengrassGroupName;
        private String s3BucketName;
        private MetricsConfiguration metricsConfiguration;
        private String flowActionsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSystemInstanceRequest model) {
            super(model);
            this.tags(model.tags);
            this.definition(model.definition);
            this.target(model.target);
            this.greengrassGroupName(model.greengrassGroupName);
            this.s3BucketName(model.s3BucketName);
            this.metricsConfiguration(model.metricsConfiguration);
            this.flowActionsRoleArn(model.flowActionsRoleArn);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final DefinitionDocument.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(DeploymentTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getGreengrassGroupName() {
            return this.greengrassGroupName;
        }

        @Override
        public final Builder greengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
            return this;
        }

        public final void setGreengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final MetricsConfiguration.Builder getMetricsConfiguration() {
            return this.metricsConfiguration != null ? this.metricsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder metricsConfiguration(MetricsConfiguration metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration;
            return this;
        }

        public final void setMetricsConfiguration(MetricsConfiguration.BuilderImpl metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration != null ? metricsConfiguration.build() : null;
        }

        public final String getFlowActionsRoleArn() {
            return this.flowActionsRoleArn;
        }

        @Override
        public final Builder flowActionsRoleArn(String flowActionsRoleArn) {
            this.flowActionsRoleArn = flowActionsRoleArn;
            return this;
        }

        public final void setFlowActionsRoleArn(String flowActionsRoleArn) {
            this.flowActionsRoleArn = flowActionsRoleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSystemInstanceRequest build() {
            return new CreateSystemInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSystemInstanceRequest> {
        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder definition(DefinitionDocument var1);

        default public Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return this.definition((DefinitionDocument)((DefinitionDocument.Builder)DefinitionDocument.builder().applyMutation(definition)).build());
        }

        public Builder target(String var1);

        public Builder target(DeploymentTarget var1);

        public Builder greengrassGroupName(String var1);

        public Builder s3BucketName(String var1);

        public Builder metricsConfiguration(MetricsConfiguration var1);

        default public Builder metricsConfiguration(Consumer<MetricsConfiguration.Builder> metricsConfiguration) {
            return this.metricsConfiguration((MetricsConfiguration)((MetricsConfiguration.Builder)MetricsConfiguration.builder().applyMutation(metricsConfiguration)).build());
        }

        public Builder flowActionsRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

