/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentTarget {
    GREENGRASS("GREENGRASS"),
    CLOUD("CLOUD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentTarget(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentTarget fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentTarget.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentTarget> knownValues() {
        return Stream.of(DeploymentTarget.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

