/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLoggingOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLoggingOption> {
    private static final SdkField<String> LOG_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudWatchLoggingOption.getter(CloudWatchLoggingOption::logStreamARN)).setter(CloudWatchLoggingOption.setter(Builder::logStreamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudWatchLoggingOption.getter(CloudWatchLoggingOption::roleARN)).setter(CloudWatchLoggingOption.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_ARN_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logStreamARN;
    private final String roleARN;

    private CloudWatchLoggingOption(BuilderImpl builder) {
        this.logStreamARN = builder.logStreamARN;
        this.roleARN = builder.roleARN;
    }

    public String logStreamARN() {
        return this.logStreamARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOption)) {
            return false;
        }
        CloudWatchLoggingOption other = (CloudWatchLoggingOption)obj;
        return Objects.equals(this.logStreamARN(), other.logStreamARN()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchLoggingOption").add("LogStreamARN", (Object)this.logStreamARN()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogStreamARN": {
                return Optional.ofNullable(clazz.cast(this.logStreamARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingOption, T> g) {
        return obj -> g.apply((CloudWatchLoggingOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamARN;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOption model) {
            this.logStreamARN(model.logStreamARN);
            this.roleARN(model.roleARN);
        }

        public final String getLogStreamARN() {
            return this.logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public CloudWatchLoggingOption build() {
            return new CloudWatchLoggingOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLoggingOption> {
        public Builder logStreamARN(String var1);

        public Builder roleARN(String var1);
    }
}

