/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceHealthState {
    INITIAL("initial"),
    HEALTHY("healthy"),
    UNHEALTHY("unhealthy"),
    UNUSED("unused"),
    DRAINING("draining"),
    UNAVAILABLE("unavailable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceHealthState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceHealthState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceHealthState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceHealthState> knownValues() {
        return Stream.of(InstanceHealthState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

