/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastoredata.model.MediaStoreDataRequest;
import software.amazon.awssdk.services.mediastoredata.model.StorageClass;
import software.amazon.awssdk.services.mediastoredata.model.UploadAvailability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutObjectRequest
extends MediaStoreDataRequest
implements ToCopyableBuilder<Builder, PutObjectRequest> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutObjectRequest.getter(PutObjectRequest::path)).setter(PutObjectRequest.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("Path").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutObjectRequest.getter(PutObjectRequest::contentType)).setter(PutObjectRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutObjectRequest.getter(PutObjectRequest::cacheControl)).setter(PutObjectRequest.setter(Builder::cacheControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutObjectRequest.getter(PutObjectRequest::storageClassAsString)).setter(PutObjectRequest.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-storage-class").build()}).build();
    private static final SdkField<String> UPLOAD_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutObjectRequest.getter(PutObjectRequest::uploadAvailabilityAsString)).setter(PutObjectRequest.setter(Builder::uploadAvailability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-upload-availability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, CONTENT_TYPE_FIELD, CACHE_CONTROL_FIELD, STORAGE_CLASS_FIELD, UPLOAD_AVAILABILITY_FIELD));
    private final String path;
    private final String contentType;
    private final String cacheControl;
    private final String storageClass;
    private final String uploadAvailability;

    private PutObjectRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.contentType = builder.contentType;
        this.cacheControl = builder.cacheControl;
        this.storageClass = builder.storageClass;
        this.uploadAvailability = builder.uploadAvailability;
    }

    public String path() {
        return this.path;
    }

    public String contentType() {
        return this.contentType;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public UploadAvailability uploadAvailability() {
        return UploadAvailability.fromValue(this.uploadAvailability);
    }

    public String uploadAvailabilityAsString() {
        return this.uploadAvailability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadAvailabilityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectRequest)) {
            return false;
        }
        PutObjectRequest other = (PutObjectRequest)((Object)obj);
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.uploadAvailabilityAsString(), other.uploadAvailabilityAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutObjectRequest").add("Path", (Object)this.path()).add("ContentType", (Object)this.contentType()).add("CacheControl", (Object)this.cacheControl()).add("StorageClass", (Object)this.storageClassAsString()).add("UploadAvailability", (Object)this.uploadAvailabilityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "CacheControl": {
                return Optional.ofNullable(clazz.cast(this.cacheControl()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "UploadAvailability": {
                return Optional.ofNullable(clazz.cast(this.uploadAvailabilityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectRequest, T> g) {
        return obj -> g.apply((PutObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreDataRequest.BuilderImpl
    implements Builder {
        private String path;
        private String contentType;
        private String cacheControl;
        private String storageClass;
        private String uploadAvailability;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectRequest model) {
            super(model);
            this.path(model.path);
            this.contentType(model.contentType);
            this.cacheControl(model.cacheControl);
            this.storageClass(model.storageClass);
            this.uploadAvailability(model.uploadAvailability);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getUploadAvailability() {
            return this.uploadAvailability;
        }

        @Override
        public final Builder uploadAvailability(String uploadAvailability) {
            this.uploadAvailability = uploadAvailability;
            return this;
        }

        @Override
        public final Builder uploadAvailability(UploadAvailability uploadAvailability) {
            this.uploadAvailability(uploadAvailability == null ? null : uploadAvailability.toString());
            return this;
        }

        public final void setUploadAvailability(String uploadAvailability) {
            this.uploadAvailability = uploadAvailability;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutObjectRequest build() {
            return new PutObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaStoreDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutObjectRequest> {
        public Builder path(String var1);

        public Builder contentType(String var1);

        public Builder cacheControl(String var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder uploadAvailability(String var1);

        public Builder uploadAvailability(UploadAvailability var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

