/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataSourceErrorInfoType {
    TIMEOUT("TIMEOUT"),
    ENGINE_VERSION_NOT_SUPPORTED("ENGINE_VERSION_NOT_SUPPORTED"),
    UNKNOWN_HOST("UNKNOWN_HOST"),
    GENERIC_SQL_FAILURE("GENERIC_SQL_FAILURE"),
    CONFLICT("CONFLICT"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSourceErrorInfoType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceErrorInfoType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSourceErrorInfoType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceErrorInfoType> knownValues() {
        return Stream.of(DataSourceErrorInfoType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

