/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceSearchSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaceSearchSettings> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FaceSearchSettings.getter(FaceSearchSettings::collectionId)).setter(FaceSearchSettings.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<Float> FACE_MATCH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(FaceSearchSettings.getter(FaceSearchSettings::faceMatchThreshold)).setter(FaceSearchSettings.setter(Builder::faceMatchThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatchThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, FACE_MATCH_THRESHOLD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String collectionId;
    private final Float faceMatchThreshold;

    private FaceSearchSettings(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatchThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceSearchSettings)) {
            return false;
        }
        FaceSearchSettings other = (FaceSearchSettings)obj;
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.faceMatchThreshold(), other.faceMatchThreshold());
    }

    public String toString() {
        return ToString.builder((String)"FaceSearchSettings").add("CollectionId", (Object)this.collectionId()).add("FaceMatchThreshold", (Object)this.faceMatchThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "FaceMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.faceMatchThreshold()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaceSearchSettings, T> g) {
        return obj -> g.apply((FaceSearchSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectionId;
        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceSearchSettings model) {
            this.collectionId(model.collectionId);
            this.faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        public FaceSearchSettings build() {
            return new FaceSearchSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaceSearchSettings> {
        public Builder collectionId(String var1);

        public Builder faceMatchThreshold(Float var1);
    }
}

