/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Celebrity;
import software.amazon.awssdk.services.rekognition.model.CelebrityListCopier;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.ComparedFaceListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecognizeCelebritiesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, RecognizeCelebritiesResponse> {
    private static final SdkField<List<Celebrity>> CELEBRITY_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RecognizeCelebritiesResponse.getter(RecognizeCelebritiesResponse::celebrityFaces)).setter(RecognizeCelebritiesResponse.setter(Builder::celebrityFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CelebrityFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Celebrity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ComparedFace>> UNRECOGNIZED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RecognizeCelebritiesResponse.getter(RecognizeCelebritiesResponse::unrecognizedFaces)).setter(RecognizeCelebritiesResponse.setter(Builder::unrecognizedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnrecognizedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComparedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecognizeCelebritiesResponse.getter(RecognizeCelebritiesResponse::orientationCorrectionAsString)).setter(RecognizeCelebritiesResponse.setter(Builder::orientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELEBRITY_FACES_FIELD, UNRECOGNIZED_FACES_FIELD, ORIENTATION_CORRECTION_FIELD));
    private final List<Celebrity> celebrityFaces;
    private final List<ComparedFace> unrecognizedFaces;
    private final String orientationCorrection;

    private RecognizeCelebritiesResponse(BuilderImpl builder) {
        super(builder);
        this.celebrityFaces = builder.celebrityFaces;
        this.unrecognizedFaces = builder.unrecognizedFaces;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public boolean hasCelebrityFaces() {
        return this.celebrityFaces != null && !(this.celebrityFaces instanceof SdkAutoConstructList);
    }

    public List<Celebrity> celebrityFaces() {
        return this.celebrityFaces;
    }

    public boolean hasUnrecognizedFaces() {
        return this.unrecognizedFaces != null && !(this.unrecognizedFaces instanceof SdkAutoConstructList);
    }

    public List<ComparedFace> unrecognizedFaces() {
        return this.unrecognizedFaces;
    }

    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public String orientationCorrectionAsString() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.celebrityFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.unrecognizedFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeCelebritiesResponse)) {
            return false;
        }
        RecognizeCelebritiesResponse other = (RecognizeCelebritiesResponse)((Object)obj);
        return Objects.equals(this.celebrityFaces(), other.celebrityFaces()) && Objects.equals(this.unrecognizedFaces(), other.unrecognizedFaces()) && Objects.equals(this.orientationCorrectionAsString(), other.orientationCorrectionAsString());
    }

    public String toString() {
        return ToString.builder((String)"RecognizeCelebritiesResponse").add("CelebrityFaces", this.celebrityFaces()).add("UnrecognizedFaces", this.unrecognizedFaces()).add("OrientationCorrection", (Object)this.orientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CelebrityFaces": {
                return Optional.ofNullable(clazz.cast(this.celebrityFaces()));
            }
            case "UnrecognizedFaces": {
                return Optional.ofNullable(clazz.cast(this.unrecognizedFaces()));
            }
            case "OrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.orientationCorrectionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecognizeCelebritiesResponse, T> g) {
        return obj -> g.apply((RecognizeCelebritiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<Celebrity> celebrityFaces = DefaultSdkAutoConstructList.getInstance();
        private List<ComparedFace> unrecognizedFaces = DefaultSdkAutoConstructList.getInstance();
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeCelebritiesResponse model) {
            super(model);
            this.celebrityFaces(model.celebrityFaces);
            this.unrecognizedFaces(model.unrecognizedFaces);
            this.orientationCorrection(model.orientationCorrection);
        }

        public final Collection<Celebrity.Builder> getCelebrityFaces() {
            return this.celebrityFaces != null ? (Collection)this.celebrityFaces.stream().map(Celebrity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder celebrityFaces(Collection<Celebrity> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copy(celebrityFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrityFaces(Celebrity ... celebrityFaces) {
            this.celebrityFaces(Arrays.asList(celebrityFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrityFaces(Consumer<Celebrity.Builder> ... celebrityFaces) {
            this.celebrityFaces(Stream.of(celebrityFaces).map(c -> (Celebrity)((Celebrity.Builder)Celebrity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCelebrityFaces(Collection<Celebrity.BuilderImpl> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copyFromBuilder(celebrityFaces);
        }

        public final Collection<ComparedFace.Builder> getUnrecognizedFaces() {
            return this.unrecognizedFaces != null ? (Collection)this.unrecognizedFaces.stream().map(ComparedFace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copy(unrecognizedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedFaces(ComparedFace ... unrecognizedFaces) {
            this.unrecognizedFaces(Arrays.asList(unrecognizedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedFaces(Consumer<ComparedFace.Builder> ... unrecognizedFaces) {
            this.unrecognizedFaces(Stream.of(unrecognizedFaces).map(c -> (ComparedFace)((ComparedFace.Builder)ComparedFace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnrecognizedFaces(Collection<ComparedFace.BuilderImpl> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copyFromBuilder(unrecognizedFaces);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public RecognizeCelebritiesResponse build() {
            return new RecognizeCelebritiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RecognizeCelebritiesResponse> {
        public Builder celebrityFaces(Collection<Celebrity> var1);

        public Builder celebrityFaces(Celebrity ... var1);

        public Builder celebrityFaces(Consumer<Celebrity.Builder> ... var1);

        public Builder unrecognizedFaces(Collection<ComparedFace> var1);

        public Builder unrecognizedFaces(ComparedFace ... var1);

        public Builder unrecognizedFaces(Consumer<ComparedFace.Builder> ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

