/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.model;

import java.io.File;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.multipart.PauseObservable;
import software.amazon.awssdk.services.s3.multipart.S3ResumeToken;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultFileUpload
implements FileUpload {
    private static final Logger log = Logger.loggerFor(DefaultFileUpload.class);
    private final Lazy<ResumableFileUpload> resumableFileUpload;
    private final CompletableFuture<CompletedFileUpload> completionFuture;
    private final TransferProgress progress;
    private final UploadFileRequest request;
    private final PauseObservable pauseObservable;

    public DefaultFileUpload(CompletableFuture<CompletedFileUpload> completionFuture, TransferProgress progress, PauseObservable pauseObservable, UploadFileRequest request) {
        this.completionFuture = (CompletableFuture)Validate.paramNotNull(completionFuture, (String)"completionFuture");
        this.progress = (TransferProgress)Validate.paramNotNull((Object)progress, (String)"progress");
        this.request = (UploadFileRequest)Validate.paramNotNull((Object)request, (String)"request");
        this.pauseObservable = pauseObservable;
        this.resumableFileUpload = new Lazy(this::doPause);
    }

    @Override
    public ResumableFileUpload pause() {
        if (this.pauseObservable == null) {
            throw new UnsupportedOperationException("Pausing an upload is not supported in a non CRT-based S3Client that does not have multipart configuration enabled. For upload pause support, pass a CRT-based S3Client or an S3Client with multipart enabled to S3TransferManager.");
        }
        return (ResumableFileUpload)this.resumableFileUpload.getValue();
    }

    private ResumableFileUpload doPause() {
        File sourceFile = this.request.source().toFile();
        Instant fileLastModified = Instant.ofEpochMilli(sourceFile.lastModified());
        ResumableFileUpload.Builder resumableFileBuilder = ResumableFileUpload.builder().fileLastModified(fileLastModified).fileLength(sourceFile.length()).uploadFileRequest(this.request);
        boolean futureCompletedExceptionally = this.completionFuture.isCompletedExceptionally();
        if (this.completionFuture.isDone() && !futureCompletedExceptionally) {
            log.debug(() -> "The upload future was finished and was not completed exceptionally. There will be no S3ResumeToken returned.");
            return (ResumableFileUpload)resumableFileBuilder.build();
        }
        S3ResumeToken token = this.pauseObservable.pause();
        if (token == null) {
            log.debug(() -> "The upload hasn't started yet, or it's a single object upload. There will be no S3ResumeToken returned.");
            return (ResumableFileUpload)resumableFileBuilder.build();
        }
        if (futureCompletedExceptionally) {
            log.debug(() -> "The upload future was completed exceptionally but has been successfully paused and a S3ResumeToken was returned.");
        } else {
            log.debug(() -> "The upload was successfully paused and a S3ResumeToken was returned.");
        }
        return (ResumableFileUpload)resumableFileBuilder.multipartUploadId(token.uploadId()).totalParts(token.totalNumParts()).transferredParts(token.numPartsCompleted()).partSizeInBytes(token.partSize()).build();
    }

    @Override
    public CompletableFuture<CompletedFileUpload> completionFuture() {
        return this.completionFuture;
    }

    @Override
    public TransferProgress progress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileUpload that = (DefaultFileUpload)o;
        if (!this.resumableFileUpload.equals(that.resumableFileUpload)) {
            return false;
        }
        if (!this.completionFuture.equals(that.completionFuture)) {
            return false;
        }
        if (!this.progress.equals(that.progress)) {
            return false;
        }
        if (!this.request.equals(that.request)) {
            return false;
        }
        return this.pauseObservable == that.pauseObservable;
    }

    public int hashCode() {
        int result = this.resumableFileUpload.hashCode();
        result = 31 * result + this.completionFuture.hashCode();
        result = 31 * result + this.progress.hashCode();
        result = 31 * result + this.request.hashCode();
        result = 31 * result + this.pauseObservable.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DefaultFileUpload").add("completionFuture", this.completionFuture).add("progress", (Object)this.progress).add("request", (Object)this.request).build();
    }
}

