/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.serialization;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TraitType;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.transfer.s3.internal.serialization.TransferManagerMarshallingUtils;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.DateUtils;

@FunctionalInterface
@SdkInternalApi
public interface TransferManagerJsonUnmarshaller<T> {
    public static final TransferManagerJsonUnmarshaller<String> STRING = (val, sdkField) -> val;
    public static final TransferManagerJsonUnmarshaller<Short> SHORT = (val, sdkField) -> Short.parseShort(val);
    public static final TransferManagerJsonUnmarshaller<Integer> INTEGER = (val, sdkField) -> Integer.parseInt(val);
    public static final TransferManagerJsonUnmarshaller<Long> LONG = (val, sdkField) -> Long.parseLong(val);
    public static final TransferManagerJsonUnmarshaller<Void> NULL = (val, sdkField) -> null;
    public static final TransferManagerJsonUnmarshaller<Float> FLOAT = (val, sdkField) -> Float.valueOf(Float.parseFloat(val));
    public static final TransferManagerJsonUnmarshaller<Double> DOUBLE = (val, sdkField) -> Double.parseDouble(val);
    public static final TransferManagerJsonUnmarshaller<BigDecimal> BIG_DECIMAL = (val, sdkField) -> new BigDecimal(val);
    public static final TransferManagerJsonUnmarshaller<Boolean> BOOLEAN = (val, sdkField) -> Boolean.parseBoolean(val);
    public static final TransferManagerJsonUnmarshaller<SdkBytes> SDK_BYTES = (content, sdkField) -> SdkBytes.fromByteArray((byte[])BinaryUtils.fromBase64((String)content));
    public static final TransferManagerJsonUnmarshaller<Instant> INSTANT = new TransferManagerJsonUnmarshaller<Instant>(){

        @Override
        public Instant unmarshall(String value, SdkField<?> field) {
            if (value == null) {
                return null;
            }
            return this.safeParseDate(DateUtils::parseUnixTimestampInstant).apply(value);
        }

        private Function<String, Instant> safeParseDate(Function<String, Instant> dateUnmarshaller) {
            return value -> {
                try {
                    return (Instant)dateUnmarshaller.apply((String)value);
                }
                catch (NumberFormatException e) {
                    throw SdkClientException.builder().message("Unable to parse date : " + value).cause((Throwable)e).build();
                }
            };
        }
    };
    public static final TransferManagerJsonUnmarshaller<Map<String, Object>> MAP = new TransferManagerJsonUnmarshaller<Map<String, Object>>(){

        @Override
        public Map<String, Object> unmarshall(JsonNode jsonContent, SdkField<?> field) {
            if (jsonContent == null) {
                return null;
            }
            SdkField valueInfo = ((MapTrait)field.getTrait(MapTrait.class, TraitType.MAP_TRAIT)).valueFieldInfo();
            HashMap<String, Object> map = new HashMap<String, Object>();
            jsonContent.asObject().forEach((fieldName, value) -> {
                TransferManagerJsonUnmarshaller<?> unmarshaller = TransferManagerMarshallingUtils.getUnmarshaller(valueInfo.marshallingType());
                map.put((String)fieldName, unmarshaller.unmarshall((JsonNode)value));
            });
            return map;
        }

        @Override
        public Map<String, Object> unmarshall(String content, SdkField<?> field) {
            return this.unmarshall(JsonNode.parser().parse(content), (SdkField)field);
        }
    };
    public static final TransferManagerJsonUnmarshaller<List<Integer>> LIST_INT = new TransferManagerJsonUnmarshaller<List<Integer>>(){

        @Override
        public List<Integer> unmarshall(JsonNode jsonContent, SdkField<?> field) {
            if (jsonContent == null) {
                return null;
            }
            return jsonContent.asArray().stream().map(INTEGER::unmarshall).collect(Collectors.toList());
        }

        @Override
        public List<Integer> unmarshall(String content, SdkField<?> field) {
            return this.unmarshall(JsonNode.parser().parse(content), (SdkField)field);
        }
    };

    default public T unmarshall(JsonNode jsonContent, SdkField<?> field) {
        return jsonContent != null && !jsonContent.isNull() ? (T)this.unmarshall(jsonContent.text(), field) : null;
    }

    default public T unmarshall(JsonNode jsonContent) {
        return this.unmarshall(jsonContent, null);
    }

    public T unmarshall(String var1, SdkField<?> var2);
}

