/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionLogging;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOrigins;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionDetails> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionDetails.getter(AwsCloudFrontDistributionDetails::domainName)).setter(AwsCloudFrontDistributionDetails.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionDetails.getter(AwsCloudFrontDistributionDetails::eTag)).setter(AwsCloudFrontDistributionDetails.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionDetails.getter(AwsCloudFrontDistributionDetails::lastModifiedTime)).setter(AwsCloudFrontDistributionDetails.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<AwsCloudFrontDistributionLogging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AwsCloudFrontDistributionDetails.getter(AwsCloudFrontDistributionDetails::logging)).setter(AwsCloudFrontDistributionDetails.setter(Builder::logging)).constructor(AwsCloudFrontDistributionLogging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging").build()}).build();
    private static final SdkField<AwsCloudFrontDistributionOrigins> ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AwsCloudFrontDistributionDetails.getter(AwsCloudFrontDistributionDetails::origins)).setter(AwsCloudFrontDistributionDetails.setter(Builder::origins)).constructor(AwsCloudFrontDistributionOrigins::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionDetails.getter(AwsCloudFrontDistributionDetails::status)).setter(AwsCloudFrontDistributionDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionDetails.getter(AwsCloudFrontDistributionDetails::webAclId)).setter(AwsCloudFrontDistributionDetails.setter(Builder::webAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, E_TAG_FIELD, LAST_MODIFIED_TIME_FIELD, LOGGING_FIELD, ORIGINS_FIELD, STATUS_FIELD, WEB_ACL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String eTag;
    private final String lastModifiedTime;
    private final AwsCloudFrontDistributionLogging logging;
    private final AwsCloudFrontDistributionOrigins origins;
    private final String status;
    private final String webAclId;

    private AwsCloudFrontDistributionDetails(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.eTag = builder.eTag;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.logging = builder.logging;
        this.origins = builder.origins;
        this.status = builder.status;
        this.webAclId = builder.webAclId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String eTag() {
        return this.eTag;
    }

    public String lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public AwsCloudFrontDistributionLogging logging() {
        return this.logging;
    }

    public AwsCloudFrontDistributionOrigins origins() {
        return this.origins;
    }

    public String status() {
        return this.status;
    }

    public String webAclId() {
        return this.webAclId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.origins());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAclId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionDetails)) {
            return false;
        }
        AwsCloudFrontDistributionDetails other = (AwsCloudFrontDistributionDetails)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.webAclId(), other.webAclId());
    }

    public String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionDetails").add("DomainName", (Object)this.domainName()).add("ETag", (Object)this.eTag()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Logging", (Object)this.logging()).add("Origins", (Object)this.origins()).add("Status", (Object)this.status()).add("WebAclId", (Object)this.webAclId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "Origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "WebAclId": {
                return Optional.ofNullable(clazz.cast(this.webAclId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionDetails, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String eTag;
        private String lastModifiedTime;
        private AwsCloudFrontDistributionLogging logging;
        private AwsCloudFrontDistributionOrigins origins;
        private String status;
        private String webAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionDetails model) {
            this.domainName(model.domainName);
            this.eTag(model.eTag);
            this.lastModifiedTime(model.lastModifiedTime);
            this.logging(model.logging);
            this.origins(model.origins);
            this.status(model.status);
            this.webAclId(model.webAclId);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final AwsCloudFrontDistributionLogging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(AwsCloudFrontDistributionLogging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(AwsCloudFrontDistributionLogging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final AwsCloudFrontDistributionOrigins.Builder getOrigins() {
            return this.origins != null ? this.origins.toBuilder() : null;
        }

        @Override
        public final Builder origins(AwsCloudFrontDistributionOrigins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(AwsCloudFrontDistributionOrigins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getWebAclId() {
            return this.webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        public AwsCloudFrontDistributionDetails build() {
            return new AwsCloudFrontDistributionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionDetails> {
        public Builder domainName(String var1);

        public Builder eTag(String var1);

        public Builder lastModifiedTime(String var1);

        public Builder logging(AwsCloudFrontDistributionLogging var1);

        default public Builder logging(Consumer<AwsCloudFrontDistributionLogging.Builder> logging) {
            return this.logging((AwsCloudFrontDistributionLogging)((AwsCloudFrontDistributionLogging.Builder)AwsCloudFrontDistributionLogging.builder().applyMutation(logging)).build());
        }

        public Builder origins(AwsCloudFrontDistributionOrigins var1);

        default public Builder origins(Consumer<AwsCloudFrontDistributionOrigins.Builder> origins) {
            return this.origins((AwsCloudFrontDistributionOrigins)((AwsCloudFrontDistributionOrigins.Builder)AwsCloudFrontDistributionOrigins.builder().applyMutation(origins)).build());
        }

        public Builder status(String var1);

        public Builder webAclId(String var1);
    }
}

