/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDocumentPermissionResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeDocumentPermissionResponse.Builder, DescribeDocumentPermissionResponse> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(DescribeDocumentPermissionResponse::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AccountSharingInfo>> ACCOUNT_SHARING_INFO_LIST_FIELD = SdkField
            .<List<AccountSharingInfo>> builder(MarshallingType.LIST)
            .memberName("AccountSharingInfoList")
            .getter(getter(DescribeDocumentPermissionResponse::accountSharingInfoList))
            .setter(setter(Builder::accountSharingInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSharingInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountSharingInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountSharingInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            ACCOUNT_SHARING_INFO_LIST_FIELD));

    private final List<String> accountIds;

    private final List<AccountSharingInfo> accountSharingInfoList;

    private DescribeDocumentPermissionResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.accountSharingInfoList = builder.accountSharingInfoList;
    }

    /**
     * Returns true if the AccountIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The account IDs that have permission to use this document. The ID can be either an AWS account or
     *         <i>All</i>.
     */
    public List<String> accountIds() {
        return accountIds;
    }

    /**
     * Returns true if the AccountSharingInfoList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAccountSharingInfoList() {
        return accountSharingInfoList != null && !(accountSharingInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS accounts where the current document is shared and the version shared with each account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountSharingInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS accounts where the current document is shared and the version shared with each account.
     */
    public List<AccountSharingInfo> accountSharingInfoList() {
        return accountSharingInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(accountSharingInfoList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionResponse)) {
            return false;
        }
        DescribeDocumentPermissionResponse other = (DescribeDocumentPermissionResponse) obj;
        return Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(accountSharingInfoList(), other.accountSharingInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDocumentPermissionResponse").add("AccountIds", accountIds())
                .add("AccountSharingInfoList", accountSharingInfoList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "AccountSharingInfoList":
            return Optional.ofNullable(clazz.cast(accountSharingInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentPermissionResponse, T> g) {
        return obj -> g.apply((DescribeDocumentPermissionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
        /**
         * <p>
         * The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.
         * </p>
         * 
         * @param accountIds
         *        The account IDs that have permission to use this document. The ID can be either an AWS account or
         *        <i>All</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.
         * </p>
         * 
         * @param accountIds
         *        The account IDs that have permission to use this document. The ID can be either an AWS account or
         *        <i>All</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * A list of AWS accounts where the current document is shared and the version shared with each account.
         * </p>
         * 
         * @param accountSharingInfoList
         *        A list of AWS accounts where the current document is shared and the version shared with each account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSharingInfoList(Collection<AccountSharingInfo> accountSharingInfoList);

        /**
         * <p>
         * A list of AWS accounts where the current document is shared and the version shared with each account.
         * </p>
         * 
         * @param accountSharingInfoList
         *        A list of AWS accounts where the current document is shared and the version shared with each account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSharingInfoList(AccountSharingInfo... accountSharingInfoList);

        /**
         * <p>
         * A list of AWS accounts where the current document is shared and the version shared with each account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountSharingInfo>.Builder} avoiding the
         * need to create one manually via {@link List<AccountSharingInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountSharingInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #accountSharingInfoList(List<AccountSharingInfo>)}.
         * 
         * @param accountSharingInfoList
         *        a consumer that will call methods on {@link List<AccountSharingInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSharingInfoList(List<AccountSharingInfo>)
         */
        Builder accountSharingInfoList(Consumer<AccountSharingInfo.Builder>... accountSharingInfoList);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<AccountSharingInfo> accountSharingInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionResponse model) {
            super(model);
            accountIds(model.accountIds);
            accountSharingInfoList(model.accountSharingInfoList);
        }

        public final Collection<String> getAccountIds() {
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        public final Collection<AccountSharingInfo.Builder> getAccountSharingInfoList() {
            return accountSharingInfoList != null ? accountSharingInfoList.stream().map(AccountSharingInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountSharingInfoList(Collection<AccountSharingInfo> accountSharingInfoList) {
            this.accountSharingInfoList = AccountSharingInfoListCopier.copy(accountSharingInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSharingInfoList(AccountSharingInfo... accountSharingInfoList) {
            accountSharingInfoList(Arrays.asList(accountSharingInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSharingInfoList(Consumer<AccountSharingInfo.Builder>... accountSharingInfoList) {
            accountSharingInfoList(Stream.of(accountSharingInfoList)
                    .map(c -> AccountSharingInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountSharingInfoList(Collection<AccountSharingInfo.BuilderImpl> accountSharingInfoList) {
            this.accountSharingInfoList = AccountSharingInfoListCopier.copyFromBuilder(accountSharingInfoList);
        }

        @Override
        public DescribeDocumentPermissionResponse build() {
            return new DescribeDocumentPermissionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
