/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInventoryDeletionsResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeInventoryDeletionsResponse.Builder, DescribeInventoryDeletionsResponse> {
    private static final SdkField<List<InventoryDeletionStatusItem>> INVENTORY_DELETIONS_FIELD = SdkField
            .<List<InventoryDeletionStatusItem>> builder(MarshallingType.LIST)
            .memberName("InventoryDeletions")
            .getter(getter(DescribeInventoryDeletionsResponse::inventoryDeletions))
            .setter(setter(Builder::inventoryDeletions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryDeletions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryDeletionStatusItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryDeletionStatusItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInventoryDeletionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVENTORY_DELETIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InventoryDeletionStatusItem> inventoryDeletions;

    private final String nextToken;

    private DescribeInventoryDeletionsResponse(BuilderImpl builder) {
        super(builder);
        this.inventoryDeletions = builder.inventoryDeletions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InventoryDeletions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInventoryDeletions() {
        return inventoryDeletions != null && !(inventoryDeletions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of status items for deleted inventory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInventoryDeletions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of status items for deleted inventory.
     */
    public List<InventoryDeletionStatusItem> inventoryDeletions() {
        return inventoryDeletions;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inventoryDeletions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInventoryDeletionsResponse)) {
            return false;
        }
        DescribeInventoryDeletionsResponse other = (DescribeInventoryDeletionsResponse) obj;
        return Objects.equals(inventoryDeletions(), other.inventoryDeletions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInventoryDeletionsResponse").add("InventoryDeletions", inventoryDeletions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InventoryDeletions":
            return Optional.ofNullable(clazz.cast(inventoryDeletions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInventoryDeletionsResponse, T> g) {
        return obj -> g.apply((DescribeInventoryDeletionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInventoryDeletionsResponse> {
        /**
         * <p>
         * A list of status items for deleted inventory.
         * </p>
         * 
         * @param inventoryDeletions
         *        A list of status items for deleted inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryDeletions(Collection<InventoryDeletionStatusItem> inventoryDeletions);

        /**
         * <p>
         * A list of status items for deleted inventory.
         * </p>
         * 
         * @param inventoryDeletions
         *        A list of status items for deleted inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryDeletions(InventoryDeletionStatusItem... inventoryDeletions);

        /**
         * <p>
         * A list of status items for deleted inventory.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InventoryDeletionStatusItem>.Builder}
         * avoiding the need to create one manually via {@link List<InventoryDeletionStatusItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryDeletionStatusItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #inventoryDeletions(List<InventoryDeletionStatusItem>)}.
         * 
         * @param inventoryDeletions
         *        a consumer that will call methods on {@link List<InventoryDeletionStatusItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inventoryDeletions(List<InventoryDeletionStatusItem>)
         */
        Builder inventoryDeletions(Consumer<InventoryDeletionStatusItem.Builder>... inventoryDeletions);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<InventoryDeletionStatusItem> inventoryDeletions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInventoryDeletionsResponse model) {
            super(model);
            inventoryDeletions(model.inventoryDeletions);
            nextToken(model.nextToken);
        }

        public final Collection<InventoryDeletionStatusItem.Builder> getInventoryDeletions() {
            return inventoryDeletions != null ? inventoryDeletions.stream().map(InventoryDeletionStatusItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inventoryDeletions(Collection<InventoryDeletionStatusItem> inventoryDeletions) {
            this.inventoryDeletions = InventoryDeletionsListCopier.copy(inventoryDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryDeletions(InventoryDeletionStatusItem... inventoryDeletions) {
            inventoryDeletions(Arrays.asList(inventoryDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryDeletions(Consumer<InventoryDeletionStatusItem.Builder>... inventoryDeletions) {
            inventoryDeletions(Stream.of(inventoryDeletions)
                    .map(c -> InventoryDeletionStatusItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInventoryDeletions(Collection<InventoryDeletionStatusItem.BuilderImpl> inventoryDeletions) {
            this.inventoryDeletions = InventoryDeletionsListCopier.copyFromBuilder(inventoryDeletions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInventoryDeletionsResponse build() {
            return new DescribeInventoryDeletionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
