/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The mapping between a patch group and the patch baseline the patch group is registered with.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchGroupPatchBaselineMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<PatchGroupPatchBaselineMapping.Builder, PatchGroupPatchBaselineMapping> {
    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchGroup").getter(getter(PatchGroupPatchBaselineMapping::patchGroup))
            .setter(setter(Builder::patchGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()).build();

    private static final SdkField<PatchBaselineIdentity> BASELINE_IDENTITY_FIELD = SdkField
            .<PatchBaselineIdentity> builder(MarshallingType.SDK_POJO).memberName("BaselineIdentity")
            .getter(getter(PatchGroupPatchBaselineMapping::baselineIdentity)).setter(setter(Builder::baselineIdentity))
            .constructor(PatchBaselineIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_GROUP_FIELD,
            BASELINE_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String patchGroup;

    private final PatchBaselineIdentity baselineIdentity;

    private PatchGroupPatchBaselineMapping(BuilderImpl builder) {
        this.patchGroup = builder.patchGroup;
        this.baselineIdentity = builder.baselineIdentity;
    }

    /**
     * <p>
     * The name of the patch group registered with the patch baseline.
     * </p>
     * 
     * @return The name of the patch group registered with the patch baseline.
     */
    public String patchGroup() {
        return patchGroup;
    }

    /**
     * <p>
     * The patch baseline the patch group is registered with.
     * </p>
     * 
     * @return The patch baseline the patch group is registered with.
     */
    public PatchBaselineIdentity baselineIdentity() {
        return baselineIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(baselineIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchGroupPatchBaselineMapping)) {
            return false;
        }
        PatchGroupPatchBaselineMapping other = (PatchGroupPatchBaselineMapping) obj;
        return Objects.equals(patchGroup(), other.patchGroup()) && Objects.equals(baselineIdentity(), other.baselineIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PatchGroupPatchBaselineMapping").add("PatchGroup", patchGroup())
                .add("BaselineIdentity", baselineIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchGroup":
            return Optional.ofNullable(clazz.cast(patchGroup()));
        case "BaselineIdentity":
            return Optional.ofNullable(clazz.cast(baselineIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchGroupPatchBaselineMapping, T> g) {
        return obj -> g.apply((PatchGroupPatchBaselineMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchGroupPatchBaselineMapping> {
        /**
         * <p>
         * The name of the patch group registered with the patch baseline.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group registered with the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * The patch baseline the patch group is registered with.
         * </p>
         * 
         * @param baselineIdentity
         *        The patch baseline the patch group is registered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentity(PatchBaselineIdentity baselineIdentity);

        /**
         * <p>
         * The patch baseline the patch group is registered with.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchBaselineIdentity.Builder} avoiding the need
         * to create one manually via {@link PatchBaselineIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchBaselineIdentity.Builder#build()} is called immediately and
         * its result is passed to {@link #baselineIdentity(PatchBaselineIdentity)}.
         * 
         * @param baselineIdentity
         *        a consumer that will call methods on {@link PatchBaselineIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineIdentity(PatchBaselineIdentity)
         */
        default Builder baselineIdentity(Consumer<PatchBaselineIdentity.Builder> baselineIdentity) {
            return baselineIdentity(PatchBaselineIdentity.builder().applyMutation(baselineIdentity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String patchGroup;

        private PatchBaselineIdentity baselineIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchGroupPatchBaselineMapping model) {
            patchGroup(model.patchGroup);
            baselineIdentity(model.baselineIdentity);
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final PatchBaselineIdentity.Builder getBaselineIdentity() {
            return baselineIdentity != null ? baselineIdentity.toBuilder() : null;
        }

        @Override
        public final Builder baselineIdentity(PatchBaselineIdentity baselineIdentity) {
            this.baselineIdentity = baselineIdentity;
            return this;
        }

        public final void setBaselineIdentity(PatchBaselineIdentity.BuilderImpl baselineIdentity) {
            this.baselineIdentity = baselineIdentity != null ? baselineIdentity.build() : null;
        }

        @Override
        public PatchGroupPatchBaselineMapping build() {
            return new PatchGroupPatchBaselineMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
