/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.services.swf.model.WorkflowTypeInfo;
import software.amazon.awssdk.services.swf.model.WorkflowTypeInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowTypesResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, ListWorkflowTypesResponse> {
    private static final SdkField<List<WorkflowTypeInfo>> TYPE_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListWorkflowTypesResponse.getter(ListWorkflowTypesResponse::typeInfos)).setter(ListWorkflowTypesResponse.setter(Builder::typeInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowTypeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWorkflowTypesResponse.getter(ListWorkflowTypesResponse::nextPageToken)).setter(ListWorkflowTypesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_INFOS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<WorkflowTypeInfo> typeInfos;
    private final String nextPageToken;

    private ListWorkflowTypesResponse(BuilderImpl builder) {
        super(builder);
        this.typeInfos = builder.typeInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasTypeInfos() {
        return this.typeInfos != null && !(this.typeInfos instanceof SdkAutoConstructList);
    }

    public List<WorkflowTypeInfo> typeInfos() {
        return this.typeInfos;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowTypesResponse)) {
            return false;
        }
        ListWorkflowTypesResponse other = (ListWorkflowTypesResponse)((Object)obj);
        return Objects.equals(this.typeInfos(), other.typeInfos()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListWorkflowTypesResponse").add("TypeInfos", this.typeInfos()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "typeInfos": {
                return Optional.ofNullable(clazz.cast(this.typeInfos()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowTypesResponse, T> g) {
        return obj -> g.apply((ListWorkflowTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private List<WorkflowTypeInfo> typeInfos = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowTypesResponse model) {
            super(model);
            this.typeInfos(model.typeInfos);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<WorkflowTypeInfo.Builder> getTypeInfos() {
            return this.typeInfos != null ? (Collection)this.typeInfos.stream().map(WorkflowTypeInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typeInfos(Collection<WorkflowTypeInfo> typeInfos) {
            this.typeInfos = WorkflowTypeInfoListCopier.copy(typeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(WorkflowTypeInfo ... typeInfos) {
            this.typeInfos(Arrays.asList(typeInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(Consumer<WorkflowTypeInfo.Builder> ... typeInfos) {
            this.typeInfos(Stream.of(typeInfos).map(c -> (WorkflowTypeInfo)((WorkflowTypeInfo.Builder)WorkflowTypeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTypeInfos(Collection<WorkflowTypeInfo.BuilderImpl> typeInfos) {
            this.typeInfos = WorkflowTypeInfoListCopier.copyFromBuilder(typeInfos);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListWorkflowTypesResponse build() {
            return new ListWorkflowTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowTypesResponse> {
        public Builder typeInfos(Collection<WorkflowTypeInfo> var1);

        public Builder typeInfos(WorkflowTypeInfo ... var1);

        public Builder typeInfos(Consumer<WorkflowTypeInfo.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

