/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartWorkflowExecutionRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, StartWorkflowExecutionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::domain)).setter(StartWorkflowExecutionRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::workflowId)).setter(StartWorkflowExecutionRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::workflowType)).setter(StartWorkflowExecutionRequest.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::taskList)).setter(StartWorkflowExecutionRequest.setter(Builder::taskList)).constructor(TaskList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()}).build();
    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::taskPriority)).setter(StartWorkflowExecutionRequest.setter(Builder::taskPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::input)).setter(StartWorkflowExecutionRequest.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::executionStartToCloseTimeout)).setter(StartWorkflowExecutionRequest.setter(Builder::executionStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout").build()}).build();
    private static final SdkField<List<String>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::tagList)).setter(StartWorkflowExecutionRequest.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::taskStartToCloseTimeout)).setter(StartWorkflowExecutionRequest.setter(Builder::taskStartToCloseTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build()}).build();
    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::childPolicyAsString)).setter(StartWorkflowExecutionRequest.setter(Builder::childPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()}).build();
    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartWorkflowExecutionRequest.getter(StartWorkflowExecutionRequest::lambdaRole)).setter(StartWorkflowExecutionRequest.setter(Builder::lambdaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, WORKFLOW_ID_FIELD, WORKFLOW_TYPE_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD, INPUT_FIELD, EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TAG_LIST_FIELD, TASK_START_TO_CLOSE_TIMEOUT_FIELD, CHILD_POLICY_FIELD, LAMBDA_ROLE_FIELD));
    private final String domain;
    private final String workflowId;
    private final WorkflowType workflowType;
    private final TaskList taskList;
    private final String taskPriority;
    private final String input;
    private final String executionStartToCloseTimeout;
    private final List<String> tagList;
    private final String taskStartToCloseTimeout;
    private final String childPolicy;
    private final String lambdaRole;

    private StartWorkflowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.tagList = builder.tagList;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.lambdaRole = builder.lambdaRole;
    }

    public String domain() {
        return this.domain;
    }

    public String workflowId() {
        return this.workflowId;
    }

    public WorkflowType workflowType() {
        return this.workflowType;
    }

    public TaskList taskList() {
        return this.taskList;
    }

    public String taskPriority() {
        return this.taskPriority;
    }

    public String input() {
        return this.input;
    }

    public String executionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public List<String> tagList() {
        return this.tagList;
    }

    public String taskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(this.childPolicy);
    }

    public String childPolicyAsString() {
        return this.childPolicy;
    }

    public String lambdaRole() {
        return this.lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskList());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagList());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowExecutionRequest)) {
            return false;
        }
        StartWorkflowExecutionRequest other = (StartWorkflowExecutionRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.workflowType(), other.workflowType()) && Objects.equals(this.taskList(), other.taskList()) && Objects.equals(this.taskPriority(), other.taskPriority()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.executionStartToCloseTimeout(), other.executionStartToCloseTimeout()) && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.taskStartToCloseTimeout(), other.taskStartToCloseTimeout()) && Objects.equals(this.childPolicyAsString(), other.childPolicyAsString()) && Objects.equals(this.lambdaRole(), other.lambdaRole());
    }

    public String toString() {
        return ToString.builder((String)"StartWorkflowExecutionRequest").add("Domain", (Object)this.domain()).add("WorkflowId", (Object)this.workflowId()).add("WorkflowType", (Object)this.workflowType()).add("TaskList", (Object)this.taskList()).add("TaskPriority", (Object)this.taskPriority()).add("Input", (Object)this.input()).add("ExecutionStartToCloseTimeout", (Object)this.executionStartToCloseTimeout()).add("TagList", this.tagList()).add("TaskStartToCloseTimeout", (Object)this.taskStartToCloseTimeout()).add("ChildPolicy", (Object)this.childPolicyAsString()).add("LambdaRole", (Object)this.lambdaRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "taskList": {
                return Optional.ofNullable(clazz.cast(this.taskList()));
            }
            case "taskPriority": {
                return Optional.ofNullable(clazz.cast(this.taskPriority()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "executionStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionStartToCloseTimeout()));
            }
            case "tagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "taskStartToCloseTimeout": {
                return Optional.ofNullable(clazz.cast(this.taskStartToCloseTimeout()));
            }
            case "childPolicy": {
                return Optional.ofNullable(clazz.cast(this.childPolicyAsString()));
            }
            case "lambdaRole": {
                return Optional.ofNullable(clazz.cast(this.lambdaRole()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartWorkflowExecutionRequest, T> g) {
        return obj -> g.apply((StartWorkflowExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String workflowId;
        private WorkflowType workflowType;
        private TaskList taskList;
        private String taskPriority;
        private String input;
        private String executionStartToCloseTimeout;
        private List<String> tagList = DefaultSdkAutoConstructList.getInstance();
        private String taskStartToCloseTimeout;
        private String childPolicy;
        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowExecutionRequest model) {
            super(model);
            this.domain(model.domain);
            this.workflowId(model.workflowId);
            this.workflowType(model.workflowType);
            this.taskList(model.taskList);
            this.taskPriority(model.taskPriority);
            this.input(model.input);
            this.executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            this.tagList(model.tagList);
            this.taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            this.childPolicy(model.childPolicy);
            this.lambdaRole(model.lambdaRole);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final TaskList.Builder getTaskList() {
            return this.taskList != null ? this.taskList.toBuilder() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return this.executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final Collection<String> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        public final String getTaskStartToCloseTimeout() {
            return this.taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final String getLambdaRole() {
            return this.lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWorkflowExecutionRequest build() {
            return new StartWorkflowExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartWorkflowExecutionRequest> {
        public Builder domain(String var1);

        public Builder workflowId(String var1);

        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder taskList(TaskList var1);

        default public Builder taskList(Consumer<TaskList.Builder> taskList) {
            return this.taskList((TaskList)((TaskList.Builder)TaskList.builder().applyMutation(taskList)).build());
        }

        public Builder taskPriority(String var1);

        public Builder input(String var1);

        public Builder executionStartToCloseTimeout(String var1);

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder taskStartToCloseTimeout(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder lambdaRole(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

