/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingListener;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.j2ssh.forwarding.XDisplay;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketPermission;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingClient
implements ChannelFactory {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$forwarding$ForwardingClient == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingClient = ForwardingClient.class$("com.sshtools.j2ssh.forwarding.ForwardingClient")) : class$com$sshtools$j2ssh$forwarding$ForwardingClient));
    public static final String REMOTE_FORWARD_REQUEST = "tcpip-forward";
    public static final String REMOTE_FORWARD_CANCEL_REQUEST = "cancel-tcpip-forward";
    private ConnectionProtocol connection;
    private List channelTypes = new Vector();
    private Map localForwardings = new HashMap();
    private Map remoteForwardings = new HashMap();
    private XDisplay xDisplay;
    private ForwardingConfiguration x11ForwardingConfiguration;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingClient;

    public ForwardingClient(ConnectionProtocol connectionProtocol) throws IOException {
        this.connection = connectionProtocol;
        connectionProtocol.addChannelFactory("forwarded-tcpip", this);
        connectionProtocol.addChannelFactory("x11", this);
    }

    public List getChannelType() {
        return this.channelTypes;
    }

    public void enableX11Forwarding(XDisplay xDisplay) {
        this.xDisplay = xDisplay;
        this.x11ForwardingConfiguration = new ForwardingConfiguration("x11", "", 0, this.xDisplay.getHost(), this.xDisplay.getPort());
    }

    public ForwardingConfiguration getX11ForwardingConfiguration() {
        return this.x11ForwardingConfiguration;
    }

    public boolean hasActiveConfigurations() {
        if (this.localForwardings.size() == 0 && this.remoteForwardings.size() == 0) {
            return false;
        }
        Iterator iterator = this.localForwardings.values().iterator();
        while (iterator.hasNext()) {
            if (((ForwardingConfiguration)iterator.next()).getState().getValue() != 1) continue;
            return true;
        }
        iterator = this.remoteForwardings.values().iterator();
        while (iterator.hasNext()) {
            if (((ForwardingConfiguration)iterator.next()).getState().getValue() != 1) continue;
            return true;
        }
        return false;
    }

    public void synchronizeConfiguration(SshConnectionProperties sshConnectionProperties) {
        Iterator iterator;
        ForwardingConfiguration forwardingConfiguration = null;
        if (sshConnectionProperties.getLocalForwardings().size() > 0) {
            iterator = sshConnectionProperties.getLocalForwardings().values().iterator();
            while (iterator.hasNext()) {
                try {
                    forwardingConfiguration = (ForwardingConfiguration)iterator.next();
                    forwardingConfiguration = this.addLocalForwarding(forwardingConfiguration);
                    if (!sshConnectionProperties.getForwardingAutoStartMode()) continue;
                    this.startLocalForwarding(forwardingConfiguration.getName());
                }
                catch (Throwable throwable) {
                    log.warn((Object)("Failed to start local forwarding " + forwardingConfiguration != null ? forwardingConfiguration.getName() : ""), throwable);
                }
            }
        }
        if (sshConnectionProperties.getRemoteForwardings().size() > 0) {
            iterator = sshConnectionProperties.getRemoteForwardings().values().iterator();
            while (iterator.hasNext()) {
                try {
                    forwardingConfiguration = (ForwardingConfiguration)iterator.next();
                    this.addRemoteForwarding(forwardingConfiguration);
                    if (!sshConnectionProperties.getForwardingAutoStartMode()) continue;
                    this.startRemoteForwarding(forwardingConfiguration.getName());
                }
                catch (Throwable throwable) {
                    log.warn((Object)("Failed to start remote forwarding " + forwardingConfiguration != null ? forwardingConfiguration.getName() : ""), throwable);
                }
            }
        }
    }

    public boolean hasActiveForwardings() {
        if (this.localForwardings.size() == 0 && this.remoteForwardings.size() == 0) {
            return false;
        }
        Iterator iterator = this.localForwardings.values().iterator();
        while (iterator.hasNext()) {
            if (((ForwardingConfiguration)iterator.next()).getActiveForwardingSocketChannels().size() <= 0) continue;
            return true;
        }
        iterator = this.remoteForwardings.values().iterator();
        while (iterator.hasNext()) {
            if (((ForwardingConfiguration)iterator.next()).getActiveForwardingSocketChannels().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public ForwardingConfiguration getLocalForwardingByAddress(String string, int n) throws ForwardingConfigurationException {
        Iterator iterator = this.localForwardings.values().iterator();
        while (iterator.hasNext()) {
            ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
            return forwardingConfiguration;
        }
        throw new ForwardingConfigurationException("The configuration does not exist");
    }

    public ForwardingConfiguration getLocalForwardingByName(String string) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The configuraiton does not exist!");
        }
        return (ForwardingConfiguration)this.localForwardings.get(string);
    }

    public ForwardingConfiguration getRemoteForwardingByName(String string) throws ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The configuraiton does not exist!");
        }
        return (ForwardingConfiguration)this.remoteForwardings.get(string);
    }

    public Map getLocalForwardings() {
        return this.localForwardings;
    }

    public Map getRemoteForwardings() {
        return this.remoteForwardings;
    }

    public ForwardingConfiguration getRemoteForwardingByAddress(String string, int n) throws ForwardingConfigurationException {
        Iterator iterator = this.remoteForwardings.values().iterator();
        while (iterator.hasNext()) {
            ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
            return forwardingConfiguration;
        }
        throw new ForwardingConfigurationException("The configuration does not exist");
    }

    public void removeLocalForwarding(String string) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingListener forwardingListener = (ForwardingListener)this.localForwardings.get(string);
        if (forwardingListener.isRunning()) {
            this.stopLocalForwarding(string);
        }
        this.localForwardings.remove(string);
    }

    public void removeRemoteForwarding(String string) throws IOException, ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingListener forwardingListener = (ForwardingListener)this.remoteForwardings.get(string);
        if (forwardingListener.isRunning()) {
            this.stopRemoteForwarding(string);
        }
        this.remoteForwardings.remove(string);
    }

    public ForwardingConfiguration addLocalForwarding(String string, String string2, int n, String string3, int n2) throws ForwardingConfigurationException {
        if (this.localForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The configuration name already exists!");
        }
        Iterator iterator = this.localForwardings.values().iterator();
        while (iterator.hasNext()) {
            ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string2) || forwardingConfiguration.getPortToBind() != n) continue;
            throw new ForwardingConfigurationException("The address and port are already in use");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SocketPermission(string2 + ":" + String.valueOf(n), "accept,listen"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException("The security manager has denied listen permision on " + string2 + ":" + String.valueOf(n));
            }
        }
        ClientForwardingListener clientForwardingListener = new ClientForwardingListener(string, this.connection, string2, n, string3, n2);
        this.localForwardings.put(string, clientForwardingListener);
        return clientForwardingListener;
    }

    public ForwardingConfiguration addLocalForwarding(ForwardingConfiguration forwardingConfiguration) throws ForwardingConfigurationException {
        return this.addLocalForwarding(forwardingConfiguration.getName(), forwardingConfiguration.getAddressToBind(), forwardingConfiguration.getPortToBind(), forwardingConfiguration.getHostToConnect(), forwardingConfiguration.getPortToConnect());
    }

    public void addRemoteForwarding(String string, String string2, int n, String string3, int n2) throws ForwardingConfigurationException {
        if (this.remoteForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The remote forwaring configuration name already exists!");
        }
        Iterator iterator = this.remoteForwardings.values().iterator();
        while (iterator.hasNext()) {
            ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string2) || forwardingConfiguration.getPortToBind() != n) continue;
            throw new ForwardingConfigurationException("The remote forwarding address and port are already in use");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SocketPermission(string3 + ":" + String.valueOf(n2), "connect"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException("The security manager has denied connect permision on " + string3 + ":" + String.valueOf(n2));
            }
        }
        this.remoteForwardings.put(string, new ForwardingConfiguration(string, string2, n, string3, n2));
    }

    public void addRemoteForwarding(ForwardingConfiguration forwardingConfiguration) throws ForwardingConfigurationException {
        if (this.remoteForwardings.containsKey(forwardingConfiguration.getName())) {
            throw new ForwardingConfigurationException("The remote forwaring configuration name already exists!");
        }
        Iterator iterator = this.remoteForwardings.values().iterator();
        while (iterator.hasNext()) {
            ForwardingConfiguration forwardingConfiguration2 = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration2.getAddressToBind().equals(forwardingConfiguration.getAddressToBind()) || forwardingConfiguration2.getPortToBind() != forwardingConfiguration.getPortToBind()) continue;
            throw new ForwardingConfigurationException("The remote forwarding address and port are already in use");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SocketPermission(forwardingConfiguration.getHostToConnect() + ":" + String.valueOf(forwardingConfiguration.getPortToConnect()), "connect"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException("The security manager has denied connect permision on " + forwardingConfiguration.getHostToConnect() + ":" + String.valueOf(forwardingConfiguration.getPortToConnect()));
            }
        }
        this.remoteForwardings.put(forwardingConfiguration.getName(), forwardingConfiguration);
    }

    public Channel createChannel(String string, byte[] byArray) throws InvalidChannelException {
        if (string.equals("x11")) {
            if (this.xDisplay == null) {
                throw new InvalidChannelException("Local display has not been set for X11 forwarding.");
            }
            try {
                ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                String string2 = byteArrayReader.readString();
                int n = (int)byteArrayReader.readInt();
                log.debug((Object)("Creating socket to " + this.x11ForwardingConfiguration.getHostToConnect() + "/" + this.x11ForwardingConfiguration.getPortToConnect()));
                Socket socket = new Socket(this.x11ForwardingConfiguration.getHostToConnect(), this.x11ForwardingConfiguration.getPortToConnect());
                ForwardingSocketChannel forwardingSocketChannel = this.x11ForwardingConfiguration.createForwardingSocketChannel(string, this.x11ForwardingConfiguration.getHostToConnect(), this.x11ForwardingConfiguration.getPortToConnect(), string2, n);
                forwardingSocketChannel.bindSocket(socket);
                forwardingSocketChannel.addEventListener(this.x11ForwardingConfiguration.monitor);
                return forwardingSocketChannel;
            }
            catch (IOException iOException) {
                throw new InvalidChannelException(iOException.getMessage());
            }
        }
        if (string.equals("forwarded-tcpip")) {
            try {
                ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                String string3 = byteArrayReader.readString();
                int n = (int)byteArrayReader.readInt();
                String string4 = byteArrayReader.readString();
                int n2 = (int)byteArrayReader.readInt();
                ForwardingConfiguration forwardingConfiguration = this.getRemoteForwardingByAddress(string3, n);
                Socket socket = new Socket(forwardingConfiguration.getHostToConnect(), forwardingConfiguration.getPortToConnect());
                ForwardingSocketChannel forwardingSocketChannel = forwardingConfiguration.createForwardingSocketChannel(string, forwardingConfiguration.getHostToConnect(), forwardingConfiguration.getPortToConnect(), string4, n2);
                forwardingSocketChannel.bindSocket(socket);
                forwardingSocketChannel.addEventListener(forwardingConfiguration.monitor);
                return forwardingSocketChannel;
            }
            catch (ForwardingConfigurationException forwardingConfigurationException) {
                throw new InvalidChannelException("No valid forwarding configuration was available for the request address");
            }
            catch (IOException iOException) {
                throw new InvalidChannelException(iOException.getMessage());
            }
        }
        throw new InvalidChannelException("The server can only request a remote forwarding channel or anX11 forwarding channel");
    }

    public void startLocalForwarding(String string) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        try {
            ForwardingListener forwardingListener = (ForwardingListener)this.localForwardings.get(string);
            forwardingListener.start();
        }
        catch (IOException iOException) {
            throw new ForwardingConfigurationException(iOException.getMessage());
        }
    }

    public void startX11Forwarding() throws IOException, ForwardingConfigurationException {
        if (this.x11ForwardingConfiguration == null) {
            throw new ForwardingConfigurationException("X11 forwarding hasn't been enabled.");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(this.x11ForwardingConfiguration.getAddressToBind());
        byteArrayWriter.writeInt(this.x11ForwardingConfiguration.getPortToBind());
        this.x11ForwardingConfiguration.getState().setValue(1);
        if (log.isDebugEnabled()) {
            log.info((Object)"X11 forwarding started");
            log.debug((Object)("Address to bind: " + this.x11ForwardingConfiguration.getAddressToBind()));
            log.debug((Object)("Port to bind: " + String.valueOf(this.x11ForwardingConfiguration.getPortToBind())));
            log.debug((Object)("Host to connect: " + this.x11ForwardingConfiguration.hostToConnect));
            log.debug((Object)("Port to connect: " + this.x11ForwardingConfiguration.portToConnect));
        } else {
            log.info((Object)"Request for X11 rejected.");
        }
    }

    public void startRemoteForwarding(String string) throws IOException, ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)this.remoteForwardings.get(string);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(forwardingConfiguration.getAddressToBind());
        byteArrayWriter.writeInt(forwardingConfiguration.getPortToBind());
        this.connection.sendGlobalRequest(REMOTE_FORWARD_REQUEST, true, byteArrayWriter.toByteArray());
        this.remoteForwardings.put(string, forwardingConfiguration);
        forwardingConfiguration.getState().setValue(1);
        log.info((Object)("Remote forwarding configuration '" + string + "' started"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Address to bind: " + forwardingConfiguration.getAddressToBind()));
            log.debug((Object)("Port to bind: " + String.valueOf(forwardingConfiguration.getPortToBind())));
            log.debug((Object)("Host to connect: " + forwardingConfiguration.hostToConnect));
            log.debug((Object)("Port to connect: " + forwardingConfiguration.portToConnect));
        }
    }

    public void stopLocalForwarding(String string) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingListener forwardingListener = (ForwardingListener)this.localForwardings.get(string);
        forwardingListener.stop();
        log.info((Object)("Local forwarding configuration " + string + "' stopped"));
    }

    public void stopRemoteForwarding(String string) throws IOException, ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(string)) {
            throw new ForwardingConfigurationException("The remote forwarding configuration does not exist");
        }
        ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)this.remoteForwardings.get(string);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(forwardingConfiguration.getAddressToBind());
        byteArrayWriter.writeInt(forwardingConfiguration.getPortToBind());
        this.connection.sendGlobalRequest(REMOTE_FORWARD_CANCEL_REQUEST, true, byteArrayWriter.toByteArray());
        forwardingConfiguration.getState().setValue(2);
        log.info((Object)("Remote forwarding configuration '" + string + "' stopped"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ClientForwardingListener
    extends ForwardingListener {
        public ClientForwardingListener(String string, ConnectionProtocol connectionProtocol, String string2, int n, String string3, int n2) {
            super(string, connectionProtocol, string2, n, string3, n2);
        }

        public ForwardingSocketChannel createChannel(String string, int n, Socket socket) throws ForwardingConfigurationException {
            return this.createForwardingSocketChannel("direct-tcpip", string, n, socket.getInetAddress().getHostAddress(), socket.getPort());
        }
    }
}

