/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FileAttributes {
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    private static final int SSH_FILEXFER_ATTR_SIZE = 1;
    private static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    private static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    private static final int SSH_FILEXFER_ATTR_ACCESSTIME = 8;
    private static final int SSH_FILEXFER_ATTR_CREATETIME = 16;
    private static final int SSH_FILEXFER_ATTR_MODIFYTIME = 32;
    private static final int SSH_FILEXFER_ATTR_ACL = 64;
    private static final int SSH_FILEXFER_ATTR_OWNERGROUP = 128;
    private static final int SSH_FILEXFER_ATTR_EXTENDED = 0x8000000;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    int version = 3;
    long flags = 0L;
    int type;
    UnsignedInteger64 size = null;
    UnsignedInteger32 uid = null;
    UnsignedInteger32 gid = null;
    String owner = null;
    String group = null;
    UnsignedInteger32 permissions = null;
    UnsignedInteger32 atime = null;
    UnsignedInteger32 createtime = null;
    UnsignedInteger32 mtime = null;
    List acl = new Vector();
    Map extended = new HashMap();
    char[] types = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};

    public FileAttributes() {
    }

    public FileAttributes(ByteArrayReader byteArrayReader) throws IOException {
        this.flags = byteArrayReader.readInt();
        if (this.isFlagSet(1)) {
            this.size = byteArrayReader.readUINT64();
        }
        if (this.isFlagSet(2)) {
            this.uid = byteArrayReader.readUINT32();
            this.gid = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(4)) {
            this.permissions = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(8)) {
            this.atime = byteArrayReader.readUINT32();
            this.mtime = byteArrayReader.readUINT32();
        }
        if (this.isFlagSet(0x8000000)) {
            int n = (int)byteArrayReader.readInt();
            for (int i = 0; i < n; ++i) {
                String string = byteArrayReader.readString();
                String string2 = byteArrayReader.readString();
                this.extended.put(string, string2);
            }
        }
    }

    public UnsignedInteger32 getUID() {
        if (this.uid != null) {
            return this.uid;
        }
        return new UnsignedInteger32(0L);
    }

    public void setUID(UnsignedInteger32 unsignedInteger32) {
        this.flags |= 2L;
        this.uid = unsignedInteger32;
    }

    public void setGID(UnsignedInteger32 unsignedInteger32) {
        this.flags |= 2L;
        this.gid = unsignedInteger32;
    }

    public UnsignedInteger32 getGID() {
        if (this.gid != null) {
            return this.gid;
        }
        return new UnsignedInteger32(0L);
    }

    public void setSize(UnsignedInteger64 unsignedInteger64) {
        this.size = unsignedInteger64;
        this.flags = unsignedInteger64 != null ? (this.flags |= 1L) : (this.flags ^= 1L);
    }

    public UnsignedInteger64 getSize() {
        if (this.size != null) {
            return this.size;
        }
        return new UnsignedInteger64("0");
    }

    public void setPermissions(UnsignedInteger32 unsignedInteger32) {
        this.permissions = unsignedInteger32;
        this.flags = unsignedInteger32 != null ? (this.flags |= 4L) : (this.flags ^= 4L);
    }

    public void setPermissionsFromMaskString(String string) {
        if (string.length() != 4) {
            throw new IllegalArgumentException("Mask length must be 4");
        }
        try {
            this.setPermissions(new UnsignedInteger32(String.valueOf(Integer.parseInt(string, 8))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Mask must be 4 digit octal number.");
        }
    }

    public void setPermissions(String string) {
        int n;
        int n2 = 0;
        if (this.permissions != null) {
            n2 |= (this.permissions.intValue() & 0xF000) == 61440 ? 61440 : 0;
            n2 |= (this.permissions.intValue() & 0xC000) == 49152 ? 49152 : 0;
            n2 |= (this.permissions.intValue() & 0xA000) == 40960 ? 40960 : 0;
            n2 |= (this.permissions.intValue() & 0x8000) == 32768 ? 32768 : 0;
            n2 |= (this.permissions.intValue() & 0x6000) == 24576 ? 24576 : 0;
            n2 |= (this.permissions.intValue() & 0x4000) == 16384 ? 16384 : 0;
            n2 |= (this.permissions.intValue() & 0x2000) == 8192 ? 8192 : 0;
            n2 |= (this.permissions.intValue() & 0x1000) == 4096 ? 4096 : 0;
            n2 |= (this.permissions.intValue() & 0x800) == 2048 ? 2048 : 0;
            n2 |= (this.permissions.intValue() & 0x400) == 1024 ? 1024 : 0;
        }
        if ((n = string.length()) >= 1) {
            n2 |= string.charAt(0) == 'r' ? 256 : 0;
        }
        if (n >= 2) {
            n2 |= string.charAt(1) == 'w' ? 128 : 0;
        }
        if (n >= 3) {
            n2 |= string.charAt(2) == 'x' ? 64 : 0;
        }
        if (n >= 4) {
            n2 |= string.charAt(3) == 'r' ? 32 : 0;
        }
        if (n >= 5) {
            n2 |= string.charAt(4) == 'w' ? 16 : 0;
        }
        if (n >= 6) {
            n2 |= string.charAt(5) == 'x' ? 8 : 0;
        }
        if (n >= 7) {
            n2 |= string.charAt(6) == 'r' ? 4 : 0;
        }
        if (n >= 8) {
            n2 |= string.charAt(7) == 'w' ? 2 : 0;
        }
        if (n >= 9) {
            n2 |= string.charAt(8) == 'x' ? 1 : 0;
        }
        this.setPermissions(new UnsignedInteger32(n2));
    }

    public UnsignedInteger32 getPermissions() {
        return this.permissions;
    }

    public void setTimes(UnsignedInteger32 unsignedInteger32, UnsignedInteger32 unsignedInteger322) {
        this.atime = unsignedInteger32;
        this.mtime = unsignedInteger322;
        this.flags = unsignedInteger32 != null ? (this.flags |= 8L) : (this.flags ^= 8L);
    }

    public UnsignedInteger32 getAccessedTime() {
        return this.atime;
    }

    public UnsignedInteger32 getModifiedTime() {
        if (this.mtime != null) {
            return this.mtime;
        }
        return new UnsignedInteger32(0L);
    }

    public Map getExtendedAttributes() {
        return this.extended;
    }

    public boolean isFlagSet(int n) {
        return (this.flags & (long)n) == (long)n;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        if (this.extended.size() > 0) {
            this.flags |= 0x8000000L;
        }
        byteArrayWriter.writeInt(this.flags);
        if (this.isFlagSet(1)) {
            byteArrayWriter.writeUINT64(this.size);
        }
        if (this.isFlagSet(2)) {
            if (this.uid != null) {
                byteArrayWriter.writeUINT32(this.uid);
            } else {
                byteArrayWriter.writeInt(0);
            }
            if (this.gid != null) {
                byteArrayWriter.writeUINT32(this.gid);
            } else {
                byteArrayWriter.writeInt(0);
            }
        }
        if (this.isFlagSet(4)) {
            byteArrayWriter.writeUINT32(this.permissions);
        }
        if (this.isFlagSet(8)) {
            byteArrayWriter.writeUINT32(this.atime);
            byteArrayWriter.writeUINT32(this.mtime);
        }
        if (this.isFlagSet(0x8000000)) {
            byteArrayWriter.writeInt(this.extended.size());
            Iterator iterator = this.extended.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                byteArrayWriter.writeString((String)entry.getKey());
                byteArrayWriter.writeString((String)entry.getValue());
            }
        }
        return byteArrayWriter.toByteArray();
    }

    private int octal(int n, int n2) {
        return (((n >>>= n2) & 4) != 0 ? 4 : 0) + ((n & 2) != 0 ? 2 : 0) + ((n & 1) != 0 ? 1 : 0);
    }

    private String rwxString(int n, int n2) {
        String string = (((n >>>= n2) & 4) != 0 ? "r" : "-") + ((n & 2) != 0 ? "w" : "-");
        string = n2 == 6 && (this.permissions.intValue() & 0x800) == 2048 || n2 == 3 && (this.permissions.intValue() & 0x400) == 1024 ? string + ((n & 1) != 0 ? "s" : "S") : string + ((n & 1) != 0 ? "x" : "-");
        return string;
    }

    public String getPermissionsString() {
        if (this.permissions != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.types[(this.permissions.intValue() & 0xF000) >>> 13]);
            stringBuffer.append(this.rwxString(this.permissions.intValue(), 6));
            stringBuffer.append(this.rwxString(this.permissions.intValue(), 3));
            stringBuffer.append(this.rwxString(this.permissions.intValue(), 0));
            return stringBuffer.toString();
        }
        return "";
    }

    public String getMaskString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('0');
        int n = this.permissions.intValue();
        stringBuffer.append(this.octal(n, 6));
        stringBuffer.append(this.octal(n, 3));
        stringBuffer.append(this.octal(n, 0));
        return stringBuffer.toString();
    }

    public String getModTimeString() {
        if (this.mtime == null) {
            return "";
        }
        long l = this.mtime.longValue() * 1000L;
        long l2 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = l2 - l > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return simpleDateFormat.format(new Date(l));
    }

    public boolean isDirectory() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0x4000) == 16384;
    }

    public boolean isFile() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0x8000) == 32768;
    }

    public boolean isLink() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xA000) == 40960;
    }

    public boolean isFifo() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0x1000) == 4096;
    }

    public boolean isBlock() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0x6000) == 24576;
    }

    public boolean isCharacter() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0x2000) == 8192;
    }

    public boolean isSocket() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xC000) == 49152;
    }
}

