/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.common.configuration.Authorization;
import com.sshtools.daemon.authentication.PublicKeyVerification;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationFileVerification
implements PublicKeyVerification {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$daemon$authentication$AuthorizationFileVerification == null ? (class$com$sshtools$daemon$authentication$AuthorizationFileVerification = AuthorizationFileVerification.class$("com.sshtools.daemon.authentication.AuthorizationFileVerification")) : class$com$sshtools$daemon$authentication$AuthorizationFileVerification));
    static /* synthetic */ Class class$com$sshtools$daemon$authentication$AuthorizationFileVerification;
    static /* synthetic */ Class class$com$sshtools$daemon$configuration$ServerConfiguration;

    public boolean verifyKeySignature(String string, String string2, byte[] byArray, String string3, byte[] byArray2, byte[] byArray3) throws IOException {
        try {
            SshPublicKey sshPublicKey = this.getAuthorizedKey(string, string2, byArray);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeBinaryString(byArray2);
            byteArrayWriter.write(50);
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString(string3);
            byteArrayWriter.writeString("publickey");
            byteArrayWriter.write(1);
            byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
            byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
            if (sshPublicKey.verifySignature(byArray3, byteArrayWriter.toByteArray())) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private SshPublicKey getAuthorizedKey(String string, String string2, byte[] byArray) throws IOException {
        Authorization authorization;
        String string3;
        Comparable<StringBuffer> comparable;
        NativeAuthenticationProvider nativeAuthenticationProvider = NativeAuthenticationProvider.getInstance();
        String string4 = nativeAuthenticationProvider.getHomeDirectory(string);
        if (string4 == null) {
            log.warn((Object)("There is no home directory for " + string + " is available"));
        }
        if (string4 != null) {
            string4 = string4.replace('\\', '/');
        }
        ServerConfiguration serverConfiguration = (ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = AuthorizationFileVerification.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration));
        String string5 = serverConfiguration.getUserConfigDirectory();
        if ((string5 = string5.replace('\\', '/')).indexOf("%D") > -1 && string4 == null) {
            throw new IOException("<UserConfigDirectory> requires home directory, but none available for " + string);
        }
        int n = 0;
        while ((n = string5.indexOf("%D", n + 1)) > -1) {
            comparable = new StringBuffer(string5);
            comparable = ((StringBuffer)comparable).replace(n, n + 1, string4);
            string5 = ((StringBuffer)comparable).toString();
        }
        n = 0;
        while ((n = string5.indexOf("%U", n + 1)) > -1) {
            comparable = new StringBuffer(string5);
            comparable = ((StringBuffer)comparable).replace(n, n + 1, string);
            string5 = ((StringBuffer)comparable).toString();
        }
        if (!(string5 = string5.replace('/', File.separatorChar).trim()).endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        if (!((File)(comparable = new File(string3 = string5 + serverConfiguration.getAuthorizationFile()))).exists()) {
            log.info((Object)("authorizationFile: " + string3 + " does not exist."));
            throw new IOException("authorizationFile: " + string3 + " does not exist.");
        }
        FileInputStream fileInputStream = new FileInputStream((File)comparable);
        try {
            authorization = new Authorization((InputStream)fileInputStream);
        }
        catch (Exception exception) {
            throw new AuthenticationProtocolException("Failed to load authorized keys file " + string3);
        }
        Iterator iterator = authorization.getAuthorizedKeys().iterator();
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance((String)string2);
        SshPublicKey sshPublicKey = null;
        SshPublicKey sshPublicKey2 = sshKeyPair.decodePublicKey(byArray);
        boolean bl = false;
        while (iterator.hasNext()) {
            String string6 = (String)iterator.next();
            comparable = new File(string5 + string6);
            if (!((File)comparable).exists()) {
                comparable = new File(string6);
            }
            if (((File)comparable).exists()) {
                SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(comparable);
                sshPublicKey = sshPublicKeyFile.toPublicKey();
                if (!sshPublicKey.equals((Object)sshPublicKey2)) continue;
                return sshPublicKey;
            }
            log.info((Object)("Failed attempt to load key file " + string6));
        }
        throw new IOException("");
    }

    public boolean acceptKey(String string, String string2, byte[] byArray) throws IOException {
        try {
            this.getAuthorizedKey(string, string2, byArray);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

