/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.BrowseActionListener;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.upgrader.Build;
import org.opends.quicksetup.upgrader.RemoteBuildManager;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.upgrader.ui.BuildListDownloadErrorPanel;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.Utils;

public class ChooseVersionPanel
extends QuickSetupStepPanel {
    private static final Logger LOG = Logger.getLogger(ChooseVersionPanel.class.getName());
    private static final long serialVersionUID = -6941309163077121917L;
    private JLabel lblCurrentVersion = null;
    private JRadioButton rbRemote = null;
    private JRadioButton rbLocal = null;
    private JComboBox cboBuild = null;
    private JLabel lblFile = null;
    private JTextField tfFile = null;
    private JButton butBrowse = null;
    private boolean loadBuildListAttempted = false;
    private RemoteBuildListComboBoxModelCreator bld = null;

    public ChooseVersionPanel(GuiApplication application) {
        super(application);
        this.getBuildLoader();
    }

    public boolean blockingBeginDisplay() {
        return true;
    }

    public void beginDisplay(UserData data) {
        super.beginDisplay(data);
        if (!this.loadBuildListAttempted) {
            int delay = 100;
            ActionListener loadPerformer = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ChooseVersionPanel.this.rbLocal.setSelected(true);
                    ChooseVersionPanel.this.rbRemote.setEnabled(false);
                    ChooseVersionPanel.this.setComponentEnablement();
                    ChooseVersionPanel.this.cboBuild.setRenderer(new BuildListLoadingComboBoxRenderer());
                    try {
                        ChooseVersionPanel.this.loadBuildList();
                    }
                    catch (IOException e) {
                        LOG.log(Level.INFO, "Error loading build list", e);
                    }
                }
            };
            Timer t = new Timer(delay, loadPerformer);
            t.setRepeats(false);
            t.start();
        }
        this.lblCurrentVersion.setText(Utils.getBuildString(this.getApplication().getInstallation()));
    }

    public Object getFieldValue(FieldName fieldName) {
        String s;
        Object value = null;
        if (FieldName.UPGRADE_DOWNLOAD.equals((Object)fieldName)) {
            value = this.rbRemote.isSelected();
        } else if (FieldName.UPGRADE_BUILD_TO_DOWNLOAD.equals((Object)fieldName)) {
            value = this.cboBuild.getSelectedItem();
        } else if (FieldName.UPGRADE_FILE.equals((Object)fieldName) && (s = this.tfFile.getText()) != null && s.length() > 0) {
            value = new File(this.tfFile.getText());
        }
        return value;
    }

    protected Component createInputPanel() {
        JPanel p = UIFactory.makeJPanel();
        LabelFieldDescriptor currentVersionDescriptor = new LabelFieldDescriptor(QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_OLD_VERSION_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_REVIEW_PANEL_OLD_VERSION_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0);
        this.lblCurrentVersion = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, Message.EMPTY, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbRemote = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_REMOTE_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_REMOTE_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbLocal = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_LOCAL_LABEL.get(), QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_LOCAL_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        ButtonGroup grpRemoteLocal = new ButtonGroup();
        grpRemoteLocal.add(this.rbRemote);
        grpRemoteLocal.add(this.rbLocal);
        grpRemoteLocal.setSelected(this.rbRemote.getModel(), true);
        this.cboBuild = UIFactory.makeJComboBox();
        this.cboBuild.setEditable(false);
        this.tfFile = new JTextField();
        this.tfFile.setColumns(20);
        this.butBrowse = UIFactory.makeJButton(QuickSetupMessages.INFO_BROWSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_BROWSE_BUTTON_TOOLTIP.get());
        BrowseActionListener l = new BrowseActionListener(this.tfFile, BrowseActionListener.BrowseType.OPEN_ZIP_FILE, this.getMainWindow());
        this.butBrowse.addActionListener(l);
        this.lblFile = UIFactory.makeJLabel(null, QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_LOCAL_PATH.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        JPanel pnlBrowse = Utilities.createBrowseButtonPanel(this.lblFile, this.tfFile, this.butBrowse);
        ActionListener radioListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChooseVersionPanel.this.setComponentEnablement();
            }
        };
        this.rbRemote.addActionListener(radioListener);
        this.rbLocal.addActionListener(radioListener);
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        p.add((Component)UIFactory.makeJLabel(currentVersionDescriptor), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 23;
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        p.add((Component)this.lblCurrentVersion, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.top = 15;
        gbc.insets.left = 10;
        gbc.anchor = 23;
        p.add((Component)this.rbRemote, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 45;
        gbc.anchor = 21;
        gbc.fill = 2;
        gbc.weightx = 2.0;
        p.add((Component)this.cboBuild, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.5;
        gbc.anchor = 21;
        gbc.fill = 2;
        gbc.insets = UIFactory.getEmptyInsets();
        JPanel fill = UIFactory.makeJPanel();
        p.add((Component)fill, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets.top = 10;
        gbc.insets.left = 10;
        p.add((Component)this.rbLocal, gbc);
        ++gbc.gridy;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.top = 0;
        gbc.insets.left = 45;
        gbc.gridwidth = 0;
        gbc.weightx = 2.0;
        gbc.fill = 1;
        p.add((Component)pnlBrowse, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 21;
        JPanel fill2 = UIFactory.makeJPanel();
        p.add((Component)fill2, gbc);
        JPanel c = p;
        return c;
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_PANEL_TITLE.get();
    }

    protected Message getInstructions() {
        return QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_PANEL_INSTRUCTIONS.get();
    }

    private RemoteBuildListComboBoxModelCreator getBuildLoader() {
        if (this.bld == null) {
            RemoteBuildManager rbm = ((Upgrader)this.getApplication()).getRemoteBuildManager();
            try {
                this.bld = new RemoteBuildListComboBoxModelCreator(rbm);
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "error creating remote build list combo box model creator", e);
            }
        }
        return this.bld;
    }

    private void loadBuildList() throws IOException {
        this.bld.startBackgroundTask();
    }

    private void setComponentEnablement() {
        this.cboBuild.setEnabled(this.rbRemote.isSelected());
        this.lblFile.setEnabled(this.rbLocal.isSelected());
        this.tfFile.setEnabled(this.rbLocal.isSelected());
        this.butBrowse.setEnabled(this.rbLocal.isSelected());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteBuildListComboBoxModelCreator
    extends BackgroundTask<List<Build>> {
        private RemoteBuildManager rbm = null;
        private InputStream in = null;

        public RemoteBuildListComboBoxModelCreator(RemoteBuildManager rbm) throws IOException {
            this.rbm = rbm;
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Error obtaining build list input stream", e);
            }
        }

        @Override
        public List<Build> processBackgroundTask() throws Exception {
            return this.rbm.listBuilds(this.getInputStream());
        }

        @Override
        public void backgroundTaskCompleted(List<Build> buildList, Throwable throwable) {
            DefaultComboBoxModel<Object> cbm = null;
            if (throwable == null) {
                cbm = new DefaultComboBoxModel<Object>(buildList.toArray());
            } else {
                try {
                    Object[] options = new String[]{QuickSetupMessages.INFO_RETRY_BUTTON_LABEL.get().toString(), QuickSetupMessages.INFO_CLOSE_BUTTON_LABEL.get().toString()};
                    int i = JOptionPane.showOptionDialog(ChooseVersionPanel.this.getMainWindow(), new BuildListDownloadErrorPanel(this.rbm, throwable), QuickSetupMessages.INFO_NETWORK_ERROR_TITLE.get().toString(), 0, 0, null, options, null);
                    if (i == 1 || i == -1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ChooseVersionPanel.this.cboBuild.setRenderer(new BuildListErrorComboBoxRenderer());
                                ChooseVersionPanel.this.cboBuild.setEnabled(false);
                                ChooseVersionPanel.this.rbLocal.setSelected(true);
                                ChooseVersionPanel.this.rbRemote.setSelected(false);
                                ChooseVersionPanel.this.rbRemote.setEnabled(false);
                                ChooseVersionPanel.this.setComponentEnablement();
                            }
                        });
                    } else {
                        ChooseVersionPanel.this.loadBuildList();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            final DefaultComboBoxModel<Object> cbmFinal = cbm;
            if (cbm != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChooseVersionPanel.this.loadBuildListAttempted = true;
                        ChooseVersionPanel.this.cboBuild.setModel(cbmFinal);
                        ChooseVersionPanel.this.cboBuild.setRenderer(new DefaultListCellRenderer());
                        ChooseVersionPanel.this.rbLocal.setSelected(false);
                        ChooseVersionPanel.this.rbRemote.setSelected(true);
                        ChooseVersionPanel.this.rbRemote.setEnabled(true);
                        ChooseVersionPanel.this.setComponentEnablement();
                    }
                });
            }
        }

        private InputStream getInputStream() throws IOException {
            if (this.in == null) {
                this.in = this.rbm.getDailyBuildsInputStream(ChooseVersionPanel.this.getMainWindow(), QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_READING_BUILD_INFO.get());
            }
            return this.in;
        }
    }

    private class BuildListLoadingComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7075573664472711599L;

        public BuildListLoadingComboBoxRenderer() {
            super(QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_LOADING_BUILD_INFO.get().toString(), UIFactory.getImageIcon(UIFactory.IconType.WAIT_TINY), 2);
            UIFactory.setTextStyle(this, UIFactory.TextStyle.SECONDARY_STATUS);
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int i, boolean b, boolean b1) {
            return this;
        }
    }

    private class BuildListErrorComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7075573664472711599L;

        public BuildListErrorComboBoxRenderer() {
            super(QuickSetupMessages.INFO_UPGRADE_CHOOSE_VERSION_UNABLE_TO_ACCESS_BUILD_INFO.get().toString(), UIFactory.getImageIcon(UIFactory.IconType.WARNING), 2);
            UIFactory.setTextStyle(this, UIFactory.TextStyle.SECONDARY_STATUS);
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int i, boolean b, boolean b1) {
            return this;
        }
    }
}

