/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import org.opends.messages.Message;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DefinitionResolver;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.ManagedObjectOption;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedObjectDefinition<C extends ConfigurationClient, S extends Configuration> {
    private final String name;
    private final AbstractManagedObjectDefinition<? super C, ? super S> parent;
    private final Collection<Constraint> constraints;
    private final Map<String, PropertyDefinition<?>> propertyDefinitions;
    private final Map<String, RelationDefinition<?, ?>> relationDefinitions;
    private final Set<RelationDefinition<C, S>> reverseRelationDefinitions;
    private final Map<String, PropertyDefinition<?>> allPropertyDefinitions;
    private final Map<String, RelationDefinition<?, ?>> allRelationDefinitions;
    private final Map<String, AggregationPropertyDefinition<?, ?>> aggregationPropertyDefinitions;
    private final Vector<AggregationPropertyDefinition<?, ?>> reverseAggregationPropertyDefinitions;
    private final Map<String, AggregationPropertyDefinition<?, ?>> allAggregationPropertyDefinitions;
    private final Set<Tag> allTags;
    private final Set<ManagedObjectOption> options;
    private final Map<String, AbstractManagedObjectDefinition<? extends C, ? extends S>> children;

    protected AbstractManagedObjectDefinition(String name, AbstractManagedObjectDefinition<? super C, ? super S> parent) {
        this.name = name;
        this.parent = parent;
        this.constraints = new LinkedList<Constraint>();
        this.propertyDefinitions = new HashMap();
        this.relationDefinitions = new HashMap();
        this.reverseRelationDefinitions = new HashSet<RelationDefinition<C, S>>();
        this.allPropertyDefinitions = new HashMap();
        this.allRelationDefinitions = new HashMap();
        this.aggregationPropertyDefinitions = new HashMap();
        this.reverseAggregationPropertyDefinitions = new Vector();
        this.allAggregationPropertyDefinitions = new HashMap();
        this.allTags = new HashSet<Tag>();
        this.options = EnumSet.noneOf(ManagedObjectOption.class);
        this.children = new HashMap<String, AbstractManagedObjectDefinition<? extends C, ? extends S>>();
        if (parent != null) {
            this.registerInParent();
            for (PropertyDefinition<?> propertyDefinition : parent.getAllPropertyDefinitions()) {
                this.allPropertyDefinitions.put(propertyDefinition.getName(), propertyDefinition);
            }
            for (RelationDefinition relationDefinition : parent.getAllRelationDefinitions()) {
                this.allRelationDefinitions.put(relationDefinition.getName(), relationDefinition);
            }
            for (AggregationPropertyDefinition aggregationPropertyDefinition : parent.getAllAggregationPropertyDefinitions()) {
                this.allAggregationPropertyDefinitions.put(aggregationPropertyDefinition.getName(), aggregationPropertyDefinition);
            }
        }
    }

    public final Collection<AbstractManagedObjectDefinition<? extends C, ? extends S>> getAllChildren() {
        ArrayList<AbstractManagedObjectDefinition<C, S>> list = new ArrayList<AbstractManagedObjectDefinition<C, S>>(this.children.values());
        for (AbstractManagedObjectDefinition<C, S> child : this.children.values()) {
            list.addAll(child.getAllChildren());
        }
        return Collections.unmodifiableCollection(list);
    }

    public final Collection<Constraint> getAllConstraints() {
        LinkedList<Constraint> allConstraints = new LinkedList<Constraint>();
        if (this.parent != null) {
            allConstraints.addAll(this.parent.getAllConstraints());
        }
        allConstraints.addAll(this.constraints);
        return allConstraints;
    }

    public final Collection<PropertyDefinition<?>> getAllPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.allPropertyDefinitions.values());
    }

    public final Collection<RelationDefinition<?, ?>> getAllRelationDefinitions() {
        return Collections.unmodifiableCollection(this.allRelationDefinitions.values());
    }

    public final Collection<RelationDefinition<? super C, ? super S>> getAllReverseRelationDefinitions() {
        LinkedList<RelationDefinition<C, S>> rdlist = new LinkedList<RelationDefinition<C, S>>();
        if (this.parent != null) {
            rdlist.addAll(this.parent.getAllReverseRelationDefinitions());
        }
        rdlist.addAll(this.reverseRelationDefinitions);
        return rdlist;
    }

    public final Collection<AggregationPropertyDefinition<?, ?>> getAllAggregationPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.allAggregationPropertyDefinitions.values());
    }

    public final Collection<AggregationPropertyDefinition<?, ?>> getAllReverseAggregationPropertyDefinitions() {
        LinkedList apdlist = new LinkedList();
        if (this.parent != null) {
            apdlist.addAll(this.parent.getAllReverseAggregationPropertyDefinitions());
        }
        apdlist.addAll(this.reverseAggregationPropertyDefinitions);
        return apdlist;
    }

    public final Collection<Tag> getAllTags() {
        return Collections.unmodifiableCollection(this.allTags);
    }

    public final AbstractManagedObjectDefinition<? extends C, ? extends S> getChild(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty managed object name");
        }
        AbstractManagedObjectDefinition<? extends C, ? extends S> d = this.children.get(name);
        if (d == null) {
            for (AbstractManagedObjectDefinition<C, S> child : this.children.values()) {
                try {
                    d = child.getChild(name);
                    break;
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
        if (d == null) {
            throw new IllegalArgumentException("child managed object definition \"" + name + "\" not found");
        }
        return d;
    }

    public final Collection<AbstractManagedObjectDefinition<? extends C, ? extends S>> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public final Collection<Constraint> getConstraints() {
        return Collections.unmodifiableCollection(this.constraints);
    }

    public final Message getDescription() throws UnsupportedOperationException {
        return this.getDescription(Locale.getDefault());
    }

    public final Message getDescription(Locale locale) throws UnsupportedOperationException {
        try {
            return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "description", locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final AbstractManagedObjectDefinition<? super C, ? super S> getParent() {
        return this.parent;
    }

    public final PropertyDefinition<?> getPropertyDefinition(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty property name");
        }
        PropertyDefinition<?> d = this.allPropertyDefinitions.get(name);
        if (d == null) {
            throw new IllegalArgumentException("property definition \"" + name + "\" not found");
        }
        return d;
    }

    public final Collection<PropertyDefinition<?>> getPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.propertyDefinitions.values());
    }

    public final RelationDefinition<?, ?> getRelationDefinition(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty relation name");
        }
        RelationDefinition<?, ?> d = this.allRelationDefinitions.get(name);
        if (d == null) {
            throw new IllegalArgumentException("relation definition \"" + name + "\" not found");
        }
        return d;
    }

    public final Collection<RelationDefinition<?, ?>> getRelationDefinitions() {
        return Collections.unmodifiableCollection(this.relationDefinitions.values());
    }

    public final Collection<RelationDefinition<C, S>> getReverseRelationDefinitions() {
        return Collections.unmodifiableCollection(this.reverseRelationDefinitions);
    }

    public final AggregationPropertyDefinition<?, ?> getAggregationPropertyDefinition(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty aggregation property name");
        }
        AggregationPropertyDefinition<?, ?> d = this.allAggregationPropertyDefinitions.get(name);
        if (d == null) {
            throw new IllegalArgumentException("aggregation property definition \"" + name + "\" not found");
        }
        return d;
    }

    public final Collection<AggregationPropertyDefinition<?, ?>> getAggregationPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.aggregationPropertyDefinitions.values());
    }

    public final Collection<AggregationPropertyDefinition<?, ?>> getReverseAggregationPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.reverseAggregationPropertyDefinitions);
    }

    public final Message getSynopsis() throws UnsupportedOperationException {
        return this.getSynopsis(Locale.getDefault());
    }

    public final Message getSynopsis(Locale locale) throws UnsupportedOperationException {
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "synopsis", locale);
    }

    public final Message getUserFriendlyName() throws UnsupportedOperationException {
        return this.getUserFriendlyName(Locale.getDefault());
    }

    public final Message getUserFriendlyName(Locale locale) throws UnsupportedOperationException {
        return Message.raw(ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "user-friendly-name", locale), new Object[0]);
    }

    public final Message getUserFriendlyPluralName() throws UnsupportedOperationException {
        return this.getUserFriendlyPluralName(Locale.getDefault());
    }

    public final Message getUserFriendlyPluralName(Locale locale) throws UnsupportedOperationException {
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "user-friendly-plural-name", locale);
    }

    public final boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public final boolean hasOption(ManagedObjectOption option) {
        return this.options.contains((Object)option);
    }

    public final boolean hasTag(Tag t) {
        return this.allTags.contains(t);
    }

    public final boolean isChildOf(AbstractManagedObjectDefinition<?, ?> d) {
        AbstractManagedObjectDefinition<? super C, ? super S> i = this;
        while (i != null) {
            if (i == d) {
                return true;
            }
            i = i.parent;
        }
        return false;
    }

    public final boolean isParentOf(AbstractManagedObjectDefinition<?, ?> d) {
        return d.isChildOf(this);
    }

    public final boolean isTop() {
        return this instanceof TopCfgDefn;
    }

    public final ManagedObjectDefinition<? extends C, ? extends S> resolveManagedObjectDefinition(DefinitionResolver r) throws DefinitionDecodingException {
        AbstractManagedObjectDefinition<C, S> rd = this.resolveManagedObjectDefinitionAux(this, r);
        if (rd == null) {
            throw new DefinitionDecodingException(this, DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION);
        }
        if (rd instanceof ManagedObjectDefinition) {
            return (ManagedObjectDefinition)rd;
        }
        throw new DefinitionDecodingException(this, DefinitionDecodingException.Reason.ABSTRACT_TYPE_INFORMATION);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public final void toString(StringBuilder builder) {
        builder.append(this.getName());
    }

    protected final void initialize() throws Exception {
        for (PropertyDefinition<?> propertyDefinition : this.getAllPropertyDefinitions()) {
            propertyDefinition.initialize();
            propertyDefinition.getDefaultBehaviorProvider().initialize();
        }
        for (RelationDefinition relationDefinition : this.getAllRelationDefinitions()) {
            relationDefinition.initialize();
        }
        for (AggregationPropertyDefinition aggregationPropertyDefinition : this.getAllAggregationPropertyDefinitions()) {
            aggregationPropertyDefinition.initialize();
            this.registerReverseAggregationPropertyDefinition(aggregationPropertyDefinition);
        }
        for (Constraint constraint : this.getAllConstraints()) {
            constraint.initialize();
        }
    }

    protected final void registerConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    protected final void registerPropertyDefinition(PropertyDefinition<?> d) {
        String propName = d.getName();
        this.propertyDefinitions.put(propName, d);
        this.allPropertyDefinitions.put(propName, d);
        if (d instanceof AggregationPropertyDefinition) {
            AggregationPropertyDefinition apd = (AggregationPropertyDefinition)d;
            this.aggregationPropertyDefinitions.put(propName, apd);
            this.allAggregationPropertyDefinitions.put(apd.getManagedObjectDefinition().getName() + ":" + propName, apd);
        }
    }

    protected final void registerRelationDefinition(RelationDefinition<?, ?> d) {
        String relName = d.getName();
        this.relationDefinitions.put(relName, d);
        this.allRelationDefinitions.put(relName, d);
        this.registerReverseRelationDefinition(d);
    }

    protected final void registerOption(ManagedObjectOption option) {
        this.options.add(option);
    }

    protected final void registerTag(Tag tag) {
        this.allTags.add(tag);
    }

    final void deregisterConstraint(Constraint constraint) {
        if (!this.constraints.remove(constraint)) {
            throw new RuntimeException("Failed to deregister a constraint");
        }
    }

    final void deregisterRelationDefinition(RelationDefinition<?, ?> d) {
        String relName = d.getName();
        this.relationDefinitions.remove(relName);
        this.allRelationDefinitions.remove(relName);
        d.getChildDefinition().reverseRelationDefinitions.remove(d);
    }

    final void registerInParent() {
        if (this.parent != null) {
            this.parent.children.put(this.name, this);
        }
    }

    private <CC extends ConfigurationClient, SS extends Configuration> void registerReverseRelationDefinition(RelationDefinition<CC, SS> rd) {
        rd.getChildDefinition().reverseRelationDefinitions.add(rd);
    }

    private void registerReverseAggregationPropertyDefinition(AggregationPropertyDefinition<?, ?> apd) {
        apd.getRelationDefinition().getChildDefinition().reverseAggregationPropertyDefinitions.add(apd);
    }

    private AbstractManagedObjectDefinition<? extends C, ? extends S> resolveManagedObjectDefinitionAux(AbstractManagedObjectDefinition<? extends C, ? extends S> d, DefinitionResolver r) {
        if (!r.matches(d)) {
            return null;
        }
        for (AbstractManagedObjectDefinition<C, S> abstractManagedObjectDefinition : d.getChildren()) {
            AbstractManagedObjectDefinition<C, S> rd = this.resolveManagedObjectDefinitionAux(abstractManagedObjectDefinition, r);
            if (rd == null) continue;
            return rd;
        }
        return d;
    }
}

