/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.messages.AdminMessages;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.client.cli.DsFrameworkCliAds;
import org.opends.server.admin.client.cli.DsFrameworkCliGlobalAdmin;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliServer;
import org.opends.server.admin.client.cli.DsFrameworkCliServerGroup;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.SubCommand;

public class DsFrameworkCliParser
extends SecureConnectionCliParser {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final Logger LOG = Logger.getLogger(DsFrameworkCliParser.class.getName());
    public HashSet<DsFrameworkCliSubCommandGroup> cliGroup = new HashSet();

    public DsFrameworkCliParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
    }

    public void initializeParser(OutputStream outStream) throws ArgumentException {
        this.initializeGlobalArguments(this.createGlobalArguments(outStream));
        this.cliGroup.add(new DsFrameworkCliAds());
        this.cliGroup.add(new DsFrameworkCliServerGroup());
        this.cliGroup.add(new DsFrameworkCliServer());
        this.cliGroup.add(new DsFrameworkCliGlobalAdmin());
        Comparator<SubCommand> c = new Comparator<SubCommand>(){

            @Override
            public int compare(SubCommand o1, SubCommand o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<SubCommand> allSubCommands = new TreeSet<SubCommand>(c);
        for (DsFrameworkCliSubCommandGroup oneCli : this.cliGroup) {
            oneCli.initializeCliGroup(this, this.verboseArg);
            Set<SubCommand> oneCliSubCmds = oneCli.getSubCommands();
            allSubCommands.addAll(oneCliSubCmds);
            String grpName = oneCli.getGroupName();
            String option = "help-" + grpName;
            BooleanArgument arg = new BooleanArgument(option, null, option, DSConfigMessages.INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE.get(grpName));
            this.addGlobalArgument(arg);
            arg.setHidden(oneCli.isHidden());
            TreeSet<SubCommand> subCmds = new TreeSet<SubCommand>(c);
            subCmds.addAll(oneCliSubCmds);
            this.setUsageGroupArgument(arg, subCmds);
        }
        String option = "help-all";
        BooleanArgument arg = new BooleanArgument(option, null, option, DSConfigMessages.INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_ALL.get());
        this.addGlobalArgument(arg);
        this.setUsageGroupArgument(arg, allSubCommands);
    }

    public DsFrameworkCliReturnCode performSubCommand(OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        SubCommand subCmd = this.getSubCommand();
        for (DsFrameworkCliSubCommandGroup oneCli : this.cliGroup) {
            if (!oneCli.isSubCommand(subCmd)) continue;
            return oneCli.performSubCommand(subCmd, outStream, errStream);
        }
        return DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
    }

    public InitialLdapContext getContext(OutputStream out, OutputStream err) {
        String host = null;
        String port = null;
        String dn = null;
        String pwd = null;
        InitialLdapContext ctx = null;
        host = ConnectionUtils.getHostNameForLdapUrl(this.getHostName());
        port = this.getPort();
        dn = this.getBindDN();
        pwd = this.getBindPassword(dn, out, err);
        if (this.useSSL()) {
            String ldapsUrl = "ldaps://" + host + ":" + port;
            try {
                ctx = ConnectionUtils.createLdapsContext(ldapsUrl, dn, pwd, ConnectionUtils.getDefaultLDAPTimeout(), null, this.getTrustManager(), this.getKeyManager());
            }
            catch (NamingException e) {
                Message message = AdminMessages.ERR_ADMIN_CANNOT_CONNECT_TO_ADS.get(host);
                try {
                    err.write(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH).getBytes());
                    err.write(EOL.getBytes());
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return null;
            }
        }
        if (this.useStartTLS()) {
            String ldapUrl = "ldap://" + host + ":" + port;
            try {
                ctx = ConnectionUtils.createStartTLSContext(ldapUrl, dn, pwd, ConnectionUtils.getDefaultLDAPTimeout(), null, this.getTrustManager(), this.getKeyManager(), null);
            }
            catch (NamingException e) {
                Message message = AdminMessages.ERR_ADMIN_CANNOT_CONNECT_TO_ADS.get(host);
                try {
                    err.write(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH).getBytes());
                    err.write(EOL.getBytes());
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return null;
            }
        }
        String ldapUrl = "ldap://" + host + ":" + port;
        try {
            ctx = ConnectionUtils.createLdapContext(ldapUrl, dn, pwd, ConnectionUtils.getDefaultLDAPTimeout(), null);
        }
        catch (NamingException e) {
            Message message = AdminMessages.ERR_ADMIN_CANNOT_CONNECT_TO_ADS.get(host);
            try {
                err.write(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH).getBytes());
                err.write(EOL.getBytes());
            }
            catch (IOException e1) {
                // empty catch block
            }
            return null;
        }
        return ctx;
    }
}

