/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;
import org.opends.server.authorization.dseecompat.PatternDN;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPURL;

public class Target {
    private EnumTargetOperator operator = EnumTargetOperator.EQUALITY;
    private boolean isPattern = false;
    private DN urlDN = null;
    private PatternDN patternDN = null;

    private Target(EnumTargetOperator operator, String target, DN aciDN) throws AciException {
        this.operator = operator;
        try {
            if (!target.equals("ldap:///") && !Pattern.matches("\\s*(ldap:///[^\\|]+)", target)) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGETKEYWORD_EXPRESSION.get(target);
                throw new AciException(message);
            }
            LDAPURL targetURL = LDAPURL.decode(target, false);
            if (targetURL.getRawBaseDN().indexOf("*") != -1) {
                this.isPattern = true;
                this.patternDN = PatternDN.decodeSuffix(targetURL.getRawBaseDN());
            } else {
                this.urlDN = targetURL.getBaseDN();
                if (!this.urlDN.isDescendantOf(aciDN)) {
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_TARGET_DN_NOT_DESCENDENTOF.get(this.urlDN.toNormalizedString(), aciDN.toNormalizedString());
                    throw new AciException(message);
                }
            }
        }
        catch (DirectoryException e) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGETKEYWORD_EXPRESSION.get(target);
            throw new AciException(message);
        }
    }

    public static Target decode(EnumTargetOperator operator, String expr, DN aciDN) throws AciException {
        return new Target(operator, expr, aciDN);
    }

    public EnumTargetOperator getOperator() {
        return this.operator;
    }

    public DN getDN() {
        return this.urlDN;
    }

    public boolean isPattern() {
        return this.isPattern;
    }

    public boolean matchesPattern(DN dn) {
        return this.patternDN.matchesDN(dn);
    }
}

