/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.ConnectionHandlerCfgDefn;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandlerConfigManager
implements ConfigurationAddListener<ConnectionHandlerCfg>,
ConfigurationDeleteListener<ConnectionHandlerCfg>,
ConfigurationChangeListener<ConnectionHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, ConnectionHandler> connectionHandlers;

    @Override
    public ConfigChangeResult applyConfigurationAdd(ConnectionHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            DN dn = configuration.dn();
            try {
                ConnectionHandler<? extends ConnectionHandlerCfg> connectionHandler = this.getConnectionHandler(configuration);
                connectionHandler.start();
                this.connectionHandlers.put(dn, connectionHandler);
                DirectoryServer.registerConnectionHandler(connectionHandler);
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(ConfigMessages.ERR_CONFIG_CONNHANDLER_CANNOT_INITIALIZE.get(String.valueOf(configuration.getJavaClass()), String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ConnectionHandlerCfg configuration) {
        DN dn = configuration.dn();
        ConnectionHandler<? extends ConnectionHandlerCfg> connectionHandler = this.connectionHandlers.get(dn);
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (connectionHandler == null) {
            if (configuration.isEnabled()) {
                try {
                    connectionHandler = this.getConnectionHandler(configuration);
                    connectionHandler.start();
                    this.connectionHandlers.put(dn, connectionHandler);
                    DirectoryServer.registerConnectionHandler(connectionHandler);
                }
                catch (ConfigException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    messages.add(e.getMessageObject());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    messages.add(ConfigMessages.ERR_CONFIG_CONNHANDLER_CANNOT_INITIALIZE.get(String.valueOf(configuration.getJavaClass()), String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        } else if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            if (!className.equals(connectionHandler.getClass().getName())) {
                adminActionRequired = true;
            }
        } else {
            DirectoryServer.deregisterConnectionHandler(connectionHandler);
            this.connectionHandlers.remove(dn);
            connectionHandler.finalizeConnectionHandler(CoreMessages.INFO_CONNHANDLER_CLOSED_BY_DISABLE.get(), false);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ConnectionHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        DN dn = configuration.dn();
        ConnectionHandler connectionHandler = this.connectionHandlers.get(dn);
        if (connectionHandler != null) {
            DirectoryServer.deregisterConnectionHandler(connectionHandler);
            this.connectionHandlers.remove(dn);
            connectionHandler.finalizeConnectionHandler(CoreMessages.INFO_CONNHANDLER_CLOSED_BY_DELETE.get(), false);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    public void initializeConnectionHandlerConfig() throws ConfigException, InitializationException {
        this.connectionHandlers = new ConcurrentHashMap();
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addConnectionHandlerAddListener(this);
        root.addConnectionHandlerDeleteListener(this);
        for (String name : root.listConnectionHandlers()) {
            ConnectionHandlerCfg config = root.getConnectionHandler(name);
            config.addChangeListener(this);
            if (!config.isEnabled()) continue;
            ConnectionHandler<? extends ConnectionHandlerCfg> connectionHandler = this.getConnectionHandler(config);
            this.connectionHandlers.put(config.dn(), connectionHandler);
            DirectoryServer.registerConnectionHandler(connectionHandler);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            return this.isJavaClassAcceptable(configuration, unacceptableReasons);
        }
        return true;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            return this.isJavaClassAcceptable(configuration, unacceptableReasons);
        }
        return true;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    private ConnectionHandler<? extends ConnectionHandlerCfg> getConnectionHandler(ConnectionHandlerCfg config) throws ConfigException {
        ConnectionHandler connectionHandler;
        Class<ConnectionHandler> theClass;
        String className = config.getJavaClass();
        ConnectionHandlerCfgDefn d = ConnectionHandlerCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            theClass = pd.loadClass(className, ConnectionHandler.class);
            connectionHandler = theClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_CONNHANDLER_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        try {
            Method method = theClass.getMethod("initializeConnectionHandler", config.configurationClass());
            method.invoke((Object)connectionHandler, config);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_CONNHANDLER_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return connectionHandler;
    }

    private boolean isJavaClassAcceptable(ConnectionHandlerCfg config, List<Message> unacceptableReasons) {
        Class<ConnectionHandler> theClass;
        String className = config.getJavaClass();
        ConnectionHandlerCfgDefn d = ConnectionHandlerCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        ConnectionHandler connectionHandler = null;
        try {
            connectionHandler = this.connectionHandlers.get(config.dn());
            theClass = pd.loadClass(className, ConnectionHandler.class);
            if (connectionHandler == null) {
                connectionHandler = theClass.newInstance();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_CONNHANDLER_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
        try {
            Method method = theClass.getMethod("isConfigurationAcceptable", ConnectionHandlerCfg.class, List.class);
            Boolean acceptable = (Boolean)method.invoke((Object)connectionHandler, config, unacceptableReasons);
            if (!acceptable.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_CONNHANDLER_CANNOT_INITIALIZE.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
        return true;
    }
}

