/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.PasswordGeneratorCfgDefn;
import org.opends.server.admin.std.server.PasswordGeneratorCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordGeneratorConfigManager
implements ConfigurationAddListener<PasswordGeneratorCfg>,
ConfigurationDeleteListener<PasswordGeneratorCfg>,
ConfigurationChangeListener<PasswordGeneratorCfg> {
    private ConcurrentHashMap<DN, PasswordGenerator> passwordGenerators = new ConcurrentHashMap();

    public void initializePasswordGenerators() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addPasswordGeneratorAddListener(this);
        rootConfiguration.addPasswordGeneratorDeleteListener(this);
        for (String generatorName : rootConfiguration.listPasswordGenerators()) {
            PasswordGeneratorCfg generatorConfiguration = rootConfiguration.getPasswordGenerator(generatorName);
            generatorConfiguration.addChangeListener(this);
            if (!generatorConfiguration.isEnabled()) continue;
            String className = generatorConfiguration.getJavaClass();
            try {
                PasswordGenerator<? extends PasswordGeneratorCfg> generator = this.loadGenerator(className, generatorConfiguration, true);
                this.passwordGenerators.put(generatorConfiguration.dn(), generator);
                DirectoryServer.registerPasswordGenerator(generatorConfiguration.dn(), generator);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordGeneratorCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadGenerator(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordGeneratorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        PasswordGenerator existingGenerator = this.passwordGenerators.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingGenerator != null) {
                DirectoryServer.deregisterPasswordGenerator(configuration.dn());
                PasswordGenerator passwordGenerator = this.passwordGenerators.remove(configuration.dn());
                if (passwordGenerator != null) {
                    passwordGenerator.finalizePasswordGenerator();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingGenerator != null) {
            if (!className.equals(existingGenerator.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        PasswordGenerator<? extends PasswordGeneratorCfg> passwordGenerator = null;
        try {
            passwordGenerator = this.loadGenerator(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.passwordGenerators.put(configuration.dn(), passwordGenerator);
            DirectoryServer.registerPasswordGenerator(configuration.dn(), passwordGenerator);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationAddAcceptable(PasswordGeneratorCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadGenerator(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(PasswordGeneratorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        PasswordGenerator<? extends PasswordGeneratorCfg> passwordGenerator = null;
        String className = configuration.getJavaClass();
        try {
            passwordGenerator = this.loadGenerator(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.passwordGenerators.put(configuration.dn(), passwordGenerator);
            DirectoryServer.registerPasswordGenerator(configuration.dn(), passwordGenerator);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(PasswordGeneratorCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(PasswordGeneratorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        PasswordGenerator generator = this.passwordGenerators.remove(configuration.dn());
        if (generator != null) {
            DirectoryServer.deregisterPasswordGenerator(configuration.dn());
            generator.finalizePasswordGenerator();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    private PasswordGenerator<? extends PasswordGeneratorCfg> loadGenerator(String className, PasswordGeneratorCfg configuration, boolean initialize) throws InitializationException {
        try {
            PasswordGeneratorCfgDefn definition = PasswordGeneratorCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<PasswordGenerator> generatorClass = propertyDefinition.loadClass(className, PasswordGenerator.class);
            PasswordGenerator generator = generatorClass.newInstance();
            if (initialize) {
                Method method = generator.getClass().getMethod("initializePasswordGenerator", configuration.configurationClass());
                method.invoke((Object)generator, configuration);
            } else {
                Method method = generator.getClass().getMethod("isConfigurationAcceptable", PasswordGeneratorCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)generator, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_PWGENERATOR_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return generator;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_PWGENERATOR_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

