/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.MessageDescriptor;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCacheCommon {
    public static HashSet<SearchFilter> getFilters(SortedSet<String> filters, MessageDescriptor.Arg3<CharSequence, CharSequence, CharSequence> decodeErrorMsg, ConfigErrorHandler errorHandler, DN configEntryDN) {
        HashSet<SearchFilter> searchFilters = new HashSet<SearchFilter>();
        if (filters != null && !filters.isEmpty()) {
            for (String curFilter : filters) {
                try {
                    searchFilters.add(SearchFilter.createFilterFromString(curFilter));
                }
                catch (DirectoryException de) {
                    Message message = decodeErrorMsg.get(String.valueOf(configEntryDN), curFilter, de.getMessage() != null ? de.getMessage() : StaticUtils.stackTraceToSingleLineString(de));
                    errorHandler.reportError(message, false, ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                }
            }
        }
        return searchFilters;
    }

    public static ConfigErrorHandler getConfigErrorHandler(ConfigPhase configPhase, List<Message> unacceptableReasons, ArrayList<Message> errorMessages) {
        EntryCacheCommon ec;
        ConfigErrorHandler errorHandler = null;
        EntryCacheCommon entryCacheCommon = ec = new EntryCacheCommon();
        entryCacheCommon.getClass();
        errorHandler = entryCacheCommon.new ConfigErrorHandler(configPhase, unacceptableReasons, errorMessages);
        return errorHandler;
    }

    public static ArrayList<Attribute> getGenericMonitorData(Long cacheHits, Long cacheMisses, Long cacheSize, Long maxCacheSize, Long cacheCount, Long maxCacheCount) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (cacheHits != null) {
            AttributeType hitsAttrType = DirectoryServer.getDefaultAttributeType("entryCacheHits");
            LinkedHashSet<AttributeValue> hitsValues = new LinkedHashSet<AttributeValue>();
            hitsValues.add(new AttributeValue(hitsAttrType, cacheHits.toString()));
            attrs.add(new Attribute(hitsAttrType, "entryCacheHits", hitsValues));
            if (cacheMisses != null) {
                AttributeType triesAttrType = DirectoryServer.getDefaultAttributeType("entryCacheTries");
                LinkedHashSet<AttributeValue> triesValues = new LinkedHashSet<AttributeValue>();
                Long cacheTries = cacheHits + cacheMisses;
                triesValues.add(new AttributeValue(triesAttrType, cacheTries.toString()));
                attrs.add(new Attribute(triesAttrType, "entryCacheTries", triesValues));
                AttributeType hitRatioAttrType = DirectoryServer.getDefaultAttributeType("entryCacheHitRatio");
                LinkedHashSet<AttributeValue> hitRatioValues = new LinkedHashSet<AttributeValue>();
                Double hitRatioRaw = cacheTries > 0L ? cacheHits.doubleValue() / cacheTries.doubleValue() : cacheHits.doubleValue() / 1.0;
                Double hitRatio = hitRatioRaw * 100.0;
                hitRatioValues.add(new AttributeValue(hitRatioAttrType, Long.toString(hitRatio.longValue())));
                attrs.add(new Attribute(hitRatioAttrType, "entryCacheHitRatio", hitRatioValues));
            }
        }
        if (cacheSize != null) {
            AttributeType memoryAttrType = DirectoryServer.getDefaultAttributeType("currentEntryCacheSize");
            LinkedHashSet<AttributeValue> memoryValues = new LinkedHashSet<AttributeValue>();
            memoryValues.add(new AttributeValue(memoryAttrType, cacheSize.toString()));
            attrs.add(new Attribute(memoryAttrType, "currentEntryCacheSize", memoryValues));
        }
        if (maxCacheSize != null) {
            AttributeType maxMemoryAttrType = DirectoryServer.getDefaultAttributeType("maxEntryCacheSize");
            LinkedHashSet<AttributeValue> maxMemoryValues = new LinkedHashSet<AttributeValue>();
            maxMemoryValues.add(new AttributeValue(maxMemoryAttrType, maxCacheSize.toString()));
            attrs.add(new Attribute(maxMemoryAttrType, "maxEntryCacheSize", maxMemoryValues));
        }
        if (cacheCount != null) {
            AttributeType entriesAttrType = DirectoryServer.getDefaultAttributeType("currentEntryCacheCount");
            LinkedHashSet<AttributeValue> entriesValues = new LinkedHashSet<AttributeValue>();
            entriesValues.add(new AttributeValue(entriesAttrType, cacheCount.toString()));
            attrs.add(new Attribute(entriesAttrType, "currentEntryCacheCount", entriesValues));
        }
        if (maxCacheCount != null) {
            AttributeType maxEntriesAttrType = DirectoryServer.getDefaultAttributeType("maxEntryCacheCount");
            LinkedHashSet<AttributeValue> maxEntriesValues = new LinkedHashSet<AttributeValue>();
            maxEntriesValues.add(new AttributeValue(maxEntriesAttrType, maxCacheCount.toString()));
            attrs.add(new Attribute(maxEntriesAttrType, "maxEntryCacheCount", maxEntriesValues));
        }
        return attrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigErrorHandler {
        private ConfigPhase _configPhase;
        private List<Message> _unacceptableReasons;
        private ArrayList<Message> _errorMessages;
        private ResultCode _resultCode;
        private boolean _isAcceptable;
        private boolean _isAdminActionRequired;

        public ConfigErrorHandler(ConfigPhase configPhase, List<Message> unacceptableReasons, ArrayList<Message> errorMessages) {
            this._configPhase = configPhase;
            this._unacceptableReasons = unacceptableReasons;
            this._errorMessages = errorMessages;
            this._resultCode = ResultCode.SUCCESS;
            this._isAcceptable = true;
            this._isAdminActionRequired = false;
        }

        public void reportError(Message error, boolean isAcceptable, ResultCode resultCode) {
            switch (this._configPhase) {
                case PHASE_INIT: {
                    this._errorMessages.add(error);
                    this._isAcceptable = isAcceptable;
                    break;
                }
                case PHASE_ACCEPTABLE: {
                    this._unacceptableReasons.add(error);
                    this._isAcceptable = isAcceptable;
                    break;
                }
                case PHASE_APPLY: {
                    this._errorMessages.add(error);
                    this._isAcceptable = isAcceptable;
                    if (this._resultCode != ResultCode.SUCCESS) break;
                    this._resultCode = resultCode;
                }
            }
        }

        public void reportError(Message error, boolean isAcceptable, ResultCode resultCode, boolean isAdminActionRequired) {
            switch (this._configPhase) {
                case PHASE_INIT: {
                    ErrorLogger.logError(error);
                    break;
                }
                case PHASE_ACCEPTABLE: {
                    this._unacceptableReasons.add(error);
                    this._isAcceptable = isAcceptable;
                    break;
                }
                case PHASE_APPLY: {
                    this._errorMessages.add(error);
                    this._isAcceptable = isAcceptable;
                    if (this._resultCode == ResultCode.SUCCESS) {
                        this._resultCode = resultCode;
                    }
                    this._isAdminActionRequired = isAdminActionRequired;
                }
            }
        }

        public ResultCode getResultCode() {
            return this._resultCode;
        }

        public boolean getIsAcceptable() {
            return this._isAcceptable;
        }

        public List<Message> getUnacceptableReasons() {
            return this._unacceptableReasons;
        }

        public ArrayList<Message> getErrorMessages() {
            return this._errorMessages;
        }

        public ConfigPhase getConfigPhase() {
            return this._configPhase;
        }

        public boolean getIsAdminActionRequired() {
            return this._isAdminActionRequired;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigPhase {
        PHASE_INIT,
        PHASE_ACCEPTABLE,
        PHASE_APPLY;

    }
}

