/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.ServerConstants;

public class ModifyDNRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString entryDN;
    private ASN1OctetString newRDN;
    private ASN1OctetString newSuperior;
    private boolean deleteOldRDN;

    public ModifyDNRequestProtocolOp(ASN1OctetString entryDN, ASN1OctetString newRDN, boolean deleteOldRDN) {
        this.entryDN = entryDN;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperior = null;
    }

    public ModifyDNRequestProtocolOp(ASN1OctetString entryDN, ASN1OctetString newRDN, boolean deleteOldRDN, ASN1OctetString newSuperior) {
        this.entryDN = entryDN;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperior = newSuperior;
    }

    public ASN1OctetString getEntryDN() {
        return this.entryDN;
    }

    public void setEntryDN(ASN1OctetString entryDN) {
        this.entryDN = entryDN;
    }

    public ASN1OctetString getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(ASN1OctetString newRDN) {
        this.newRDN = newRDN;
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean deleteOldRDN) {
        this.deleteOldRDN = deleteOldRDN;
    }

    public ASN1OctetString getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(ASN1OctetString newSuperior) {
        this.newSuperior = newSuperior;
    }

    public byte getType() {
        return 108;
    }

    public String getProtocolOpName() {
        return "Modify DN Request";
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(this.entryDN);
        elements.add(this.newRDN);
        elements.add(new ASN1Boolean(this.deleteOldRDN));
        if (this.newSuperior != null) {
            this.newSuperior.setType((byte)-128);
            elements.add(this.newSuperior);
        }
        return new ASN1Sequence(108, elements);
    }

    public static ModifyDNRequestProtocolOp decodeModifyDNRequest(ASN1Element element) throws LDAPException {
        ASN1OctetString newSuperior;
        boolean deleteOldRDN;
        ASN1OctetString newRDN;
        ASN1OctetString entryDN;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements < 3 || numElements > 4) {
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            entryDN = elements.get(0).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            newRDN = elements.get(1).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_NEW_RDN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            deleteOldRDN = elements.get(2).decodeAsBoolean().booleanValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_DELETE_OLD_RDN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        if (numElements == 4) {
            try {
                newSuperior = elements.get(3).decodeAsOctetString();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_MODIFY_DN_REQUEST_DECODE_NEW_SUPERIOR.get(String.valueOf(e));
                throw new LDAPException(2, message, e);
            }
        } else {
            newSuperior = null;
        }
        return new ModifyDNRequestProtocolOp(entryDN, newRDN, deleteOldRDN, newSuperior);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ModifyDNRequest(dn=");
        this.entryDN.toString(buffer);
        buffer.append(", newRDN=");
        this.newRDN.toString(buffer);
        buffer.append(", deleteOldRDN=");
        buffer.append(this.deleteOldRDN);
        if (this.newSuperior != null) {
            buffer.append(", newSuperior=");
            this.newSuperior.toString(buffer);
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Modify DN Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Entry DN:  ");
        this.entryDN.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  New RDN:  ");
        this.newRDN.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Delete Old RDN:  ");
        buffer.append(this.deleteOldRDN);
        buffer.append(ServerConstants.EOL);
        if (this.newSuperior != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  New Superior:  ");
            this.newSuperior.toString(buffer);
            buffer.append(ServerConstants.EOL);
        }
    }
}

