/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.ReplicationSynchronizationProviderCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.BackupTaskListener;
import org.opends.server.api.ExportTaskListener;
import org.opends.server.api.ImportTaskListener;
import org.opends.server.api.RestoreTaskListener;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.plugin.ReplayThread;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.replication.plugin.ReplicationServerListener;
import org.opends.server.replication.plugin.UpdateToReplay;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PluginOperation;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimasterReplication
extends SynchronizationProvider<ReplicationSynchronizationProviderCfg>
implements ConfigurationAddListener<ReplicationDomainCfg>,
ConfigurationDeleteListener<ReplicationDomainCfg>,
ConfigurationChangeListener<ReplicationSynchronizationProviderCfg>,
BackupTaskListener,
RestoreTaskListener,
ImportTaskListener,
ExportTaskListener {
    private ReplicationServerListener replicationServerListener = null;
    private static Map<DN, ReplicationDomain> domains = new HashMap<DN, ReplicationDomain>();
    private static LinkedBlockingQueue<UpdateToReplay> updateToReplayQueue = new LinkedBlockingQueue();
    private static List<ReplayThread> replayThreads = new ArrayList<ReplayThread>();
    private static int replayThreadNumber = 10;
    private boolean isRegistered = false;

    public static ReplicationDomain findDomain(DN dn, PluginOperation pluginOp) {
        if (pluginOp != null && pluginOp instanceof Operation) {
            Operation op = (Operation)((Object)pluginOp);
            if (op.dontSynchronize()) {
                return null;
            }
            for (Control c : op.getRequestControls()) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.2")) continue;
                op.setSynchronizationOperation(true);
                op.setDontSynchronize(true);
                List<Control> controls = op.getRequestControls();
                controls.remove(c);
                return null;
            }
        }
        ReplicationDomain domain = null;
        DN temp = dn;
        do {
            domain = domains.get(temp);
        } while ((temp = temp.getParentDNInSuffix()) != null && domain == null);
        return domain;
    }

    public static ReplicationDomain createNewDomain(ReplicationDomainCfg configuration) throws ConfigException {
        ReplicationDomain domain = new ReplicationDomain(configuration, updateToReplayQueue);
        if (domains.size() == 0) {
            MultimasterReplication.createReplayThreads();
        }
        domains.put(domain.getBaseDN(), domain);
        return domain;
    }

    public static void deleteDomain(DN dn) {
        ReplicationDomain domain = domains.remove(dn);
        if (domain != null) {
            domain.shutdown();
        }
        if (domains.size() == 0) {
            MultimasterReplication.stopReplayThreads();
        }
    }

    @Override
    public void initializeSynchronizationProvider(ReplicationSynchronizationProviderCfg configuration) throws ConfigException {
        domains.clear();
        this.replicationServerListener = new ReplicationServerListener(configuration);
        configuration.addReplicationDomainAddListener(this);
        configuration.addReplicationDomainDeleteListener(this);
        configuration.addReplicationChangeListener(this);
        replayThreadNumber = configuration.getNumUpdateReplayThreads();
        for (String name : configuration.listReplicationDomains()) {
            ReplicationDomainCfg domain = configuration.getReplicationDomain(name);
            MultimasterReplication.createNewDomain(domain);
        }
        List<Modification> offlineSchemaChanges = DirectoryServer.getOfflineSchemaChanges();
        if (offlineSchemaChanges != null && !offlineSchemaChanges.isEmpty()) {
            this.processSchemaChange(offlineSchemaChanges);
        }
        DirectoryServer.registerBackupTaskListener(this);
        DirectoryServer.registerRestoreTaskListener(this);
        DirectoryServer.registerExportTaskListener(this);
        DirectoryServer.registerImportTaskListener(this);
        DirectoryServer.registerSupportedControl("1.3.6.1.4.1.26027.1.5.2");
    }

    private static synchronized void createReplayThreads() {
        replayThreads.clear();
        for (int i = 0; i < replayThreadNumber; ++i) {
            ReplayThread replayThread = new ReplayThread(updateToReplayQueue);
            replayThread.start();
            replayThreads.add(replayThread);
        }
    }

    private static synchronized void stopReplayThreads() {
        for (ReplayThread replayThread : replayThreads) {
            replayThread.shutdown();
        }
        for (ReplayThread replayThread : replayThreads) {
            replayThread.waitForShutdown();
        }
        replayThreads.clear();
    }

    @Override
    public boolean isConfigurationAddAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        return ReplicationDomain.isConfigurationAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ReplicationDomainCfg configuration) {
        try {
            ReplicationDomain rd = MultimasterReplication.createNewDomain(configuration);
            if (this.isRegistered) {
                rd.start();
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }
        catch (ConfigException e) {
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false);
        }
    }

    @Override
    public void doPostOperation(PostOperationAddOperation addOperation) {
        DN dn = addOperation.getEntryDN();
        this.genericPostOperation(addOperation, dn);
    }

    @Override
    public void doPostOperation(PostOperationDeleteOperation deleteOperation) {
        DN dn = deleteOperation.getEntryDN();
        this.genericPostOperation(deleteOperation, dn);
    }

    @Override
    public void doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        DN dn = modifyDNOperation.getEntryDN();
        this.genericPostOperation(modifyDNOperation, dn);
    }

    @Override
    public void doPostOperation(PostOperationModifyOperation modifyOperation) {
        DN dn = modifyOperation.getEntryDN();
        this.genericPostOperation(modifyOperation, dn);
    }

    @Override
    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyOperation modifyOperation) {
        ReplicationDomain domain = MultimasterReplication.findDomain(modifyOperation.getEntryDN(), modifyOperation);
        if (domain == null) {
            return new SynchronizationProviderResult.ContinueProcessing();
        }
        return domain.handleConflictResolution(modifyOperation);
    }

    @Override
    public SynchronizationProviderResult handleConflictResolution(PreOperationAddOperation addOperation) throws DirectoryException {
        ReplicationDomain domain = MultimasterReplication.findDomain(addOperation.getEntryDN(), addOperation);
        if (domain == null) {
            return new SynchronizationProviderResult.ContinueProcessing();
        }
        return domain.handleConflictResolution(addOperation);
    }

    @Override
    public SynchronizationProviderResult handleConflictResolution(PreOperationDeleteOperation deleteOperation) throws DirectoryException {
        ReplicationDomain domain = MultimasterReplication.findDomain(deleteOperation.getEntryDN(), deleteOperation);
        if (domain == null) {
            return new SynchronizationProviderResult.ContinueProcessing();
        }
        return domain.handleConflictResolution(deleteOperation);
    }

    @Override
    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyDNOperation modifyDNOperation) throws DirectoryException {
        ReplicationDomain domain = MultimasterReplication.findDomain(modifyDNOperation.getEntryDN(), modifyDNOperation);
        if (domain == null) {
            return new SynchronizationProviderResult.ContinueProcessing();
        }
        return domain.handleConflictResolution(modifyDNOperation);
    }

    @Override
    public SynchronizationProviderResult doPreOperation(PreOperationModifyOperation modifyOperation) {
        DN operationDN = modifyOperation.getEntryDN();
        ReplicationDomain domain = MultimasterReplication.findDomain(operationDN, modifyOperation);
        if (domain == null || !domain.solveConflict()) {
            return new SynchronizationProviderResult.ContinueProcessing();
        }
        Historical historicalInformation = (Historical)modifyOperation.getAttachment("ds-synch-historical");
        if (historicalInformation == null) {
            Entry entry = modifyOperation.getModifiedEntry();
            historicalInformation = Historical.load(entry);
            modifyOperation.setAttachment("ds-synch-historical", historicalInformation);
        }
        historicalInformation.generateState(modifyOperation);
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    @Override
    public SynchronizationProviderResult doPreOperation(PreOperationDeleteOperation deleteOperation) throws DirectoryException {
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    @Override
    public SynchronizationProviderResult doPreOperation(PreOperationModifyDNOperation modifyDNOperation) throws DirectoryException {
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    @Override
    public SynchronizationProviderResult doPreOperation(PreOperationAddOperation addOperation) {
        ReplicationDomain domain = MultimasterReplication.findDomain(addOperation.getEntryDN(), addOperation);
        if (domain == null) {
            return new SynchronizationProviderResult.ContinueProcessing();
        }
        if (!addOperation.isSynchronizationOperation()) {
            domain.doPreOperation(addOperation);
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    @Override
    public void finalizeSynchronizationProvider() {
        this.isRegistered = false;
        for (ReplicationDomain domain : domains.values()) {
            domain.shutdown();
        }
        domains.clear();
        MultimasterReplication.stopReplayThreads();
        if (this.replicationServerListener != null) {
            this.replicationServerListener.shutdown();
        }
        DirectoryServer.deregisterBackupTaskListener(this);
        DirectoryServer.deregisterRestoreTaskListener(this);
        DirectoryServer.deregisterExportTaskListener(this);
        DirectoryServer.deregisterImportTaskListener(this);
    }

    @Override
    public void processSchemaChange(List<Modification> modifications) {
        ReplicationDomain domain = MultimasterReplication.findDomain(DirectoryServer.getSchemaDN(), null);
        if (domain != null) {
            domain.synchronizeModifications(modifications);
        }
    }

    @Override
    public void processBackupBegin(Backend backend, BackupConfig config) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.backupStart();
        }
    }

    @Override
    public void processBackupEnd(Backend backend, BackupConfig config, boolean successful) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.backupEnd();
        }
    }

    @Override
    public void processRestoreBegin(Backend backend, RestoreConfig config) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.disable();
        }
    }

    @Override
    public void processRestoreEnd(Backend backend, RestoreConfig config, boolean successful) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.enable();
        }
    }

    @Override
    public void processImportBegin(Backend backend, LDIFImportConfig config) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.disable();
        }
    }

    @Override
    public void processImportEnd(Backend backend, LDIFImportConfig config, boolean successful) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.enable();
        }
    }

    @Override
    public void processExportBegin(Backend backend, LDIFExportConfig config) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.backupStart();
        }
    }

    @Override
    public void processExportEnd(Backend backend, LDIFExportConfig config, boolean successful) {
        for (DN dn : backend.getBaseDNs()) {
            ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
            if (domain == null) continue;
            domain.backupEnd();
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ReplicationDomainCfg configuration) {
        MultimasterReplication.deleteDomain(configuration.getBaseDN());
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    private void genericPostOperation(PostOperationOperation operation, DN dn) {
        ReplicationDomain domain = MultimasterReplication.findDomain(dn, operation);
        if (domain == null) {
            return;
        }
        domain.synchronize(operation);
    }

    public ReplicationServerListener getReplicationServerListener() {
        return this.replicationServerListener;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReplicationSynchronizationProviderCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReplicationSynchronizationProviderCfg configuration) {
        int numUpdateRepayThread = configuration.getNumUpdateReplayThreads();
        MultimasterReplication.stopReplayThreads();
        replayThreadNumber = numUpdateRepayThread;
        if (domains.size() > 0) {
            MultimasterReplication.createReplayThreads();
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public void completeSynchronizationProvider() {
        this.isRegistered = true;
        for (ReplicationDomain domain : domains.values()) {
            domain.start();
        }
    }
}

