/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.types.Operation;
import org.opends.server.types.operation.PluginOperation;

public abstract class OperationContext {
    public static final String SYNCHROCONTEXT = "replicationContext";
    private ChangeNumber changeNumber;
    private String entryUid;

    protected OperationContext(ChangeNumber changeNumber, String uid) {
        this.changeNumber = changeNumber;
        this.entryUid = uid;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public String getEntryUid() {
        return this.entryUid;
    }

    public static ChangeNumber getChangeNumber(Operation op) {
        OperationContext ctx = (OperationContext)op.getAttachment(SYNCHROCONTEXT);
        if (ctx == null) {
            return null;
        }
        return ctx.changeNumber;
    }

    public static ChangeNumber getChangeNumber(PluginOperation op) {
        OperationContext ctx = (OperationContext)op.getAttachment(SYNCHROCONTEXT);
        if (ctx == null) {
            return null;
        }
        return ctx.changeNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperationContext) {
            OperationContext ctx = (OperationContext)obj;
            return this.changeNumber.equals(ctx.getChangeNumber()) && this.entryUid.equals(ctx.getEntryUid());
        }
        return false;
    }

    public int hashCode() {
        return this.changeNumber.hashCode() + this.entryUid.hashCode();
    }
}

