/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.LocalBackendWorkflowElementCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.workflowelement.LeafWorkflowElement;
import org.opends.server.workflowelement.localbackend.LocalBackendAddOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendBindOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendCompareOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyDNOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBackendWorkflowElement
extends LeafWorkflowElement<LocalBackendWorkflowElementCfg>
implements ConfigurationChangeListener<LocalBackendWorkflowElementCfg> {
    private Backend backend;
    private static TreeMap<String, LocalBackendWorkflowElement> registeredLocalBackends = new TreeMap();
    private static Object registeredLocalBackendsLock = new Object();

    private void initialize(String workflowElementID, Backend backend) {
        super.initialize(workflowElementID);
        this.backend = backend;
        if (this.backend != null) {
            this.setPrivate(this.backend.isPrivateBackend());
        }
    }

    public void initializeWorkflowElement(LocalBackendWorkflowElementCfg configuration) throws ConfigException, InitializationException {
        configuration.addLocalBackendChangeListener(this);
        this.processWorkflowElementConfig(configuration, true);
    }

    @Override
    public void finalizeWorkflowElement() {
        super.initialize(null);
        this.backend = null;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LocalBackendWorkflowElementCfg configuration, List<Message> unacceptableReasons) {
        boolean isAcceptable = this.processWorkflowElementConfig(configuration, false);
        return isAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LocalBackendWorkflowElementCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        this.processWorkflowElementConfig(configuration, true);
        return changeResult;
    }

    private boolean processWorkflowElementConfig(LocalBackendWorkflowElementCfg configuration, boolean applyChanges) {
        boolean isAcceptable = true;
        if (configuration.isEnabled()) {
            String newBackendID = configuration.getBackend();
            Backend newBackend = DirectoryServer.getBackend(newBackendID);
            if (applyChanges) {
                super.initialize(configuration.getWorkflowElementId());
                this.backend = newBackend;
            }
        }
        return isAcceptable;
    }

    public static LocalBackendWorkflowElement createAndRegister(String workflowElementID, Backend backend) {
        LocalBackendWorkflowElement localBackend = null;
        localBackend = registeredLocalBackends.get(workflowElementID);
        if (localBackend == null) {
            localBackend = new LocalBackendWorkflowElement();
            localBackend.initialize(workflowElementID, backend);
            LocalBackendWorkflowElement.registerLocalBackend(localBackend);
        }
        return localBackend;
    }

    public static void remove(String workflowElementID) {
        LocalBackendWorkflowElement.deregisterLocalBackend(workflowElementID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll() {
        Object object = registeredLocalBackendsLock;
        synchronized (object) {
            for (LocalBackendWorkflowElement localBackend : registeredLocalBackends.values()) {
                LocalBackendWorkflowElement.deregisterLocalBackend(localBackend.getWorkflowElementID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerLocalBackend(LocalBackendWorkflowElement localBackend) {
        Object object = registeredLocalBackendsLock;
        synchronized (object) {
            String localBackendID = localBackend.getWorkflowElementID();
            LocalBackendWorkflowElement existingLocalBackend = registeredLocalBackends.get(localBackendID);
            if (existingLocalBackend == null) {
                TreeMap<String, LocalBackendWorkflowElement> newLocalBackends = new TreeMap<String, LocalBackendWorkflowElement>((SortedMap<String, LocalBackendWorkflowElement>)registeredLocalBackends);
                newLocalBackends.put(localBackendID, localBackend);
                registeredLocalBackends = newLocalBackends;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deregisterLocalBackend(String workflowElementID) {
        Object object = registeredLocalBackendsLock;
        synchronized (object) {
            LocalBackendWorkflowElement existingLocalBackend = registeredLocalBackends.get(workflowElementID);
            if (existingLocalBackend != null) {
                TreeMap<String, LocalBackendWorkflowElement> newLocalBackends = new TreeMap<String, LocalBackendWorkflowElement>((SortedMap<String, LocalBackendWorkflowElement>)registeredLocalBackends);
                newLocalBackends.remove(workflowElementID);
                registeredLocalBackends = newLocalBackends;
            }
        }
    }

    @Override
    public void execute(Operation operation) throws CanceledOperationException {
        switch (operation.getOperationType()) {
            case BIND: {
                LocalBackendBindOperation bindOperation = new LocalBackendBindOperation((BindOperation)operation);
                bindOperation.processLocalBind(this.backend);
                break;
            }
            case SEARCH: {
                LocalBackendSearchOperation searchOperation = new LocalBackendSearchOperation((SearchOperation)operation);
                searchOperation.processLocalSearch(this.backend);
                break;
            }
            case ADD: {
                LocalBackendAddOperation addOperation = new LocalBackendAddOperation((AddOperation)operation);
                addOperation.processLocalAdd(this.backend);
                break;
            }
            case DELETE: {
                LocalBackendDeleteOperation deleteOperation = new LocalBackendDeleteOperation((DeleteOperation)operation);
                deleteOperation.processLocalDelete(this.backend);
                break;
            }
            case MODIFY: {
                LocalBackendModifyOperation modifyOperation = new LocalBackendModifyOperation((ModifyOperation)operation);
                modifyOperation.processLocalModify(this.backend);
                break;
            }
            case MODIFY_DN: {
                LocalBackendModifyDNOperation modifyDNOperation = new LocalBackendModifyDNOperation((ModifyDNOperation)operation);
                modifyDNOperation.processLocalModifyDN(this.backend);
                break;
            }
            case COMPARE: {
                LocalBackendCompareOperation compareOperation = new LocalBackendCompareOperation((CompareOperation)operation);
                compareOperation.processLocalCompare(this.backend);
                break;
            }
            case ABANDON: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Attempted to execute an invalid operation type:  " + (Object)((Object)operation.getOperationType()) + " (" + operation + ")"));
            }
        }
    }

    public static final <O extends Operation, L> void attachLocalOperation(O globalOperation, L currentLocalOperation) {
        List existingAttachment = (List)globalOperation.getAttachment("LocalBackendOperations");
        ArrayList<L> newAttachment = new ArrayList<L>();
        if (existingAttachment != null) {
            newAttachment.addAll(existingAttachment);
        }
        newAttachment.add(currentLocalOperation);
        globalOperation.setAttachment("LocalBackendOperations", newAttachment);
    }
}

