/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task
implements Comparable<Task> {
    private static final String CLASS_NAME = "org.opends.server.backends.task.Task";
    private Entry taskEntry;
    private FailedDependencyAction failedDependencyAction;
    private int logMessageCounter;
    private LinkedList<String> dependencyIDs;
    private LinkedList<String> logMessages;
    private LinkedList<String> notifyOnCompletion;
    private LinkedList<String> notifyOnError;
    private long actualStartTime;
    private long completionTime;
    private long scheduledStartTime;
    private String recurringTaskID;
    private String taskID;
    private TaskState taskState;
    private TaskScheduler taskScheduler;

    public final void initializeTaskInternal(TaskScheduler taskScheduler, Entry entry) throws InitializationException {
        Object object;
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "initializeTaskInternal", String.valueOf(entry)));
        this.taskScheduler = taskScheduler;
        this.taskEntry = entry;
        String string2 = entry.getDN().toString();
        this.logMessageCounter = 0;
        this.taskID = this.getAttributeValue("ds-task-id", false);
        this.recurringTaskID = this.getAttributeValue("ds-recurring-task-id", false);
        if (this.taskID == null) {
            if (this.recurringTaskID == null) {
                int n = 9699423;
                String string3 = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), "ds-task-id");
                throw new InitializationException(n, string3);
            }
            this.taskID = UUID.randomUUID().toString();
        }
        if ((string = this.getAttributeValue("ds-task-state", false)) == null) {
            this.taskState = TaskState.UNSCHEDULED;
        } else {
            this.taskState = TaskState.fromString(string);
            if (this.taskState == null) {
                int n = 9699419;
                String string4 = MessageHandler.getMessage(n, string2, string);
                throw new InitializationException(n, string4);
            }
        }
        this.scheduledStartTime = -1L;
        String string5 = this.getAttributeValue("ds-task-scheduled-start-time", false);
        if (string5 != null) {
            if (string5.endsWith("Z")) {
                object = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                object = new SimpleDateFormat("yyyyMMddHHmmss");
            }
            try {
                this.scheduledStartTime = ((DateFormat)object).parse(string5).getTime();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeTaskInternal", exception));
                int n = 9699420;
                String string6 = MessageHandler.getMessage(n, string5, string2);
                throw new InitializationException(n, string6, exception);
            }
        }
        this.actualStartTime = -1L;
        string5 = this.getAttributeValue("ds-task-actual-start-time", false);
        if (string5 != null) {
            if (string5.endsWith("Z")) {
                object = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                object = new SimpleDateFormat("yyyyMMddHHmmss");
            }
            try {
                this.actualStartTime = ((DateFormat)object).parse(string5).getTime();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeTaskInternal", exception));
                int n = 9699421;
                String string7 = MessageHandler.getMessage(n, string5, string2);
                throw new InitializationException(n, string7, exception);
            }
        }
        this.completionTime = -1L;
        string5 = this.getAttributeValue("ds-task-completion-time", false);
        if (string5 != null) {
            if (string5.endsWith("Z")) {
                object = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                object = new SimpleDateFormat("yyyyMMddHHmmss");
            }
            try {
                this.completionTime = ((DateFormat)object).parse(string5).getTime();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeTaskInternal", exception));
                int n = 9699422;
                String string8 = MessageHandler.getMessage(n, string5, string2);
                throw new InitializationException(n, string8, exception);
            }
        }
        this.dependencyIDs = this.getAttributeValues("ds-task-dependency-id");
        this.failedDependencyAction = FailedDependencyAction.CANCEL;
        object = this.getAttributeValue("ds-task-failed-dependency-action", false);
        if (object != null) {
            this.failedDependencyAction = FailedDependencyAction.fromString((String)object);
            if (this.failedDependencyAction == null) {
                this.failedDependencyAction = FailedDependencyAction.CANCEL;
            }
        }
        this.notifyOnCompletion = this.getAttributeValues("ds-task-notify-on-completion");
        this.notifyOnError = this.getAttributeValues("ds-task-notify-on-error");
        this.logMessages = this.getAttributeValues("ds-task-log-message");
    }

    private String getAttributeValue(String string, boolean bl) throws InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValue", String.valueOf(string), String.valueOf(bl)));
        List<Attribute> list = this.taskEntry.getAttribute(string.toLowerCase());
        if (list == null || list.isEmpty()) {
            if (bl) {
                int n = 9699423;
                String string2 = MessageHandler.getMessage(n, String.valueOf(this.taskEntry.getDN()), string);
                throw new InitializationException(n, string2);
            }
            return null;
        }
        if (list.size() > 1) {
            int n = 9699424;
            String string3 = MessageHandler.getMessage(n, string, String.valueOf(this.taskEntry.getDN()));
            throw new InitializationException(n, string3);
        }
        Iterator iterator = list.get(0).getValues().iterator();
        if (!iterator.hasNext()) {
            if (bl) {
                int n = 9699425;
                String string4 = MessageHandler.getMessage(n, string, String.valueOf(this.taskEntry.getDN()));
                throw new InitializationException(n, string4);
            }
            return null;
        }
        AttributeValue attributeValue = (AttributeValue)iterator.next();
        if (iterator.hasNext()) {
            int n = 9699426;
            String string5 = MessageHandler.getMessage(n, string, String.valueOf(this.taskEntry.getDN()));
            throw new InitializationException(n, string5);
        }
        return attributeValue.getStringValue();
    }

    private LinkedList<String> getAttributeValues(String string) throws InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeValues", String.valueOf(string)));
        LinkedList<String> linkedList = new LinkedList<String>();
        List<Attribute> list = this.taskEntry.getAttribute(string.toLowerCase());
        if (list == null || list.isEmpty()) {
            return linkedList;
        }
        if (list.size() > 1) {
            int n = 9699424;
            String string2 = MessageHandler.getMessage(n, string);
            throw new InitializationException(n, string2);
        }
        Iterator iterator = list.get(0).getValues().iterator();
        while (iterator.hasNext()) {
            linkedList.add(((AttributeValue)iterator.next()).getStringValue());
        }
        return linkedList;
    }

    public final Entry getTaskEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getTaskEntry", new String[0]));
        return this.taskEntry;
    }

    public final String getTaskID() {
        assert (Debug.debugEnter(CLASS_NAME, "getTaskID", new String[0]));
        return this.taskID;
    }

    public final String getRecurringTaskID() {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTaskID", new String[0]));
        return this.recurringTaskID;
    }

    public final TaskState getTaskState() {
        assert (Debug.debugEnter(CLASS_NAME, "getTaskState", new String[0]));
        return this.taskState;
    }

    void setTaskState(TaskState taskState) {
        assert (Debug.debugEnter(CLASS_NAME, "setTaskState", String.valueOf((Object)taskState)));
        this.taskState = taskState;
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-task-state".toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("ds-task-state");
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(taskState.toString())));
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(new Attribute(attributeType, "ds-task-state", linkedHashSet));
        this.taskEntry.putAttribute(attributeType, arrayList);
    }

    public final long getScheduledStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getStartTime", new String[0]));
        return this.scheduledStartTime;
    }

    public final long getActualStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getActualStartTime", new String[0]));
        return this.actualStartTime;
    }

    private void setActualStartTime(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setActualStartTime", String.valueOf(l)));
        this.actualStartTime = l;
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-task-actual-start-time".toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("ds-task-actual-start-time");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date(l);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(simpleDateFormat.format(date));
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        linkedHashSet.add(new AttributeValue(attributeType, (ByteString)aSN1OctetString));
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(new Attribute(attributeType, "ds-task-actual-start-time", linkedHashSet));
        this.taskEntry.putAttribute(attributeType, arrayList);
    }

    public final long getCompletionTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getCompletionTime", new String[0]));
        return this.completionTime;
    }

    private void setCompletionTime(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setCompletionTime", String.valueOf(l)));
        this.completionTime = l;
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-task-completion-time".toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("ds-task-completion-time");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date(l);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(simpleDateFormat.format(date));
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        linkedHashSet.add(new AttributeValue(attributeType, (ByteString)aSN1OctetString));
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(new Attribute(attributeType, "ds-task-completion-time", linkedHashSet));
        this.taskEntry.putAttribute(attributeType, arrayList);
    }

    public final LinkedList<String> getDependencyIDs() {
        assert (Debug.debugEnter(CLASS_NAME, "getDependencyIDs", new String[0]));
        return this.dependencyIDs;
    }

    public final FailedDependencyAction getFailedDependencyAction() {
        assert (Debug.debugEnter(CLASS_NAME, "getFailedDependencyAction", new String[0]));
        return this.failedDependencyAction;
    }

    public final LinkedList<String> getNotifyOnCompletionAddresses() {
        assert (Debug.debugEnter(CLASS_NAME, "getNotifyOnCompletionAddresses", new String[0]));
        return this.notifyOnCompletion;
    }

    public final LinkedList<String> getNotifyOnErrorAddresses() {
        assert (Debug.debugEnter(CLASS_NAME, "getNotifyOnErrorAddresses", new String[0]));
        return this.notifyOnError;
    }

    public final LinkedList<String> getLogMessages() {
        assert (Debug.debugEnter(CLASS_NAME, "getLogMessages", new String[0]));
        return this.logMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLogMessage(ErrorLogSeverity errorLogSeverity, int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addLogMessage", String.valueOf((Object)errorLogSeverity), String.valueOf(n), String.valueOf(string)));
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<String> linkedList = this.logMessages;
        synchronized (linkedList) {
            List<Attribute> list;
            stringBuilder.append("[");
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] severity=\"");
            stringBuilder.append(errorLogSeverity.getSeverityName());
            stringBuilder.append("\" msgCount=");
            stringBuilder.append(this.logMessageCounter++);
            stringBuilder.append(" msgID=");
            stringBuilder.append(n);
            stringBuilder.append(" message=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
            String string2 = stringBuilder.toString();
            this.logMessages.add(string2);
            AttributeType attributeType = DirectoryServer.getAttributeType("ds-task-log-message".toLowerCase());
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType("ds-task-log-message");
            }
            if ((list = this.taskEntry.getAttribute(attributeType)) == null) {
                list = new ArrayList<Attribute>();
                LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
                linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(string2)));
                list.add(new Attribute(attributeType, "ds-task-log-message", linkedHashSet));
                this.taskEntry.putAttribute(attributeType, list);
            } else if (list.isEmpty()) {
                LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
                linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(string2)));
                list.add(new Attribute(attributeType, "ds-task-log-message", linkedHashSet));
            } else {
                Attribute attribute = list.get(0);
                LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
                linkedHashSet.add(new AttributeValue(attributeType, (ByteString)new ASN1OctetString(string2)));
                list.add(new Attribute(attributeType, "ds-task-log-message", linkedHashSet));
            }
        }
    }

    @Override
    public final int compareTo(Task task) {
        assert (Debug.debugEnter(CLASS_NAME, "compareTo", String.valueOf(task)));
        if (this.completionTime > 0L) {
            if (task.completionTime > 0L) {
                if (this.completionTime < task.completionTime) {
                    return -1;
                }
                if (this.completionTime > task.completionTime) {
                    return 1;
                }
                return this.taskID.compareTo(task.taskID);
            }
            return -1;
        }
        if (task.completionTime > 0L) {
            return 1;
        }
        if (this.actualStartTime > 0L) {
            if (task.actualStartTime > 0L) {
                if (this.actualStartTime < task.actualStartTime) {
                    return -1;
                }
                if (this.actualStartTime > task.actualStartTime) {
                    return 1;
                }
                return this.taskID.compareTo(task.taskID);
            }
            return -1;
        }
        if (task.actualStartTime > 0L) {
            return 1;
        }
        if (this.scheduledStartTime < task.scheduledStartTime) {
            return -1;
        }
        if (this.scheduledStartTime > task.scheduledStartTime) {
            return 1;
        }
        return this.taskID.compareTo(task.taskID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TaskState execute() {
        assert (Debug.debugEnter(CLASS_NAME, "execute", new String[0]));
        this.setActualStartTime(TimeThread.getTime());
        this.setTaskState(TaskState.RUNNING);
        this.taskScheduler.writeState();
        try {
            TaskState taskState = this.runTask();
            this.setTaskState(taskState);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "execute", exception));
            this.setTaskState(TaskState.STOPPED_BY_ERROR);
            int n = 9699427;
            String string = MessageHandler.getMessage(n, String.valueOf(this.taskEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        finally {
            this.setCompletionTime(TimeThread.getTime());
            this.taskScheduler.writeState();
        }
        return this.taskState;
    }

    public void initializeTask() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeTask", new String[0]));
    }

    protected abstract TaskState runTask();

    public void interruptTask(TaskState taskState, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "interruptTask", new String[0]));
    }
}

