/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import org.opends.server.loggers.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskState
extends Enum<TaskState> {
    public static final /* enum */ TaskState UNSCHEDULED = new TaskState();
    public static final /* enum */ TaskState DISABLED = new TaskState();
    public static final /* enum */ TaskState WAITING_ON_START_TIME = new TaskState();
    public static final /* enum */ TaskState WAITING_ON_DEPENDENCY = new TaskState();
    public static final /* enum */ TaskState RUNNING = new TaskState();
    public static final /* enum */ TaskState COMPLETED_SUCCESSFULLY = new TaskState();
    public static final /* enum */ TaskState COMPLETED_WITH_ERRORS = new TaskState();
    public static final /* enum */ TaskState STOPPED_BY_SHUTDOWN = new TaskState();
    public static final /* enum */ TaskState STOPPED_BY_ERROR = new TaskState();
    public static final /* enum */ TaskState STOPPED_BY_ADMINISTRATOR = new TaskState();
    public static final /* enum */ TaskState CANCELED_BEFORE_STARTING = new TaskState();
    private static final String CLASS_NAME = "org.opends.server.backends.task.TaskState";
    private static final /* synthetic */ TaskState[] $VALUES;

    public static final TaskState[] values() {
        return (TaskState[])$VALUES.clone();
    }

    public static TaskState valueOf(String string) {
        return Enum.valueOf(TaskState.class, string);
    }

    public static boolean isPending(TaskState taskState) {
        assert (Debug.debugEnter(CLASS_NAME, "isPending", String.valueOf((Object)taskState)));
        switch (taskState) {
            case UNSCHEDULED: 
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRunning(TaskState taskState) {
        assert (Debug.debugEnter(CLASS_NAME, "isRunning", String.valueOf((Object)taskState)));
        switch (taskState) {
            case RUNNING: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDone(TaskState taskState) {
        assert (Debug.debugEnter(CLASS_NAME, "isDone", String.valueOf((Object)taskState)));
        switch (taskState) {
            case UNSCHEDULED: 
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    public static boolean isSuccessful(TaskState taskState) {
        assert (Debug.debugEnter(CLASS_NAME, "isDone", String.valueOf((Object)taskState)));
        switch (taskState) {
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    public static TaskState fromString(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("unscheduled")) {
            return UNSCHEDULED;
        }
        if (string2.equals("disabled")) {
            return DISABLED;
        }
        if (string2.equals("waiting_on_start_time")) {
            return WAITING_ON_START_TIME;
        }
        if (string2.equals("waiting_on_dependency")) {
            return WAITING_ON_DEPENDENCY;
        }
        if (string2.equals("running")) {
            return RUNNING;
        }
        if (string2.equals("completed_successfully")) {
            return COMPLETED_SUCCESSFULLY;
        }
        if (string2.equals("completed_with_errors")) {
            return COMPLETED_WITH_ERRORS;
        }
        if (string2.equals("stopped_by_shutdown")) {
            return STOPPED_BY_SHUTDOWN;
        }
        if (string2.equals("stopped_by_error")) {
            return STOPPED_BY_ERROR;
        }
        if (string2.equals("stopped_by_administrator")) {
            return STOPPED_BY_ADMINISTRATOR;
        }
        if (string2.equals("canceled_before_starting")) {
            return CANCELED_BEFORE_STARTING;
        }
        return null;
    }

    static {
        $VALUES = new TaskState[]{UNSCHEDULED, DISABLED, WAITING_ON_START_TIME, WAITING_ON_DEPENDENCY, RUNNING, COMPLETED_SUCCESSFULLY, COMPLETED_WITH_ERRORS, STOPPED_BY_SHUTDOWN, STOPPED_BY_ERROR, STOPPED_BY_ADMINISTRATOR, CANCELED_BEFORE_STARTING};
    }
}

