/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.DatabaseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.MonitorProvider;
import org.opends.server.changelog.ChangelogDB;
import org.opends.server.changelog.ChangelogIterator;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbHandler
implements Runnable {
    private LinkedList<UpdateMessage> msgQueue = new LinkedList();
    private ChangelogDB db;
    private ChangeNumber firstChange = null;
    private ChangeNumber lastChange = null;
    private short serverId;
    private DN baseDn;
    private DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private boolean shutdown = false;
    private boolean done = false;
    private DirectoryThread thread = null;

    public DbHandler(short s, DN dN) throws DatabaseException {
        this.serverId = s;
        this.baseDn = dN;
        this.db = new ChangelogDB(s, dN);
        this.firstChange = this.db.readFirstChange();
        this.lastChange = this.db.readLastChange();
        this.thread = new DirectoryThread(this, "changelog db " + s + " " + dN);
        this.thread.start();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor.getMonitorInstanceName());
        DirectoryServer.registerMonitorProvider(this.dbMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMessage updateMessage) {
        LinkedList<UpdateMessage> linkedList = this.msgQueue;
        synchronized (linkedList) {
            int n = this.msgQueue.size();
            while (n > 5000) {
                try {
                    this.msgQueue.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = this.msgQueue.size();
            }
            this.msgQueue.add(updateMessage);
            if (this.lastChange == null || this.lastChange.older(updateMessage.getChangeNumber()).booleanValue()) {
                this.lastChange = updateMessage.getChangeNumber();
            }
            if (this.firstChange == null) {
                this.firstChange = updateMessage.getChangeNumber();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UpdateMessage> getChanges(int n) {
        LinkedList<UpdateMessage> linkedList = new LinkedList<UpdateMessage>();
        LinkedList<UpdateMessage> linkedList2 = this.msgQueue;
        synchronized (linkedList2) {
            int n2 = this.msgQueue.size();
            for (int i = 0; i < n && i < n2; ++i) {
                UpdateMessage updateMessage = this.msgQueue.get(i);
                linkedList.add(updateMessage);
            }
        }
        return linkedList;
    }

    public ChangeNumber getFirstChange() {
        return this.firstChange;
    }

    public ChangeNumber getLastChange() {
        return this.lastChange;
    }

    public ChangelogIterator generateIterator(ChangeNumber changeNumber) throws DatabaseException, Exception {
        return new ChangelogIterator(this.serverId, this.db, changeNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(int n) {
        LinkedList<UpdateMessage> linkedList = this.msgQueue;
        synchronized (linkedList) {
            for (int i = 0; i < n && !this.msgQueue.isEmpty(); ++i) {
                this.msgQueue.remove();
            }
            if (this.msgQueue.size() < 5000) {
                this.msgQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        DbHandler dbHandler = this;
        synchronized (dbHandler) {
            this.notifyAll();
        }
        dbHandler = this;
        synchronized (dbHandler) {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        this.db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DbHandler dbHandler;
        while (!this.shutdown) {
            try {
                this.flush();
                this.trim();
                dbHandler = this;
                synchronized (dbHandler) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                int n = 17039389;
                String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(exception);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            }
        }
        this.flush();
        dbHandler = this;
        synchronized (dbHandler) {
            this.done = true;
            this.notifyAll();
        }
    }

    private void trim() throws DatabaseException, Exception {
        int n = 0;
        boolean bl = false;
        int n2 = 86400000;
        ChangeNumber changeNumber = new ChangeNumber(TimeThread.getTime() - (long)n2, 0, 0);
        ChangelogDB.ChangelogCursor changelogCursor = this.db.openDeleteCursor();
        try {
            while (n < 5000 && !bl) {
                ChangeNumber changeNumber2 = changelogCursor.nextChangeNumber();
                if (changeNumber2 != null && !changeNumber2.equals(this.lastChange) && changeNumber2.older(changeNumber).booleanValue()) {
                    ++n;
                    changelogCursor.delete();
                    continue;
                }
                this.firstChange = changeNumber2;
                bl = true;
            }
            changelogCursor.close();
        }
        catch (DatabaseException databaseException) {
            changelogCursor.close();
            throw databaseException;
        }
    }

    private void flush() {
        int n;
        do {
            List<UpdateMessage> list;
            if ((list = this.getChanges(500)) == null || (n = list.size()) == 0) {
                return;
            }
            this.db.addEntries(list);
            this.clear(list.size());
        } while (n >= 500);
    }

    public String toString() {
        return this.baseDn + " " + this.serverId + " " + this.firstChange + " " + this.lastChange;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DbMonitorProvider
    extends MonitorProvider {
        private DbMonitorProvider() {
            super("Changelog Database");
        }

        public ArrayList<Attribute> getMonitorData() {
            Date date;
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            arrayList.add(new Attribute("changelog-database", String.valueOf(DbHandler.this.serverId)));
            arrayList.add(new Attribute("base-dn", DbHandler.this.baseDn.toString()));
            ChangeNumber changeNumber = DbHandler.this.getFirstChange();
            ChangeNumber changeNumber2 = DbHandler.this.getLastChange();
            if (changeNumber != null) {
                date = new Date(changeNumber.getTime());
                arrayList.add(new Attribute("first-change", changeNumber.toString() + " " + date.toString()));
            }
            if (changeNumber2 != null) {
                date = new Date(changeNumber2.getTime());
                arrayList.add(new Attribute("last-change", changeNumber2.toString() + " " + date.toString()));
            }
            return arrayList;
        }

        @Override
        public String getMonitorInstanceName() {
            return "Changelog database " + DbHandler.this.baseDn.toString() + " " + String.valueOf(DbHandler.this.serverId);
        }

        @Override
        public long getUpdateInterval() {
            return 0L;
        }

        @Override
        public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        }

        @Override
        public void updateMonitorData() {
        }
    }
}

