/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.JMXMBean;
import org.opends.server.core.AddOperation;
import org.opends.server.core.CryptoManager;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.LDIFModify;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileHandler
extends ConfigHandler
implements AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.config.ConfigFileHandler";
    private ConcurrentHashMap<DN, ConfigEntry> configEntries;
    private ConfigEntry configRootEntry;
    private DN[] baseDNs;
    private ReentrantLock configLock;
    private String configFile;
    private String serverRoot;

    public ConfigFileHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeConfigHandler(String string, boolean bl) throws InitializationException {
        Object object;
        Comparable<DN> comparable;
        Object object2;
        LDIFReader lDIFReader;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "initializeConfigHandler", String.valueOf(string)));
        this.configLock = new ReentrantLock();
        this.configFile = string;
        File file = new File(string);
        try {
            if (!file.exists()) {
                int n = 3473434;
                String string2 = MessageHandler.getMessage(n, string);
                throw new InitializationException(n, string2);
            }
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", initializationException));
            throw initializationException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
            int n = 3473435;
            String string3 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new InitializationException(n, string3);
        }
        File file2 = new File(file.getParent(), "config-changes.ldif");
        try {
            if (file2.exists()) {
                this.applyChangesFile(file, file2);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
            int n = 3473971;
            String string4 = MessageHandler.getMessage(n, file2.getAbsolutePath(), String.valueOf(exception));
            throw new InitializationException(n, string4, exception);
        }
        try {
            object3 = new LDIFImportConfig(string);
            lDIFReader = new LDIFReader((LDIFImportConfig)object3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
            int n = 3473436;
            String string5 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new InitializationException(n, string5, exception);
        }
        try {
            object3 = lDIFReader.readEntry(bl);
        }
        catch (LDIFException lDIFException) {
            block80: {
                assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", lDIFException));
                try {
                    lDIFReader.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception)) break block80;
                    throw new AssertionError();
                }
            }
            int n = 3473439;
            String string6 = MessageHandler.getMessage(n, lDIFException.getLineNumber(), string, String.valueOf(lDIFException));
            throw new InitializationException(n, string6, lDIFException);
        }
        catch (Exception exception) {
            block81: {
                assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
                try {
                    lDIFReader.close();
                }
                catch (Exception exception2) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception2)) break block81;
                    throw new AssertionError();
                }
            }
            int n = 3473437;
            String string7 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new InitializationException(n, string7, exception);
        }
        if (object3 == null) {
            block82: {
                try {
                    lDIFReader.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception)) break block82;
                    throw new AssertionError();
                }
            }
            int n = 3473440;
            String string8 = MessageHandler.getMessage(n, string);
            throw new InitializationException(n, string8);
        }
        try {
            object2 = DN.decode("cn=config");
            if (!((Entry)object3).getDN().equals(object2)) {
                int n = 3473441;
                String string9 = MessageHandler.getMessage(n, string, ((Entry)object3).getDN().toString(), "cn=config");
                throw new InitializationException(n, string9);
            }
        }
        catch (InitializationException initializationException) {
            block83: {
                assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", initializationException));
                try {
                    lDIFReader.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception)) break block83;
                    throw new AssertionError();
                }
            }
            throw initializationException;
        }
        catch (Exception exception) {
            block84: {
                assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
                try {
                    lDIFReader.close();
                }
                catch (Exception exception3) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception3)) break block84;
                    throw new AssertionError();
                }
            }
            int n = 3473442;
            String string10 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new InitializationException(n, string10, exception);
        }
        this.configEntries = new ConcurrentHashMap();
        this.configRootEntry = new ConfigEntry((Entry)object3, null);
        this.configEntries.put(((Entry)object3).getDN(), this.configRootEntry);
        while (true) {
            Object object4;
            try {
                object3 = lDIFReader.readEntry(bl);
            }
            catch (LDIFException lDIFException) {
                block85: {
                    assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", lDIFException));
                    try {
                        lDIFReader.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception)) break block85;
                        throw new AssertionError();
                    }
                }
                int n = 3473439;
                object4 = MessageHandler.getMessage(n, lDIFException.getLineNumber(), string, String.valueOf(lDIFException));
                throw new InitializationException(n, (String)object4, lDIFException);
            }
            catch (Exception exception) {
                block86: {
                    assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
                    try {
                        lDIFReader.close();
                    }
                    catch (Exception exception4) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception4)) break block86;
                        throw new AssertionError();
                    }
                }
                int n = 3473437;
                object4 = MessageHandler.getMessage(n, string, String.valueOf(exception));
                throw new InitializationException(n, (String)object4, exception);
            }
            if (object3 == null) {
                try {
                    lDIFReader.close();
                    break;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
                    break;
                }
            }
            object2 = ((Entry)object3).getDN();
            if (this.configEntries.containsKey(object2)) {
                block87: {
                    try {
                        lDIFReader.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception)) break block87;
                        throw new AssertionError();
                    }
                }
                int n = 3473443;
                object4 = MessageHandler.getMessage(n, ((DN)object2).toString(), lDIFReader.getLastEntryLineNumber(), string);
                throw new InitializationException(n, (String)object4);
            }
            comparable = ((DN)object2).getParent();
            if (comparable == null) {
                block88: {
                    try {
                        lDIFReader.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception)) break block88;
                        throw new AssertionError();
                    }
                }
                int n = 3473445;
                object = MessageHandler.getMessage(n, ((DN)object2).toString(), lDIFReader.getLastEntryLineNumber(), string);
                throw new InitializationException(n, (String)object);
            }
            object4 = this.configEntries.get(comparable);
            if (object4 == null) {
                block89: {
                    try {
                        lDIFReader.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception)) break block89;
                        throw new AssertionError();
                    }
                }
                int n = 3473444;
                String string11 = MessageHandler.getMessage(n, ((DN)object2).toString(), lDIFReader.getLastEntryLineNumber(), string, ((DN)comparable).toString());
                throw new InitializationException(n, string11);
            }
            try {
                object = new ConfigEntry((Entry)object3, (ConfigEntry)object4);
                ((ConfigEntry)object4).addChild((ConfigEntry)object);
                this.configEntries.put((DN)object2, (ConfigEntry)object);
            }
            catch (Exception exception) {
                block90: {
                    assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
                    try {
                        lDIFReader.close();
                    }
                    catch (Exception exception5) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception5)) break block90;
                        throw new AssertionError();
                    }
                }
                int n = 3473442;
                String string12 = MessageHandler.getMessage(n, string, String.valueOf(exception));
                throw new InitializationException(n, string12, exception);
            }
        }
        object2 = System.getProperty("org.opends.server.ServerRoot");
        if (object2 == null) {
            object2 = System.getenv("INSTANCE_ROOT");
        }
        if (object2 != null) {
            try {
                comparable = new File((String)object2);
                this.serverRoot = ((File)comparable).getAbsolutePath();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
                int n = 3473446;
                object = MessageHandler.getMessage(n, "INSTANCE_ROOT");
                throw new InitializationException(n, (String)object);
            }
        }
        if (this.serverRoot == null) {
            try {
                comparable = new File(string).getParentFile();
                if (comparable != null && ((File)comparable).getName().equals("config")) {
                    this.serverRoot = ((File)comparable).getParentFile().getAbsolutePath();
                }
                if (this.serverRoot == null) {
                    int n = 3473446;
                    object = MessageHandler.getMessage(n, "INSTANCE_ROOT");
                    throw new InitializationException(n, (String)object);
                }
            }
            catch (InitializationException initializationException) {
                assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", initializationException));
                throw initializationException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
                int n = 3473446;
                object = MessageHandler.getMessage(n, "INSTANCE_ROOT");
                throw new InitializationException(n, (String)object);
            }
        }
        DirectoryServer.registerAlertGenerator(this);
        this.baseDNs = new DN[]{this.configRootEntry.getDN()};
        try {
            DirectoryServer.registerPrivateSuffix(this.configRootEntry.getDN(), this);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConfigHandler", exception));
            int n = 3473511;
            object = MessageHandler.getMessage(n, this.configRootEntry.getDN(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, (String)object, exception);
        }
    }

    private void applyChangesFile(File file, File file2) throws IOException, LDIFException {
        assert (Debug.debugEnter(CLASS_NAME, "applyChangesFile", String.valueOf(file), String.valueOf(file2)));
        LDIFImportConfig lDIFImportConfig = new LDIFImportConfig(file.getAbsolutePath());
        lDIFImportConfig.setValidateSchema(false);
        LDIFReader lDIFReader = new LDIFReader(lDIFImportConfig);
        lDIFImportConfig = new LDIFImportConfig(file2.getAbsolutePath());
        lDIFImportConfig.setValidateSchema(false);
        LDIFReader lDIFReader2 = new LDIFReader(lDIFImportConfig);
        String string = file2.getAbsolutePath() + ".tmp";
        LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(string, ExistingFileBehavior.OVERWRITE);
        LDIFWriter lDIFWriter = new LDIFWriter(lDIFExportConfig);
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = LDIFModify.modifyLDIF(lDIFReader, lDIFReader2, lDIFWriter, linkedList);
        try {
            lDIFReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lDIFReader2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lDIFWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            String string22;
            for (String string22 : linkedList) {
                int n = 3473972;
                String string3 = MessageHandler.getMessage(n, string22);
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, n, string3);
            }
            int n = 3473973;
            string22 = MessageHandler.getMessage(n);
            throw new LDIFException(n, string22);
        }
        File file3 = new File(file.getAbsolutePath() + ".prechanges");
        if (file3.exists()) {
            file3.delete();
        }
        file.renameTo(file3);
        new File(string).renameTo(file);
        File file4 = new File(file2.getAbsolutePath() + ".applied");
        if (file4.exists()) {
            file4.delete();
        }
        file2.renameTo(file4);
    }

    @Override
    public void finalizeConfigHandler() {
        block3: {
            assert (Debug.debugEnter(CLASS_NAME, "finalizeConfigHandler", new String[0]));
            try {
                DirectoryServer.deregisterSuffix(this.configRootEntry.getDN());
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "finalizeConfigHandler", exception)) break block3;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void finalizeBackend() {
    }

    @Override
    public ConfigEntry getConfigRootEntry() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigRootEntry", new String[0]));
        return this.configRootEntry;
    }

    @Override
    public ConfigEntry getConfigEntry(DN dN) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigEntry", String.valueOf(dN)));
        return this.configEntries.get(dN);
    }

    @Override
    public String getServerRoot() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerRoot", new String[0]));
        return this.serverRoot;
    }

    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", String.valueOf(configEntry)));
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.baseDNs;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        ConfigEntry configEntry = this.configEntries.get(dN);
        if (configEntry == null) {
            return null;
        }
        return configEntry.getEntry();
    }

    @Override
    public boolean entryExists(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        return this.configEntries.containsKey(dN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", String.valueOf(entry), String.valueOf(addOperation)));
        this.configLock.lock();
        try {
            DN dN = entry.getDN();
            if (this.configEntries.containsKey(dN)) {
                int n = 3342616;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string, n);
            }
            DN dN2 = dN.getParent();
            if (dN2 == null) {
                int n = 3342617;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            ConfigEntry configEntry = this.configEntries.get(dN2);
            if (configEntry == null) {
                int n = 3342618;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dN2));
                DN dN3 = null;
                for (dN2 = dN2.getParent(); dN2 != null; dN2 = dN2.getParent()) {
                    if (!this.configEntries.containsKey(dN2)) continue;
                    dN3 = dN2;
                    break;
                }
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, dN3, null);
            }
            ConfigEntry configEntry2 = new ConfigEntry(entry, configEntry);
            CopyOnWriteArrayList<ConfigAddListener> copyOnWriteArrayList = configEntry.getAddListeners();
            StringBuilder stringBuilder = new StringBuilder();
            for (ConfigAddListener configAddListener : copyOnWriteArrayList) {
                if (configAddListener.configAddIsAcceptable(configEntry2, stringBuilder)) continue;
                int n = 3342619;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dN2), String.valueOf(stringBuilder));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
            }
            try {
                configEntry.addChild(configEntry2);
                this.configEntries.put(dN, configEntry2);
                this.writeUpdatedConfig();
            }
            catch (ConfigException configException) {
                assert (Debug.debugException(CLASS_NAME, "addEntry", configException));
                int n = 3342620;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dN2), StaticUtils.stackTraceToSingleLineString(configException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
            }
            for (ConfigAddListener configAddListener : copyOnWriteArrayList) {
                ConfigChangeResult configChangeResult = configAddListener.applyConfigurationAdd(configEntry2);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", String.valueOf(dN), String.valueOf(deleteOperation)));
        this.configLock.lock();
        try {
            ConfigEntry configEntry = this.configEntries.get(dN);
            if (configEntry == null) {
                DN dN2 = null;
                if (dN.isDescendantOf(this.configRootEntry.getDN())) {
                    for (DN dN3 = dN.getParent(); dN3 != null; dN3 = dN3.getParent()) {
                        if (!this.configEntries.containsKey(dN3)) continue;
                        dN2 = dN3;
                        break;
                    }
                }
                int n = 3342621;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, dN2, null);
            }
            if (configEntry.hasChildren()) {
                int n = 3342622;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, string, n);
            }
            ConfigEntry configEntry2 = configEntry.getParent();
            if (configEntry2 == null) {
                int n = 3342623;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
            }
            CopyOnWriteArrayList<ConfigDeleteListener> copyOnWriteArrayList = configEntry2.getDeleteListeners();
            StringBuilder stringBuilder = new StringBuilder();
            for (ConfigDeleteListener configDeleteListener : copyOnWriteArrayList) {
                if (configDeleteListener.configDeleteIsAcceptable(configEntry, stringBuilder)) continue;
                int n = 3342624;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(configEntry2.getDN()), String.valueOf(stringBuilder));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
            }
            try {
                configEntry2.removeChild(dN);
                this.configEntries.remove(dN);
                this.writeUpdatedConfig();
            }
            catch (ConfigException configException) {
                assert (Debug.debugException(CLASS_NAME, "deleteEntry", configException));
                int n = 3342625;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(configException));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
            }
            for (ConfigDeleteListener configDeleteListener : copyOnWriteArrayList) {
                ConfigChangeResult configChangeResult = configDeleteListener.applyConfigurationDelete(configEntry);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", String.valueOf(entry), String.valueOf(modifyOperation)));
        this.configLock.lock();
        try {
            void var9_16;
            Object object2;
            DN dN = entry.getDN();
            ConfigEntry configEntry = this.configEntries.get(dN);
            if (configEntry == null) {
                DN dN2 = null;
                if (dN.isDescendantOf(this.configRootEntry.getDN())) {
                    for (DN dN3 = dN.getParent(); dN3 != null; dN3 = dN3.getParent()) {
                        if (!this.configEntries.containsKey(dN3)) continue;
                        dN2 = dN3;
                        break;
                    }
                }
                int n = 3342626;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, dN2, null);
            }
            ConfigEntry configEntry2 = new ConfigEntry(entry, configEntry.getParent());
            CopyOnWriteArrayList<ConfigChangeListener> copyOnWriteArrayList = configEntry.getChangeListeners();
            StringBuilder stringBuilder = new StringBuilder();
            for (ConfigChangeListener object32 : copyOnWriteArrayList) {
                if (object32.configChangeIsAcceptable(configEntry2, stringBuilder)) continue;
                int n = 3342627;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(stringBuilder));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
            }
            JMXMBean jMXMBean = DirectoryServer.getJMXMBean(dN);
            Object var9_14 = null;
            if (jMXMBean != null) {
                CopyOnWriteArrayList<ConfigurableComponent> copyOnWriteArrayList2 = jMXMBean.getConfigurableComponents();
                Iterator iterator = new LinkedList();
                for (Object object2 : copyOnWriteArrayList2) {
                    if (object2.hasAcceptableConfiguration(configEntry2, (List<String>)((Object)iterator))) continue;
                    if (!((AbstractCollection)((Object)iterator)).isEmpty()) {
                        Iterator iterator2 = ((AbstractSequentialList)((Object)iterator)).iterator();
                        stringBuilder.append((String)iterator2.next());
                        while (iterator2.hasNext()) {
                            stringBuilder.append("  ");
                            stringBuilder.append((String)iterator2.next());
                        }
                    }
                    int n = 3342628;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(stringBuilder));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
                }
            }
            configEntry.setEntry(entry);
            this.writeUpdatedConfig();
            for (ConfigChangeListener configChangeListener : copyOnWriteArrayList) {
                object2 = configChangeListener.applyConfigurationChange(configEntry);
            }
            if (var9_16 != null) {
                for (ConfigurableComponent configurableComponent : var9_16) {
                    object2 = configurableComponent.applyNewConfiguration(configEntry, false);
                }
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", String.valueOf(dN), String.valueOf(entry), String.valueOf(modifyDNOperation)));
        int n = 3342638;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "search", String.valueOf(searchOperation)));
        DN dN = searchOperation.getBaseDN();
        ConfigEntry configEntry = this.configEntries.get(dN);
        if (configEntry == null) {
            int n = 3342629;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            DN dN2 = null;
            if (dN.isDescendantOf(this.configRootEntry.getDN())) {
                for (DN dN3 = dN.getParent(); dN3 != null; dN3 = dN3.getParent()) {
                    if (!this.configEntries.containsKey(dN3)) continue;
                    dN2 = dN3;
                    break;
                }
            }
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, dN2, null);
        }
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        switch (searchScope) {
            case BASE_OBJECT: {
                Entry entry = configEntry.getEntry();
                if (!searchFilter.matchesEntry(entry)) break;
                searchOperation.returnEntry(entry, null);
                break;
            }
            case SINGLE_LEVEL: {
                ConfigEntry configEntry2;
                Entry entry;
                Iterator<ConfigEntry> iterator = configEntry.getChildren().values().iterator();
                while (iterator.hasNext() && (!searchFilter.matchesEntry(entry = (configEntry2 = iterator.next()).getEntry()) || searchOperation.returnEntry(entry, null))) {
                }
                break;
            }
            case WHOLE_SUBTREE: {
                this.searchSubtree(configEntry, searchFilter, searchOperation);
                break;
            }
            case SUBORDINATE_SUBTREE: {
                for (ConfigEntry configEntry3 : configEntry.getChildren().values()) {
                    if (!this.searchSubtree(configEntry3, searchFilter, searchOperation)) break;
                }
                break;
            }
            default: {
                int n = 3342630;
                String string = MessageHandler.getMessage(n, String.valueOf((Object)searchScope));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n);
            }
        }
    }

    private boolean searchSubtree(ConfigEntry configEntry, SearchFilter searchFilter, SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "searchSubtree", String.valueOf(configEntry), String.valueOf(searchFilter), String.valueOf(searchOperation)));
        Entry entry = configEntry.getEntry();
        if (searchFilter.matchesEntry(entry) && !searchOperation.returnEntry(entry, null)) {
            return false;
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            if (this.searchSubtree(configEntry2, searchFilter, searchOperation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeUpdatedConfig() throws DirectoryException {
        int n;
        int n2;
        Object object;
        ZipOutputStream zipOutputStream;
        assert (Debug.debugEnter(CLASS_NAME, "writeUpdatedConfig", new String[0]));
        File file = new File(this.configFile);
        String string = file.getParent();
        String string2 = string + File.separator + "archived-config.zip";
        String string3 = string2 + ".tmp";
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string3, false));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeUpdatedConfig", exception));
            int n3 = 3342631;
            String string4 = MessageHandler.getMessage(n3, String.valueOf(string3), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string4, n3);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", n3, string4);
            return;
        }
        byte[] byArray = new byte[8192];
        String string5 = this.configFile + "." + TimeThread.getUTCTime();
        File file2 = new File(string2);
        if (file2.exists()) {
            try {
                object = new ZipInputStream(new FileInputStream(file2));
                ZipEntry zipEntry = ((ZipInputStream)object).getNextEntry();
                while (zipEntry != null) {
                    if (zipEntry.getName().equals(string5)) {
                        zipEntry = ((ZipInputStream)object).getNextEntry();
                        continue;
                    }
                    zipOutputStream.putNextEntry(zipEntry);
                    n2 = ((FilterInputStream)object).read(byArray);
                    while (n2 > 0) {
                        zipOutputStream.write(byArray, 0, n2);
                        n2 = ((FilterInputStream)object).read(byArray);
                    }
                    zipOutputStream.closeEntry();
                    zipEntry = ((ZipInputStream)object).getNextEntry();
                }
                ((ZipInputStream)object).close();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "writeUpdatedConfig", exception));
                int n4 = 3342632;
                String string6 = MessageHandler.getMessage(n4, String.valueOf(string2), String.valueOf(string3), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string6, n4);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", n4, string6);
                return;
            }
        }
        try {
            object = new FileInputStream(this.configFile);
            zipOutputStream.putNextEntry(new ZipEntry(string5));
            n = ((FileInputStream)object).read(byArray);
            while (n > 0) {
                zipOutputStream.write(byArray, 0, n);
                n = ((FileInputStream)object).read(byArray);
            }
            zipOutputStream.closeEntry();
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeUpdatedConfig", exception));
            int n5 = 3342633;
            String string7 = MessageHandler.getMessage(n5, String.valueOf(string3), String.valueOf(this.configFile), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string7, n5);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", n5, string7);
            return;
        }
        try {
            zipOutputStream.close();
            if (file2.exists()) {
                file2.delete();
            }
            if (!((File)(object = new File(string3))).renameTo(file2)) {
                n = 3342634;
                String string8 = MessageHandler.getMessage(n, String.valueOf(string3), String.valueOf(string2));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string8, n);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", n, string8);
                return;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeUpdatedConfig", exception));
            n = 3342635;
            String string9 = MessageHandler.getMessage(n, String.valueOf(string2), String.valueOf(string3), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string9, n);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", n, string9);
            return;
        }
        object = this.configFile + ".tmp";
        try {
            LDIFExportConfig lDIFExportConfig = new LDIFExportConfig((String)object, ExistingFileBehavior.OVERWRITE);
            this.exportLDIF(this.configRootEntry, this.baseDNs, lDIFExportConfig);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeUpdatedConfig", exception));
            n2 = 3342636;
            String string10 = MessageHandler.getMessage(n2, String.valueOf(object), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string10, n2);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", n2, string10);
            return;
        }
        try {
            file.delete();
            new File((String)object).renameTo(file);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeUpdatedConfig", exception));
            n2 = 3342637;
            String string11 = MessageHandler.getMessage(n2, String.valueOf(object), String.valueOf(this.configFile), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string11, n2);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteConfig", n2, string11);
            return;
        }
    }

    public HashSet<String> getSupportedControls() {
        return null;
    }

    @Override
    public boolean supportsControl(String string) {
        return false;
    }

    public HashSet<String> getSupportedFeatures() {
        return null;
    }

    @Override
    public boolean supportsFeature(String string) {
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        LDIFWriter lDIFWriter;
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", String.valueOf(lDIFExportConfig)));
        try {
            lDIFWriter = new LDIFWriter(lDIFExportConfig);
            lDIFWriter.writeComment(MessageHandler.getMessage(3146152), 80);
            this.writeEntryAndChildren(lDIFWriter, this.configRootEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
            int n = 3407956;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        try {
            lDIFWriter.close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
            int n = 3407912;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
    }

    private void writeEntryAndChildren(LDIFWriter lDIFWriter, ConfigEntry configEntry) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "writeEntryAndChildren", String.valueOf(lDIFWriter), String.valueOf(configEntry)));
        try {
            lDIFWriter.writeEntry(configEntry.getEntry());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeEntryAndChildren", exception));
            int n = 3407911;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        TreeMap<DN, ConfigEntry> treeMap = new TreeMap<DN, ConfigEntry>(configEntry.getChildren());
        for (ConfigEntry configEntry2 : treeMap.values()) {
            this.writeEntryAndChildren(lDIFWriter, configEntry2);
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return false;
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", String.valueOf(lDIFImportConfig)));
        int n = 3407913;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        int n;
        Object object;
        Object object2;
        OutputStream outputStream;
        int n2;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(configEntry), String.valueOf(backupConfig)));
        String string = backupConfig.getBackupID();
        BackupDirectory backupDirectory = backupConfig.getBackupDirectory();
        boolean bl = backupConfig.compressData();
        boolean bl2 = backupConfig.encryptData();
        boolean bl3 = backupConfig.hashData();
        boolean bl4 = backupConfig.signHash();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest messageDigest = null;
        String string2 = null;
        String string3 = null;
        if (bl3) {
            if (bl4) {
                string3 = cryptoManager.getPreferredMACAlgorithm();
                hashMap.put("mac_algorithm", string3);
                try {
                    mac = cryptoManager.getPreferredMACProvider();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                    int n3 = 9699714;
                    String string4 = MessageHandler.getMessage(n3, string3, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string4, n3, exception);
                }
            }
            string2 = cryptoManager.getPreferredMessageDigestAlgorithm();
            hashMap.put("digest_algorithm", string2);
            try {
                messageDigest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                int n4 = 9699715;
                String string5 = MessageHandler.getMessage(n4, string2, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n4, exception);
            }
        }
        String string6 = null;
        try {
            string6 = "config-backup-" + string;
            object3 = new File(backupDirectory.getPath() + File.separator + string6);
            if (((File)object3).exists()) {
                n2 = 1;
                while (((File)(object3 = new File(backupDirectory.getPath() + File.separator + string6 + "." + n2))).exists()) {
                    ++n2;
                }
                string6 = string6 + "." + n2;
            }
            outputStream = new FileOutputStream((File)object3, false);
            hashMap.put("archive_file", string6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            int n5 = 9699716;
            String string7 = MessageHandler.getMessage(n5, String.valueOf(string6), backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string7, n5, exception);
        }
        if (bl2) {
            Cipher cipher;
            object3 = cryptoManager.getPreferredCipherAlgorithm();
            hashMap.put("cipher_algorithm", (String)object3);
            try {
                cipher = cryptoManager.getPreferredCipher(1);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                int n6 = 9699717;
                String string8 = MessageHandler.getMessage(n6, object3, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string8, n6, exception);
            }
            outputStream = new CipherOutputStream(outputStream, cipher);
        }
        object3 = new ZipOutputStream(outputStream);
        n2 = 9699718;
        String string9 = MessageHandler.getMessage(n2, "OpenDS Directory Server", string);
        ((ZipOutputStream)object3).setComment(string9);
        if (bl) {
            ((ZipOutputStream)object3).setLevel(-1);
        } else {
            ((ZipOutputStream)object3).setLevel(0);
        }
        String string10 = null;
        try {
            string10 = ((ConfigFileHandler)DirectoryServer.getConfigHandler()).configFile;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n2 = 9699719;
            string9 = MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n2, exception);
        }
        byte[] byArray = new byte[8192];
        FileInputStream fileInputStream = null;
        try {
            object2 = new File(string10);
            object = new ZipEntry(((File)object2).getName());
            ((ZipOutputStream)object3).putNextEntry((ZipEntry)object);
            fileInputStream = new FileInputStream((File)object2);
            while ((n = fileInputStream.read(byArray)) >= 0) {
                if (bl3) {
                    if (bl4) {
                        mac.update(byArray, 0, n);
                    } else {
                        messageDigest.update(byArray, 0, n);
                    }
                }
                ((ZipOutputStream)object3).write(byArray, 0, n);
            }
            fileInputStream.close();
            ((ZipOutputStream)object3).closeEntry();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            try {
                fileInputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                ((ZipOutputStream)object3).close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            n2 = 9699720;
            string9 = MessageHandler.getMessage(n2, string10, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n2, exception);
        }
        try {
            object2 = new File(new File(string10).getParent() + File.separator + "archived-config.zip");
            if (((File)object2).exists()) {
                object = new ZipEntry(((File)object2).getName());
                ((ZipOutputStream)object3).putNextEntry((ZipEntry)object);
                fileInputStream = new FileInputStream((File)object2);
                while ((n = fileInputStream.read(byArray)) >= 0) {
                    if (bl3) {
                        if (bl4) {
                            mac.update(byArray, 0, n);
                        } else {
                            messageDigest.update(byArray, 0, n);
                        }
                    }
                    ((ZipOutputStream)object3).write(byArray, 0, n);
                }
                fileInputStream.close();
                ((ZipOutputStream)object3).closeEntry();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            try {
                fileInputStream.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
            try {
                ((ZipOutputStream)object3).close();
            }
            catch (Exception exception5) {
                // empty catch block
            }
            n2 = 9699721;
            string9 = MessageHandler.getMessage(n2, string10, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n2, exception);
        }
        try {
            ((ZipOutputStream)object3).close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n2 = 9699722;
            string9 = MessageHandler.getMessage(n2, string6, backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n2, exception);
        }
        object2 = null;
        object = null;
        if (bl3) {
            if (bl4) {
                object = mac.doFinal();
            } else {
                object2 = messageDigest.digest();
            }
        }
        BackupInfo backupInfo = new BackupInfo(backupDirectory, string, new Date(), false, bl, bl2, (byte[])object2, (byte[])object, null, hashMap);
        try {
            backupDirectory.addBackup(backupInfo);
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n2 = 9699723;
            string9 = MessageHandler.getMessage(n2, backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n2, exception);
        }
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(backupDirectory), String.valueOf(string)));
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return true;
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", String.valueOf(configEntry), String.valueOf(restoreConfig)));
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        String string = backupDirectory.getPath();
        String string2 = restoreConfig.getBackupID();
        BackupInfo backupInfo = backupDirectory.getBackupInfo(string2);
        if (backupInfo == null) {
            int n = 9699724;
            String string3 = MessageHandler.getMessage(n, string2, string);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string3, n);
        }
        String string4 = backupInfo.getBackupProperty("archive_file");
        if (string4 == null) {
            int n = 9699725;
            String string5 = MessageHandler.getMessage(n, string2, string);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n);
        }
        File file = new File(string + File.separator + string4);
        try {
            if (!file.exists()) {
                int n = 9699726;
                String string6 = MessageHandler.getMessage(n, string2, file.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string6, n);
            }
        }
        catch (DirectoryException directoryException) {
            throw directoryException;
        }
        catch (Exception exception) {
            int n = 9699727;
            String string7 = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string7, n, exception);
        }
        byte[] byArray = backupInfo.getUnsignedHash();
        MessageDigest messageDigest = null;
        if (byArray != null) {
            object7 = backupInfo.getBackupProperty("digest_algorithm");
            if (object7 == null) {
                int n = 9699728;
                String string8 = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string8, n);
            }
            try {
                messageDigest = DirectoryServer.getCryptoManager().getMessageDigest((String)object7);
            }
            catch (Exception exception) {
                int n = 9699729;
                String string9 = MessageHandler.getMessage(n, string2, object7);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n, exception);
            }
        }
        object7 = backupInfo.getSignedHash();
        Mac mac = null;
        if (object7 != null) {
            object6 = backupInfo.getBackupProperty("mac_algorithm");
            if (object6 == null) {
                int n = 9699730;
                String string10 = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string10, n);
            }
            try {
                mac = DirectoryServer.getCryptoManager().getMACProvider((String)object6);
            }
            catch (Exception exception) {
                int n = 9699731;
                String string11 = MessageHandler.getMessage(n, string2, object6, file.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, exception);
            }
        }
        try {
            object6 = new FileInputStream(file);
        }
        catch (Exception exception) {
            int n = 9699732;
            String string12 = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string12, n, exception);
        }
        if (backupInfo.isEncrypted()) {
            object5 = backupInfo.getBackupProperty("cipher_algorithm");
            if (object5 == null) {
                int n = 9699733;
                String string13 = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string13, n);
            }
            try {
                object4 = DirectoryServer.getCryptoManager().getCipher((String)object5, 2);
            }
            catch (Exception exception) {
                int n = 9699734;
                String string14 = MessageHandler.getMessage(n, object5, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string14, n, exception);
            }
            object6 = new CipherInputStream((InputStream)object6, (Cipher)object4);
        }
        object5 = new ZipInputStream((InputStream)object6);
        object4 = ((ConfigFileHandler)DirectoryServer.getConfigHandler()).configFile;
        File file2 = new File((String)object4);
        File file3 = file2.getParentFile();
        String string15 = file3.getPath();
        Object object8 = null;
        File file4 = null;
        boolean bl = restoreConfig.verifyOnly();
        if (!bl) {
            try {
                if (file3.exists()) {
                    object3 = string15 + ".save";
                    object8 = object3;
                    file4 = new File((String)object8);
                    if (file4.exists()) {
                        int n = 2;
                        while ((file4 = new File((String)(object8 = (Object)((String)object3 + n)))).exists()) {
                            ++n;
                        }
                    }
                    file4.mkdirs();
                    StaticUtils.moveFile(file2, file4);
                    object2 = new File(string15 + File.separator + "archived-config.zip");
                    if (((File)object2).exists()) {
                        StaticUtils.moveFile((File)object2, file4);
                    }
                }
            }
            catch (Exception exception) {
                int n = 9699735;
                String string16 = MessageHandler.getMessage(n, string2, string15, String.valueOf(object8), StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string16, n, exception);
            }
            try {
                file3.mkdirs();
            }
            catch (Exception exception) {
                if (file4 != null) {
                    try {
                        file4.renameTo(file3);
                        int n = 9896344;
                        String string17 = MessageHandler.getMessage(n, string15);
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string17, n);
                    }
                    catch (Exception exception2) {
                        int n = 9699737;
                        String string18 = MessageHandler.getMessage(n, file4.getPath());
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string18, n);
                    }
                }
                int n = 9699738;
                String string19 = MessageHandler.getMessage(n, string2, string15, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string19, n, exception);
            }
        }
        object3 = new byte[8192];
        while (true) {
            try {
                object2 = ((ZipInputStream)object5).getNextEntry();
            }
            catch (Exception exception) {
                String string20;
                if (file4 != null) {
                    int n = 9699739;
                    string20 = MessageHandler.getMessage(n, file4.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string20, n);
                }
                int n = 9699740;
                string20 = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string20, n, exception);
            }
            if (object2 == null) break;
            String string21 = ((ZipEntry)object2).getName();
            if (messageDigest != null) {
                messageDigest.update(StaticUtils.getBytes(string21));
            }
            if (mac != null) {
                mac.update(StaticUtils.getBytes(string21));
            }
            object = null;
            if (!bl) {
                String string22 = string15 + File.separator + string21;
                try {
                    object = new FileOutputStream(string22);
                }
                catch (Exception exception) {
                    String string23;
                    int n;
                    if (file4 != null) {
                        n = 9699739;
                        string23 = MessageHandler.getMessage(n, file4.getPath());
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string23, n);
                    }
                    n = 9699741;
                    string23 = MessageHandler.getMessage(n, string2, string22, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string23, n, exception);
                }
            }
            try {
                int n;
                while ((n = ((FilterInputStream)object5).read((byte[])object3)) >= 0) {
                    if (messageDigest != null) {
                        messageDigest.update((byte[])object3, 0, n);
                    }
                    if (mac != null) {
                        mac.update((byte[])object3, 0, n);
                    }
                    if (object == null) continue;
                    ((OutputStream)object).write((byte[])object3, 0, n);
                }
                if (object == null) continue;
                ((OutputStream)object).close();
            }
            catch (Exception exception) {
                String string24;
                int n;
                if (file4 != null) {
                    n = 9699739;
                    string24 = MessageHandler.getMessage(n, file4.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string24, n);
                }
                n = 9699742;
                string24 = MessageHandler.getMessage(n, string2, string21, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string24, n, exception);
            }
        }
        try {
            ((ZipInputStream)object5).close();
        }
        catch (Exception exception) {
            int n = 9699743;
            object = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n, exception);
        }
        if (messageDigest != null) {
            object2 = messageDigest.digest();
            if (Arrays.equals((byte[])object2, byArray)) {
                int n = 9896352;
                object = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
            } else {
                if (file4 != null) {
                    int n = 9699739;
                    object = MessageHandler.getMessage(n, file4.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
                }
                int n = 9699745;
                object = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n);
            }
        }
        if (mac != null) {
            object2 = mac.doFinal();
            if (Arrays.equals((byte[])object2, object7)) {
                int n = 9896354;
                object = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
            } else {
                if (file4 != null) {
                    int n = 9699739;
                    object = MessageHandler.getMessage(n, file4.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
                }
                int n = 9699747;
                object = MessageHandler.getMessage(n);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n);
            }
        }
        if (bl) {
            int n = 9896356;
            String string25 = MessageHandler.getMessage(n, string2, string);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string25, n);
            return;
        }
        if (file4 != null) {
            StaticUtils.recursiveDelete(file4);
        }
        int n = 9896357;
        String string26 = MessageHandler.getMessage(n, string2, string);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string26, n);
    }

    @Override
    public DN getComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getComponentEntryDN", new String[0]));
        return this.configRootEntry.getDN();
    }

    @Override
    public String getClassName() {
        assert (Debug.debugEnter(CLASS_NAME, "getClassName", new String[0]));
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        assert (Debug.debugEnter(CLASS_NAME, "getAlerts", new String[0]));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("org.opends.server.CannotWriteConfig", "This alert type will be used to notify administrators if the Directory Server is unable to write its updated configuration for some reason and therefore the server may not exhibit the new configuration if it is restarted.");
        return linkedHashMap;
    }
}

