/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNConfigAttribute
extends ConfigAttribute {
    private static final String CLASS_NAME = "org.opends.server.config.DNConfigAttribute";
    private List<DN> activeValues;
    private List<DN> pendingValues;

    public DNConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        super(string, string2, bl, bl2, bl3);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3)));
        this.activeValues = new ArrayList<DN>();
        this.pendingValues = this.activeValues;
    }

    public DNConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, DN dN) {
        super(string, string2, bl, bl2, bl3, DNConfigAttribute.getValueSet(dN));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(dN)));
        if (dN == null) {
            this.activeValues = new ArrayList<DN>();
        } else {
            this.activeValues = new ArrayList<DN>(1);
            this.activeValues.add(dN);
        }
        this.pendingValues = this.activeValues;
    }

    public DNConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, List<DN> list) {
        super(string, string2, bl, bl2, bl3, DNConfigAttribute.getValueSet(list));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(list)));
        if (list == null) {
            this.activeValues = new ArrayList<DN>();
            this.pendingValues = this.activeValues;
        } else {
            this.activeValues = list;
            this.pendingValues = this.activeValues;
        }
    }

    public DNConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, List<DN> list, List<DN> list2) {
        super(string, string2, bl, bl2, bl3, DNConfigAttribute.getValueSet(list), list2 != null, DNConfigAttribute.getValueSet(list2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(list), String.valueOf(list2)));
        this.activeValues = list == null ? new ArrayList<DN>() : list;
        this.pendingValues = list2 == null ? this.activeValues : list2;
    }

    @Override
    public String getDataType() {
        assert (Debug.debugEnter(CLASS_NAME, "getDataType", new String[0]));
        return "DN";
    }

    @Override
    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return DirectoryServer.getDefaultStringSyntax();
    }

    public DN activeValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "activeValue", new String[0]));
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            int n = 0x33000F;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.activeValues.size() > 1) {
            int n = 0x330010;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        return this.activeValues.get(0);
    }

    public List<DN> activeValues() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValues", new String[0]));
        return this.activeValues;
    }

    public DN pendingValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValue", new String[0]));
        if (!this.hasPendingValues()) {
            return this.activeValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            int n = 0x33000F;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.pendingValues.size() > 1) {
            int n = 0x330010;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        return this.pendingValues.get(0);
    }

    public List<DN> pendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return this.activeValues;
        }
        return this.pendingValues;
    }

    public void setValue(DN dN) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(dN)));
        if (dN == null) {
            int n = 3342434;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = new ArrayList<DN>(1);
            this.pendingValues.add(dN);
            this.setPendingValues(DNConfigAttribute.getValueSet(dN));
        } else {
            this.activeValues.clear();
            this.activeValues.add(dN);
            this.pendingValues = this.activeValues;
            this.setActiveValues(DNConfigAttribute.getValueSet(dN));
        }
    }

    public void setValues(List<DN> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValues", String.valueOf(list)));
        if (list == null || list.isEmpty()) {
            if (this.isRequired()) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.getName());
                throw new ConfigException(n, string);
            }
            if (this.requiresAdminAction()) {
                this.setPendingValues(new LinkedHashSet<AttributeValue>(0));
                this.pendingValues = new ArrayList<DN>();
            } else {
                this.setActiveValues(new LinkedHashSet<AttributeValue>(0));
                this.activeValues.clear();
            }
        }
        int n = list.size();
        if (!this.isMultiValued() && n > 1) {
            int n2 = 0x330003;
            String string = MessageHandler.getMessage(n2, this.getName());
            throw new ConfigException(n2, string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (DN dN : list) {
            if (dN == null) {
                int n3 = 3342434;
                String string = MessageHandler.getMessage(n3, this.getName());
                throw new ConfigException(n3, string);
            }
            AttributeValue attributeValue = new AttributeValue(new ASN1OctetString(dN.toString()), (ByteString)new ASN1OctetString(dN.toNormalizedString()));
            if (linkedHashSet.contains(attributeValue)) {
                int n4 = 0x330005;
                String string = MessageHandler.getMessage(n4, this.getName(), dN);
                throw new ConfigException(n4, string);
            }
            linkedHashSet.add(attributeValue);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = list;
            this.setPendingValues(linkedHashSet);
        } else {
            this.activeValues = list;
            this.pendingValues = this.activeValues;
            this.setActiveValues(linkedHashSet);
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(DN dN) {
        LinkedHashSet<AttributeValue> linkedHashSet;
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(dN)));
        if (dN == null) {
            linkedHashSet = new LinkedHashSet<AttributeValue>(0);
        } else {
            linkedHashSet = new LinkedHashSet(1);
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(dN.toString()), (ByteString)new ASN1OctetString(dN.toNormalizedString())));
        }
        return linkedHashSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<DN> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(list)));
        if (list == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(list.size());
        for (DN dN : list) {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(dN.toString()), (ByteString)new ASN1OctetString(dN.toNormalizedString())));
        }
        return linkedHashSet;
    }

    @Override
    public void applyPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "applyPendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValues = this.pendingValues;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue attributeValue, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(attributeValue), "java.lang.StringBuilder"));
        if (attributeValue == null) {
            stringBuilder.append(MessageHandler.getMessage(3342434, this.getName()));
            return false;
        }
        try {
            DN.decode(attributeValue.getStringValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", exception));
            stringBuilder.append(MessageHandler.getMessage(0x330063, attributeValue.getStringValue(), this.getName(), String.valueOf(exception)));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> list, boolean bl) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "stringsToValues", String.valueOf(list), String.valueOf(bl)));
        if (list == null || list.isEmpty()) {
            if (this.isRequired()) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.getName());
                throw new ConfigException(n, string);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int n = list.size();
        if (!this.isMultiValued() && n > 1) {
            int n2 = 0x330003;
            String string = MessageHandler.getMessage(n2, this.getName());
            throw new ConfigException(n2, string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (String string : list) {
            DN dN;
            if (string == null) {
                int n3 = 3342434;
                String string2 = MessageHandler.getMessage(n3, this.getName());
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string2, n3);
                    continue;
                }
                throw new ConfigException(n3, string2);
            }
            try {
                dN = DN.decode(string);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "stringsToValues", exception));
                int n4 = 0x330063;
                String string3 = MessageHandler.getMessage(n4, string, this.getName(), String.valueOf(exception));
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string3, n4);
                    continue;
                }
                throw new ConfigException(n4, string3);
            }
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(dN.toString()), (ByteString)new ASN1OctetString(dN.toNormalizedString())));
        }
        if (this.isRequired() && linkedHashSet.isEmpty()) {
            String string;
            int n5 = 0x330001;
            string = MessageHandler.getMessage(n5, this.getName());
            throw new ConfigException(n5, string);
        }
        return linkedHashSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValuesToStrings", new String[0]));
        ArrayList<String> arrayList = new ArrayList<String>(this.activeValues.size());
        for (DN dN : this.activeValues) {
            arrayList.add(dN.toString());
        }
        return arrayList;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValuesToStrings", new String[0]));
        if (this.hasPendingValues()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.pendingValues.size());
            for (DN dN : this.pendingValues) {
                arrayList.add(dN.toString());
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(list)));
        ArrayList<DN> arrayList = null;
        ArrayList<DN> arrayList2 = null;
        for (Attribute object : list) {
            DN dN;
            Object n3;
            int string;
            LinkedHashSet<AttributeValue> n2;
            if (object.hasOptions()) {
                if (object.hasOption("pending")) {
                    if (arrayList2 != null) {
                        int n5 = 0x330040;
                        String string2 = MessageHandler.getMessage(n5, object.getName());
                        throw new ConfigException(n5, string2);
                    }
                    n2 = object.getValues();
                    if (n2.isEmpty()) {
                        if (this.isRequired()) {
                            string = 0x330001;
                            n3 = MessageHandler.getMessage(string, object.getName());
                            throw new ConfigException(string, (String)n3);
                        }
                        arrayList2 = new ArrayList(0);
                        continue;
                    }
                    string = n2.size();
                    if (string > 1 && !this.isMultiValued()) {
                        int n7 = 0x330003;
                        String string3 = MessageHandler.getMessage(n7, object.getName());
                        throw new ConfigException(n7, string3);
                    }
                    arrayList2 = new ArrayList(string);
                    for (AttributeValue attributeValue : n2) {
                        try {
                            dN = DN.decode(attributeValue.getStringValue());
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "getConfigAttribute", exception));
                            int n = 0x330063;
                            String string4 = MessageHandler.getMessage(n, attributeValue.getStringValue(), this.getName(), String.valueOf(exception));
                            throw new ConfigException(n, string4, exception);
                        }
                        arrayList2.add(dN);
                    }
                    continue;
                }
                int n6 = 3342366;
                String string5 = MessageHandler.getMessage(n6, object.getName());
                throw new ConfigException(n6, string5);
            }
            if (arrayList != null) {
                int n = 3342401;
                String string6 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, string6);
            }
            n2 = object.getValues();
            if (n2.isEmpty()) {
                if (this.isRequired()) {
                    string = 0x330001;
                    n3 = MessageHandler.getMessage(string, object.getName());
                    throw new ConfigException(string, (String)n3);
                }
                arrayList = new ArrayList<DN>(0);
                continue;
            }
            string = n2.size();
            if (string > 1 && !this.isMultiValued()) {
                int n = 0x330003;
                String string7 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, string7);
            }
            arrayList = new ArrayList(string);
            for (AttributeValue attributeValue : n2) {
                try {
                    dN = DN.decode(attributeValue.getStringValue());
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getConfigAttribute", exception));
                    int n = 0x330063;
                    String string8 = MessageHandler.getMessage(n, attributeValue.getStringValue(), this.getName(), String.valueOf(exception));
                    throw new ConfigException(n, string8, exception);
                }
                arrayList.add(dN);
            }
        }
        if (arrayList == null) {
            int n = 3342402;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (arrayList2 == null) {
            arrayList2 = arrayList;
        }
        return new DNConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), arrayList, arrayList2);
    }

    private javax.management.Attribute _toJMXAttribute(boolean bl) {
        String string;
        List<DN> list;
        assert (Debug.debugEnter(CLASS_NAME, "_toJMXAttribute", new String[0]));
        if (bl) {
            list = this.pendingValues;
            string = this.getName() + ";" + "pending";
        } else {
            list = this.activeValues;
            string = this.getName();
        }
        if (this.isMultiValued()) {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get(i).toString();
            }
            return new javax.management.Attribute(string, stringArray);
        }
        if (list.isEmpty()) {
            return null;
        }
        DN dN = list.get(0);
        return new javax.management.Attribute(string, dN.toString());
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return this._toJMXAttribute(false);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return this._toJMXAttribute(true);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", String.valueOf(attributeList)));
        if (this.activeValues.size() > 0) {
            if (this.isMultiValued()) {
                object = new String[this.activeValues.size()];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    object[i] = this.activeValues.get(i).toString();
                }
                attributeList.add(new javax.management.Attribute(this.getName(), object));
            } else {
                attributeList.add(new javax.management.Attribute(this.getName(), this.activeValues.get(0).toString()));
            }
        } else if (this.isMultiValued()) {
            attributeList.add(new javax.management.Attribute(this.getName(), new String[0]));
        } else {
            attributeList.add(new javax.management.Attribute(this.getName(), null));
        }
        if (this.requiresAdminAction() && this.pendingValues != null && this.pendingValues != this.activeValues) {
            object = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                String[] stringArray = new String[this.pendingValues.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.pendingValues.get(i).toString();
                }
                attributeList.add(new javax.management.Attribute((String)object, stringArray));
            } else if (!this.pendingValues.isEmpty()) {
                attributeList.add(new javax.management.Attribute((String)object, this.pendingValues.get(0).toString()));
            }
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> list) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributeInfo", String.valueOf(list)));
        if (this.isMultiValued()) {
            list.add(new MBeanAttributeInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription(), true, true, false));
        } else {
            list.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), this.getDescription(), true, true, false));
        }
        if (this.requiresAdminAction()) {
            String string = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                list.add(new MBeanAttributeInfo(string, ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription(), true, false, false));
            } else {
                list.add(new MBeanAttributeInfo(string, String.class.getName(), this.getDescription(), true, false, false));
            }
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXParameterInfo", new String[0]));
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription());
        }
        return new MBeanParameterInfo(this.getName(), String.class.getName(), this.getDescription());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(javax.management.Attribute attribute) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(attribute)));
        Object object = attribute.getValue();
        if (object == null) {
            int n = 3342434;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (object instanceof DN) {
            this.setValue((DN)object);
        }
        if (object instanceof String) {
            DN dN;
            try {
                dN = DN.decode((String)object);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "setValue", exception));
                int n = 0x330063;
                String string = MessageHandler.getMessage(n, (String)object, this.getName(), String.valueOf(exception));
                throw new ConfigException(n, string, exception);
            }
            this.setValue(dN);
            return;
        }
        if (object.getClass().isArray()) {
            String string = object.getClass().getComponentType().getName();
            int n = Array.getLength(object);
            if (string.equals(DN.class.getName())) {
                ArrayList<DN> arrayList = new ArrayList<DN>(n);
                for (int i = 0; i < n; ++i) {
                    arrayList.add((DN)Array.get(object, i));
                }
                this.setValues(arrayList);
                return;
            }
            if (string.equals(String.class.getName())) {
                try {
                    ArrayList<DN> arrayList = new ArrayList<DN>(n);
                    for (int i = 0; i < n; ++i) {
                        DN dN;
                        String string2 = (String)Array.get(object, i);
                        try {
                            dN = DN.decode(string2);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "setValue", exception));
                            int n2 = 0x330063;
                            String string3 = MessageHandler.getMessage(n2, string2, this.getName(), String.valueOf(exception));
                            throw new ConfigException(n2, string3, exception);
                        }
                        arrayList.add(dN);
                    }
                    this.setValues(arrayList);
                    return;
                }
                catch (ConfigException configException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "setValue", configException)) throw configException;
                    throw new AssertionError();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "setValue", exception));
                    int n3 = 3342436;
                    String string4 = MessageHandler.getMessage(n3, this.getName(), String.valueOf(object), String.valueOf(exception));
                    throw new ConfigException(n3, string4, exception);
                }
            }
            int n4 = 0x330066;
            String string5 = MessageHandler.getMessage(n4, string);
            throw new ConfigException(n4, string5);
        }
        int n = 3342437;
        String string = MessageHandler.getMessage(n, String.valueOf(object), this.getName(), object.getClass().getName());
        throw new ConfigException(n, string);
    }

    @Override
    public ConfigAttribute duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        return new DNConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.activeValues, this.pendingValues);
    }
}

