/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;

public class AuthorizationIdentityResponseControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.AuthorizationIdentityResponseControl";
    private String authorizationID;

    public AuthorizationIdentityResponseControl() {
        super("2.16.840.1.113730.3.4.15", false, new ASN1OctetString());
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public AuthorizationIdentityResponseControl(String string) {
        super("2.16.840.1.113730.3.4.15", false, AuthorizationIdentityResponseControl.encodeValue(string));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.authorizationID = string;
    }

    public AuthorizationIdentityResponseControl(DN dN) {
        super("2.16.840.1.113730.3.4.15", false, AuthorizationIdentityResponseControl.encodeValue(dN));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN)));
        this.authorizationID = dN == null ? "dn:" : "dn:" + dN.toString();
    }

    public AuthorizationIdentityResponseControl(String string, boolean bl, String string2) {
        super(string, bl, AuthorizationIdentityResponseControl.encodeValue(string2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(string2)));
        this.authorizationID = string2;
    }

    public AuthorizationIdentityResponseControl(String string, boolean bl, DN dN) {
        super(string, bl, AuthorizationIdentityResponseControl.encodeValue(dN));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(dN)));
        this.authorizationID = dN == null ? "dn:" : "dn:" + dN.toString();
    }

    private AuthorizationIdentityResponseControl(String string, boolean bl, String string2, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(string2), String.valueOf(aSN1OctetString)));
        this.authorizationID = string2;
    }

    private static ASN1OctetString encodeValue(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(string)));
        return new ASN1OctetString(string);
    }

    private static ASN1OctetString encodeValue(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(dN)));
        if (dN == null) {
            return new ASN1OctetString("dn:");
        }
        return new ASN1OctetString("dn:" + dN.toString());
    }

    public static AuthorizationIdentityResponseControl decodeControl(Control control) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294073;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        return new AuthorizationIdentityResponseControl(control.getOID(), control.isCritical(), control.getValue().stringValue(), control.getValue());
    }

    public String getAuthorizationID() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthorizationID", new String[0]));
        return this.authorizationID;
    }

    public void setAuthorizationID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthorizationID", String.valueOf(string)));
        this.authorizationID = string;
        this.setValue(AuthorizationIdentityResponseControl.encodeValue(string));
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("AuthorizationIdentityResponseControl(authzID=\"");
        stringBuilder.append(this.authorizationID);
        stringBuilder.append("\")");
    }
}

