/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchedValuesFilter {
    private static final String CLASS_NAME = "org.opends.server.controls.MatchedValuesFilter";
    public static final byte EQUALITY_MATCH_TYPE = -93;
    public static final byte SUBSTRINGS_TYPE = -92;
    public static final byte GREATER_OR_EQUAL_TYPE = -91;
    public static final byte LESS_OR_EQUAL_TYPE = -90;
    public static final byte PRESENT_TYPE = -121;
    public static final byte APPROXIMATE_MATCH_TYPE = -88;
    public static final byte EXTENSIBLE_MATCH_TYPE = -87;
    private ApproximateMatchingRule approximateMatchingRule;
    private ASN1OctetString normalizedSubFinal;
    private ASN1OctetString normalizedSubInitial;
    private ASN1OctetString rawAssertionValue;
    private ASN1OctetString subFinal;
    private ASN1OctetString subInitial;
    private AttributeType attributeType;
    private AttributeValue assertionValue;
    private boolean decoded;
    private byte matchType;
    private EqualityMatchingRule equalityMatchingRule;
    private List<ASN1OctetString> normalizedSubAny;
    private List<ASN1OctetString> subAny;
    private MatchingRule matchingRule;
    private OrderingMatchingRule orderingMatchingRule;
    private String matchingRuleID;
    private String rawAttributeType;
    private SubstringMatchingRule substringMatchingRule;

    private MatchedValuesFilter(byte by, String string, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, List<ASN1OctetString> list, ASN1OctetString aSN1OctetString3, String string2) {
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), String.valueOf(string), String.valueOf(aSN1OctetString), String.valueOf(aSN1OctetString2), String.valueOf(list), String.valueOf(aSN1OctetString3), String.valueOf(string2)));
        this.matchType = by;
        this.rawAttributeType = string;
        this.rawAssertionValue = aSN1OctetString;
        this.subInitial = aSN1OctetString2;
        this.subAny = list;
        this.subFinal = aSN1OctetString3;
        this.matchingRuleID = string2;
        this.decoded = false;
        this.attributeType = null;
        this.assertionValue = null;
        this.matchingRule = null;
        this.normalizedSubInitial = null;
        this.normalizedSubAny = null;
        this.normalizedSubFinal = null;
        this.approximateMatchingRule = null;
        this.equalityMatchingRule = null;
        this.orderingMatchingRule = null;
        this.substringMatchingRule = null;
    }

    public static MatchedValuesFilter createEqualityFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createEqualityFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new MatchedValuesFilter(-93, string, aSN1OctetString, null, null, null, null);
    }

    public static MatchedValuesFilter createEqualityFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createEqualityFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        String string = attributeType.getNameOrOID();
        ASN1OctetString aSN1OctetString = attributeValue.getValue().toASN1OctetString();
        MatchedValuesFilter matchedValuesFilter = new MatchedValuesFilter(-93, string, aSN1OctetString, null, null, null, null);
        matchedValuesFilter.attributeType = attributeType;
        matchedValuesFilter.assertionValue = attributeValue;
        return matchedValuesFilter;
    }

    public static MatchedValuesFilter createSubstringsFilter(String string, ASN1OctetString aSN1OctetString, List<ASN1OctetString> list, ASN1OctetString aSN1OctetString2) {
        assert (Debug.debugEnter(CLASS_NAME, "createSubstringsFilter", String.valueOf(string), String.valueOf(aSN1OctetString), String.valueOf(list), String.valueOf(aSN1OctetString2)));
        return new MatchedValuesFilter(-92, string, null, aSN1OctetString, list, aSN1OctetString2, null);
    }

    public static MatchedValuesFilter createSubstringsFilter(AttributeType attributeType, ASN1OctetString aSN1OctetString, List<ASN1OctetString> list, ASN1OctetString aSN1OctetString2) {
        assert (Debug.debugEnter(CLASS_NAME, "createSubstringsFilter", String.valueOf(attributeType), String.valueOf(aSN1OctetString), String.valueOf(list), String.valueOf(aSN1OctetString2)));
        String string = attributeType.getNameOrOID();
        MatchedValuesFilter matchedValuesFilter = new MatchedValuesFilter(-92, string, null, aSN1OctetString, list, aSN1OctetString2, null);
        matchedValuesFilter.attributeType = attributeType;
        return matchedValuesFilter;
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createGreaterOrEqualFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new MatchedValuesFilter(-91, string, aSN1OctetString, null, null, null, null);
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createGreaterOrEqualFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        String string = attributeType.getNameOrOID();
        ASN1OctetString aSN1OctetString = attributeValue.getValue().toASN1OctetString();
        MatchedValuesFilter matchedValuesFilter = new MatchedValuesFilter(-91, string, aSN1OctetString, null, null, null, null);
        matchedValuesFilter.attributeType = attributeType;
        matchedValuesFilter.assertionValue = attributeValue;
        return matchedValuesFilter;
    }

    public static MatchedValuesFilter createLessOrEqualFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createLessOrEqualFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new MatchedValuesFilter(-90, string, aSN1OctetString, null, null, null, null);
    }

    public static MatchedValuesFilter createLessOrEqualFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createLessOrEqualFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        String string = attributeType.getNameOrOID();
        ASN1OctetString aSN1OctetString = attributeValue.getValue().toASN1OctetString();
        MatchedValuesFilter matchedValuesFilter = new MatchedValuesFilter(-90, string, aSN1OctetString, null, null, null, null);
        matchedValuesFilter.attributeType = attributeType;
        matchedValuesFilter.assertionValue = attributeValue;
        return matchedValuesFilter;
    }

    public static MatchedValuesFilter createPresentFilter(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "createPresentFilter", String.valueOf(string)));
        return new MatchedValuesFilter(-121, string, null, null, null, null, null);
    }

    public static MatchedValuesFilter createPresentFilter(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "createPresentFilter", String.valueOf(attributeType)));
        String string = attributeType.getNameOrOID();
        MatchedValuesFilter matchedValuesFilter = new MatchedValuesFilter(-121, string, null, null, null, null, null);
        matchedValuesFilter.attributeType = attributeType;
        return matchedValuesFilter;
    }

    public static MatchedValuesFilter createApproximateFilter(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createApproximateFilter", String.valueOf(string), String.valueOf(aSN1OctetString)));
        return new MatchedValuesFilter(-88, string, aSN1OctetString, null, null, null, null);
    }

    public static MatchedValuesFilter createApproximateFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createApproximateFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        String string = attributeType.getNameOrOID();
        ASN1OctetString aSN1OctetString = attributeValue.getValue().toASN1OctetString();
        MatchedValuesFilter matchedValuesFilter = new MatchedValuesFilter(-88, string, aSN1OctetString, null, null, null, null);
        matchedValuesFilter.attributeType = attributeType;
        matchedValuesFilter.assertionValue = attributeValue;
        return matchedValuesFilter;
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(String string, String string2, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "createExtensibleMatchFilter", String.valueOf(string), String.valueOf(string2), String.valueOf(aSN1OctetString)));
        return new MatchedValuesFilter(-87, string, aSN1OctetString, null, null, null, string2);
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(AttributeType attributeType, MatchingRule matchingRule, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createExtensibleMatchFilter", String.valueOf(attributeType), String.valueOf(matchingRule), String.valueOf(attributeValue)));
        String string = attributeType == null ? null : attributeType.getNameOrOID();
        String string2 = matchingRule == null ? null : matchingRule.getOID();
        ASN1OctetString aSN1OctetString = attributeValue.getValue().toASN1OctetString();
        MatchedValuesFilter matchedValuesFilter = new MatchedValuesFilter(-88, string, aSN1OctetString, null, null, null, string2);
        matchedValuesFilter.attributeType = attributeType;
        matchedValuesFilter.assertionValue = attributeValue;
        matchedValuesFilter.matchingRule = matchingRule;
        return matchedValuesFilter;
    }

    public static MatchedValuesFilter createFromLDAPFilter(LDAPFilter lDAPFilter) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "createFromLDAPFilter", String.valueOf(lDAPFilter)));
        switch (lDAPFilter.getFilterType()) {
            case AND: 
            case OR: 
            case NOT: {
                int n = 2359617;
                String string = MessageHandler.getMessage(n, String.valueOf(lDAPFilter), String.valueOf((Object)lDAPFilter.getFilterType()));
                throw new LDAPException(2, n, string);
            }
            case EQUALITY: {
                return new MatchedValuesFilter(-93, lDAPFilter.getAttributeType(), lDAPFilter.getAssertionValue(), null, null, null, null);
            }
            case SUBSTRING: {
                return new MatchedValuesFilter(-92, lDAPFilter.getAttributeType(), null, lDAPFilter.getSubInitialElement(), lDAPFilter.getSubAnyElements(), lDAPFilter.getSubFinalElement(), null);
            }
            case GREATER_OR_EQUAL: {
                return new MatchedValuesFilter(-91, lDAPFilter.getAttributeType(), lDAPFilter.getAssertionValue(), null, null, null, null);
            }
            case LESS_OR_EQUAL: {
                return new MatchedValuesFilter(-90, lDAPFilter.getAttributeType(), lDAPFilter.getAssertionValue(), null, null, null, null);
            }
            case PRESENT: {
                return new MatchedValuesFilter(-121, lDAPFilter.getAttributeType(), null, null, null, null, null);
            }
            case APPROXIMATE_MATCH: {
                return new MatchedValuesFilter(-88, lDAPFilter.getAttributeType(), lDAPFilter.getAssertionValue(), null, null, null, null);
            }
            case EXTENSIBLE_MATCH: {
                if (lDAPFilter.getDNAttributes()) {
                    int n = 2359618;
                    String string = MessageHandler.getMessage(n, String.valueOf(lDAPFilter));
                    throw new LDAPException(2, n, string);
                }
                return new MatchedValuesFilter(-87, lDAPFilter.getAttributeType(), lDAPFilter.getAssertionValue(), null, null, null, lDAPFilter.getMatchingRuleID());
            }
        }
        int n = 2359617;
        String string = MessageHandler.getMessage(n, String.valueOf(lDAPFilter), String.valueOf((Object)lDAPFilter.getFilterType()));
        throw new LDAPException(2, n, string);
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        switch (this.matchType) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
                arrayList.add(new ASN1OctetString(this.rawAttributeType));
                arrayList.add(this.rawAssertionValue);
                return new ASN1Sequence(this.matchType, arrayList);
            }
            case -92: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>();
                if (this.subInitial != null) {
                    this.subInitial.setType((byte)-128);
                    arrayList.add(this.subInitial);
                }
                if (this.subAny != null) {
                    for (ASN1OctetString aSN1OctetString : this.subAny) {
                        aSN1OctetString.setType((byte)-127);
                        arrayList.add(aSN1OctetString);
                    }
                }
                if (this.subFinal != null) {
                    this.subFinal.setType((byte)-126);
                    arrayList.add(this.subFinal);
                }
                ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(2);
                arrayList2.add(new ASN1OctetString(this.rawAttributeType));
                arrayList2.add(new ASN1Sequence(arrayList));
                return new ASN1Sequence(this.matchType, arrayList2);
            }
            case -121: {
                return new ASN1OctetString(this.matchType, this.rawAttributeType);
            }
            case -87: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
                if (this.matchingRuleID != null) {
                    arrayList.add(new ASN1OctetString(-127, this.matchingRuleID));
                }
                if (this.rawAttributeType != null) {
                    arrayList.add(new ASN1OctetString(-126, this.rawAttributeType));
                }
                this.rawAssertionValue.setType((byte)-125);
                arrayList.add(this.rawAssertionValue);
                return new ASN1Sequence(this.matchType, arrayList);
            }
        }
        return null;
    }

    public static MatchedValuesFilter decode(ASN1Element aSN1Element) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Element)));
        switch (aSN1Element.getType()) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                try {
                    ArrayList<ASN1Element> arrayList = aSN1Element.decodeAsSequence().elements();
                    if (arrayList.size() != 2) {
                        int n = 2359619;
                        String string = MessageHandler.getMessage(n, arrayList.size());
                        throw new LDAPException(2, n, string);
                    }
                    String string = arrayList.get(0).decodeAsOctetString().stringValue();
                    return new MatchedValuesFilter(aSN1Element.getType(), string, arrayList.get(1).decodeAsOctetString(), null, null, null, null);
                }
                catch (LDAPException lDAPException) {
                    throw lDAPException;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "decode", exception));
                    int n = 2359620;
                    String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new LDAPException(2, n, string, exception);
                }
            }
            case -92: {
                try {
                    ArrayList<ASN1Element> arrayList = aSN1Element.decodeAsSequence().elements();
                    if (arrayList.size() != 2) {
                        int n = 2359621;
                        String string = MessageHandler.getMessage(n, arrayList.size());
                        throw new LDAPException(2, n, string);
                    }
                    ArrayList<ASN1Element> arrayList2 = arrayList.get(1).decodeAsSequence().elements();
                    if (arrayList2.isEmpty()) {
                        int n = 2359622;
                        String string = MessageHandler.getMessage(n);
                        throw new LDAPException(2, n, string);
                    }
                    String string = arrayList.get(0).decodeAsOctetString().stringValue();
                    ASN1OctetString aSN1OctetString = null;
                    ArrayList<ASN1OctetString> arrayList3 = null;
                    ASN1OctetString aSN1OctetString2 = null;
                    block27: for (ASN1Element aSN1Element2 : arrayList2) {
                        switch (aSN1Element2.getType()) {
                            case -128: {
                                if (aSN1OctetString == null) {
                                    aSN1OctetString = aSN1Element2.decodeAsOctetString();
                                    continue block27;
                                }
                                int n = 2359623;
                                String string2 = MessageHandler.getMessage(n);
                                throw new LDAPException(2, n, string2);
                            }
                            case -127: {
                                if (arrayList3 == null) {
                                    arrayList3 = new ArrayList<ASN1OctetString>();
                                }
                                arrayList3.add(aSN1Element2.decodeAsOctetString());
                                continue block27;
                            }
                            case -126: {
                                if (aSN1OctetString2 == null) {
                                    aSN1OctetString2 = aSN1Element2.decodeAsOctetString();
                                    continue block27;
                                }
                                int n = 2359624;
                                String string3 = MessageHandler.getMessage(n);
                                throw new LDAPException(2, n, string3);
                            }
                        }
                        int n = 2359625;
                        String string4 = MessageHandler.getMessage(n, StaticUtils.byteToHex(aSN1Element2.getType()));
                        throw new LDAPException(2, n, string4);
                    }
                    return new MatchedValuesFilter(aSN1Element.getType(), string, null, aSN1OctetString, arrayList3, aSN1OctetString2, null);
                }
                catch (LDAPException lDAPException) {
                    throw lDAPException;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "decode", exception));
                    int n = 2359626;
                    String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new LDAPException(2, n, string, exception);
                }
            }
            case -121: {
                try {
                    String string = aSN1Element.decodeAsOctetString().stringValue();
                    return new MatchedValuesFilter(aSN1Element.getType(), string, null, null, null, null, null);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "decode", exception));
                    int n = 2359627;
                    String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new LDAPException(2, n, string, exception);
                }
            }
            case -87: {
                try {
                    ArrayList<ASN1Element> arrayList = aSN1Element.decodeAsSequence().elements();
                    if (arrayList.size() < 2 || arrayList.size() > 3) {
                        int n = 2359628;
                        String string = MessageHandler.getMessage(n, arrayList.size());
                        throw new LDAPException(2, n, string);
                    }
                    String string = null;
                    String string5 = null;
                    ASN1OctetString aSN1OctetString = null;
                    block28: for (ASN1Element aSN1Element3 : arrayList) {
                        switch (aSN1Element3.getType()) {
                            case -127: {
                                if (string5 == null) {
                                    string5 = aSN1Element3.decodeAsOctetString().stringValue();
                                    continue block28;
                                }
                                int n = 2359629;
                                String string6 = MessageHandler.getMessage(n);
                                throw new LDAPException(2, n, string6);
                            }
                            case -126: {
                                if (string == null) {
                                    string = aSN1Element3.decodeAsOctetString().stringValue();
                                    continue block28;
                                }
                                int n = 2359630;
                                String string7 = MessageHandler.getMessage(n);
                                throw new LDAPException(2, n, string7);
                            }
                            case -125: {
                                if (aSN1OctetString == null) {
                                    aSN1OctetString = aSN1Element3.decodeAsOctetString();
                                    continue block28;
                                }
                                int n = 2359631;
                                String string8 = MessageHandler.getMessage(n);
                                throw new LDAPException(2, n, string8);
                            }
                        }
                        int n = 2359632;
                        String string9 = MessageHandler.getMessage(n, StaticUtils.byteToHex(aSN1Element3.getType()));
                        throw new LDAPException(2, n, string9);
                    }
                    return new MatchedValuesFilter(aSN1Element.getType(), string, aSN1OctetString, null, null, null, string5);
                }
                catch (LDAPException lDAPException) {
                    throw lDAPException;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "decode", exception));
                    int n = 2359633;
                    String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new LDAPException(2, n, string, exception);
                }
            }
        }
        int n = 2359634;
        String string = MessageHandler.getMessage(n, StaticUtils.byteToHex(aSN1Element.getType()));
        throw new LDAPException(2, n, string);
    }

    public byte getMatchType() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchType", new String[0]));
        return this.matchType;
    }

    public String getRawAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawAttributeType", new String[0]));
        return this.rawAttributeType;
    }

    public void setRawAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawAttributeType", String.valueOf(string)));
        this.rawAttributeType = string;
        this.decoded = false;
        this.attributeType = null;
        this.approximateMatchingRule = null;
        this.equalityMatchingRule = null;
        this.orderingMatchingRule = null;
        this.substringMatchingRule = null;
    }

    public AttributeType getAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", new String[0]));
        if (this.attributeType == null && this.rawAttributeType != null) {
            this.attributeType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(this.rawAttributeType));
            if (this.attributeType == null) {
                this.attributeType = DirectoryServer.getDefaultAttributeType(this.rawAttributeType);
            }
        }
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributeType", String.valueOf(attributeType)));
        this.attributeType = attributeType;
        this.rawAttributeType = attributeType == null ? null : attributeType.getNameOrOID();
        this.decoded = false;
        this.approximateMatchingRule = null;
        this.equalityMatchingRule = null;
        this.orderingMatchingRule = null;
        this.substringMatchingRule = null;
    }

    public ASN1OctetString getRawAssertionValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawAssertionValue", new String[0]));
        return this.rawAssertionValue;
    }

    public void setRawAssertionValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawAssertionValue", String.valueOf(aSN1OctetString)));
        this.rawAssertionValue = aSN1OctetString;
        this.decoded = false;
        this.assertionValue = null;
    }

    public AttributeValue getAssertionValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getAssertionValue", new String[0]));
        if (this.assertionValue == null && this.rawAssertionValue != null) {
            this.assertionValue = new AttributeValue(this.getAttributeType(), (ByteString)this.rawAssertionValue);
        }
        return this.assertionValue;
    }

    public void setAssertionValue(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "setAssertionValue", String.valueOf(attributeValue)));
        this.assertionValue = attributeValue;
        this.rawAssertionValue = attributeValue == null ? null : attributeValue.getValue().toASN1OctetString();
        this.decoded = false;
    }

    public ASN1OctetString getSubInitialElement() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubInitialElement", new String[0]));
        return this.subInitial;
    }

    public void setSubInitialElement(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubInitialElement", String.valueOf(aSN1OctetString)));
        this.subInitial = aSN1OctetString;
        this.decoded = false;
        this.normalizedSubInitial = null;
    }

    public ASN1OctetString getNormalizedSubInitialElement() {
        block4: {
            assert (Debug.debugEnter(CLASS_NAME, "getNormalizedSubInitialElement", new String[0]));
            if (this.normalizedSubInitial == null && this.subInitial != null && this.getSubstringMatchingRule() != null) {
                try {
                    this.normalizedSubInitial = this.getSubstringMatchingRule().normalizeSubstring(this.subInitial).toASN1OctetString();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "getNormalizedSubInitialElement", exception)) break block4;
                    throw new AssertionError();
                }
            }
        }
        return this.normalizedSubInitial;
    }

    public List<ASN1OctetString> getSubAnyElements() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubAnyElements", new String[0]));
        return this.subAny;
    }

    public void setSubAnyElements(List<ASN1OctetString> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubAnyElements", String.valueOf(list)));
        this.subAny = list;
        this.decoded = false;
        this.normalizedSubAny = null;
    }

    public List<ASN1OctetString> getNormalizedSubAnyElements() {
        assert (Debug.debugEnter(CLASS_NAME, "getNormalizedSubAnyElements", new String[0]));
        if (this.normalizedSubAny == null) {
            if (this.subAny == null || this.subAny.isEmpty()) {
                this.normalizedSubAny = new ArrayList<ASN1OctetString>(0);
            } else {
                if (this.getSubstringMatchingRule() == null) {
                    return null;
                }
                this.normalizedSubAny = new ArrayList<ASN1OctetString>();
                try {
                    for (ASN1OctetString aSN1OctetString : this.subAny) {
                        this.normalizedSubAny.add(this.substringMatchingRule.normalizeSubstring(aSN1OctetString).toASN1OctetString());
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getNormalizedSubAnyElements", exception));
                    this.normalizedSubAny = null;
                }
            }
        }
        return this.normalizedSubAny;
    }

    public ASN1OctetString getSubFinalElement() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubFinal", new String[0]));
        return this.subFinal;
    }

    public void setSubFinalElement(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubFinalElement", String.valueOf(aSN1OctetString)));
        this.subFinal = aSN1OctetString;
        this.decoded = false;
        this.normalizedSubFinal = null;
    }

    public ASN1OctetString getNormalizedSubFinalElement() {
        block4: {
            assert (Debug.debugEnter(CLASS_NAME, "getNormalizedSubFinalElement", new String[0]));
            if (this.normalizedSubFinal == null && this.subFinal != null && this.getSubstringMatchingRule() != null) {
                try {
                    this.normalizedSubFinal = this.getSubstringMatchingRule().normalizeSubstring(this.subFinal).toASN1OctetString();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "getNormalizedSubFinalElement", exception)) break block4;
                    throw new AssertionError();
                }
            }
        }
        return this.normalizedSubFinal;
    }

    public String getMatchingRuleID() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleID", new String[0]));
        return this.matchingRuleID;
    }

    public void setMatchingRuleID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchingRuleID", String.valueOf(string)));
        this.matchingRuleID = string;
        this.decoded = false;
        this.matchingRule = null;
    }

    public MatchingRule getMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRule", new String[0]));
        if (this.matchingRule == null && this.matchingRuleID != null) {
            this.matchingRule = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
        }
        return this.matchingRule;
    }

    public void setMatchingRule(MatchingRule matchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchingRule", String.valueOf(matchingRule)));
        this.matchingRule = matchingRule;
        this.matchingRuleID = matchingRule == null ? null : matchingRule.getNameOrOID();
        this.decoded = false;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        AttributeType attributeType;
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        if (this.approximateMatchingRule == null && (attributeType = this.getAttributeType()) != null) {
            this.approximateMatchingRule = attributeType.getApproximateMatchingRule();
        }
        return this.approximateMatchingRule;
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        AttributeType attributeType;
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        if (this.equalityMatchingRule == null && (attributeType = this.getAttributeType()) != null) {
            this.equalityMatchingRule = attributeType.getEqualityMatchingRule();
        }
        return this.equalityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        AttributeType attributeType;
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        if (this.orderingMatchingRule == null && (attributeType = this.getAttributeType()) != null) {
            this.orderingMatchingRule = attributeType.getOrderingMatchingRule();
        }
        return this.orderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        AttributeType attributeType;
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        if (this.substringMatchingRule == null && (attributeType = this.getAttributeType()) != null) {
            this.substringMatchingRule = attributeType.getSubstringMatchingRule();
        }
        return this.substringMatchingRule;
    }

    private void fullyDecode() {
        if (!this.decoded) {
            this.getAttributeType();
            this.getAssertionValue();
            this.getNormalizedSubInitialElement();
            this.getNormalizedSubAnyElements();
            this.getNormalizedSubFinalElement();
            this.getMatchingRule();
            this.getApproximateMatchingRule();
            this.getEqualityMatchingRule();
            this.getOrderingMatchingRule();
            this.getSubstringMatchingRule();
            this.decoded = true;
        }
    }

    public boolean valueMatches(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "valueMatches", String.valueOf(attributeType), String.valueOf(attributeValue)));
        this.fullyDecode();
        switch (this.matchType) {
            case -93: {
                if (this.attributeType != null && attributeType != null && this.attributeType.equals(attributeType) && this.assertionValue != null && attributeValue != null && this.equalityMatchingRule != null) {
                    try {
                        return this.equalityMatchingRule.areEqual(this.assertionValue.getNormalizedValue(), attributeValue.getNormalizedValue());
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
                        return false;
                    }
                }
                return false;
            }
            case -92: {
                if (this.attributeType != null && attributeType != null && this.attributeType.equals(attributeType) && this.substringMatchingRule != null) {
                    try {
                        ArrayList<ByteString> arrayList = new ArrayList<ByteString>(this.normalizedSubAny);
                        return this.substringMatchingRule.valueMatchesSubstring(attributeValue.getNormalizedValue(), this.normalizedSubInitial, arrayList, this.normalizedSubFinal);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
                        return false;
                    }
                }
                return false;
            }
            case -91: {
                if (this.attributeType != null && attributeType != null && this.attributeType.equals(attributeType) && this.assertionValue != null && attributeValue != null && this.orderingMatchingRule != null) {
                    try {
                        return this.orderingMatchingRule.compareValues(this.assertionValue.getNormalizedValue(), attributeValue.getNormalizedValue()) >= 0;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
                        return false;
                    }
                }
                return false;
            }
            case -90: {
                if (this.attributeType != null && attributeType != null && this.attributeType.equals(attributeType) && this.assertionValue != null && attributeValue != null && this.orderingMatchingRule != null) {
                    try {
                        return this.orderingMatchingRule.compareValues(this.assertionValue.getNormalizedValue(), attributeValue.getNormalizedValue()) <= 0;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
                        return false;
                    }
                }
                return false;
            }
            case -121: {
                return this.attributeType != null && attributeType != null && this.attributeType.equals(attributeType);
            }
            case -88: {
                if (this.attributeType != null && attributeType != null && this.attributeType.equals(attributeType) && this.assertionValue != null && attributeValue != null && this.approximateMatchingRule != null) {
                    try {
                        return this.approximateMatchingRule.approximatelyMatch(this.assertionValue.getNormalizedValue(), attributeValue.getNormalizedValue());
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
                        return false;
                    }
                }
                return false;
            }
            case -87: {
                if (this.assertionValue == null || attributeValue == null) {
                    return false;
                }
                if (this.attributeType == null) {
                    if (this.matchingRule == null) {
                        return false;
                    }
                    try {
                        ASN1OctetString aSN1OctetString = this.matchingRule.normalizeValue(attributeValue.getValue()).toASN1OctetString();
                        ASN1OctetString aSN1OctetString2 = this.matchingRule.normalizeValue(this.assertionValue.getValue()).toASN1OctetString();
                        return this.matchingRule.valuesMatch(aSN1OctetString, aSN1OctetString2) == ConditionResult.TRUE;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
                        return false;
                    }
                }
                if (!this.attributeType.equals(attributeType) || this.equalityMatchingRule == null) {
                    return false;
                }
                try {
                    return this.equalityMatchingRule.areEqual(this.assertionValue.getNormalizedValue(), attributeValue.getNormalizedValue());
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
                    return false;
                }
            }
        }
        return false;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        switch (this.matchType) {
            case -93: {
                stringBuilder.append("(");
                stringBuilder.append(this.rawAttributeType);
                stringBuilder.append("=");
                LDAPFilter.valueToFilterString(stringBuilder, this.rawAssertionValue);
                stringBuilder.append(")");
                break;
            }
            case -92: {
                stringBuilder.append("(");
                stringBuilder.append(this.rawAttributeType);
                stringBuilder.append("=");
                if (this.subInitial != null) {
                    LDAPFilter.valueToFilterString(stringBuilder, this.subInitial);
                }
                if (this.subAny != null) {
                    for (ASN1OctetString aSN1OctetString : this.subAny) {
                        stringBuilder.append("*");
                        LDAPFilter.valueToFilterString(stringBuilder, aSN1OctetString);
                    }
                }
                stringBuilder.append("*");
                if (this.subFinal != null) {
                    LDAPFilter.valueToFilterString(stringBuilder, this.subFinal);
                }
                stringBuilder.append(")");
                break;
            }
            case -91: {
                stringBuilder.append("(");
                stringBuilder.append(this.rawAttributeType);
                stringBuilder.append(">=");
                LDAPFilter.valueToFilterString(stringBuilder, this.rawAssertionValue);
                stringBuilder.append(")");
                break;
            }
            case -90: {
                stringBuilder.append("(");
                stringBuilder.append(this.rawAttributeType);
                stringBuilder.append("<=");
                LDAPFilter.valueToFilterString(stringBuilder, this.rawAssertionValue);
                stringBuilder.append(")");
                break;
            }
            case -121: {
                stringBuilder.append("(");
                stringBuilder.append(this.rawAttributeType);
                stringBuilder.append("=*)");
                break;
            }
            case -88: {
                stringBuilder.append("(");
                stringBuilder.append(this.rawAttributeType);
                stringBuilder.append("~=");
                LDAPFilter.valueToFilterString(stringBuilder, this.rawAssertionValue);
                stringBuilder.append(")");
                break;
            }
            case -87: {
                stringBuilder.append("(");
                if (this.rawAttributeType != null) {
                    stringBuilder.append(this.rawAttributeType);
                }
                if (this.matchingRuleID != null) {
                    stringBuilder.append(":");
                    stringBuilder.append(this.matchingRuleID);
                }
                stringBuilder.append(":=");
                LDAPFilter.valueToFilterString(stringBuilder, this.rawAssertionValue);
                stringBuilder.append(")");
            }
        }
    }
}

