/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.util.StaticUtils;

public class PasswordExpiringControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.PasswordExpiringControl";
    private int secondsUntilExpiration;

    public PasswordExpiringControl(int n) {
        super("2.16.840.1.113730.3.4.5", false, new ASN1OctetString(String.valueOf(n)));
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.secondsUntilExpiration = n;
    }

    public PasswordExpiringControl(String string, boolean bl, int n) {
        super(string, bl, new ASN1OctetString(String.valueOf(n)));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl)));
        this.secondsUntilExpiration = n;
    }

    private PasswordExpiringControl(String string, boolean bl, int n, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl)));
        this.secondsUntilExpiration = n;
    }

    public static PasswordExpiringControl decodeControl(Control control) throws LDAPException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n2 = 2359639;
            String string = MessageHandler.getMessage(n2);
            throw new LDAPException(2, n2, string);
        }
        try {
            n = Integer.parseInt(control.getValue().stringValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n3 = 2359640;
            String string = MessageHandler.getMessage(n3, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n3, string);
        }
        return new PasswordExpiringControl(control.getOID(), control.isCritical(), n, control.getValue());
    }

    public int getSecondsUntilExpiration() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecondsUntilExpiration", new String[0]));
        return this.secondsUntilExpiration;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("PasswordExpiringControl(secondsUntilExpiration=");
        stringBuilder.append(this.secondsUntilExpiration);
        stringBuilder.append(")");
    }
}

