/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.EntryCache;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.extensions.DefaultEntryCache;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class EntryCacheConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.EntryCacheConfigManager";

    public EntryCacheConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeEntryCache() throws InitializationException {
        EntryCache entryCache;
        Object object;
        Object object2;
        Object object3;
        ConfigEntry configEntry;
        Object object4;
        assert (Debug.debugEnter(CLASS_NAME, "initializeEntryCache", new String[0]));
        try {
            object4 = new DefaultEntryCache();
            ((DefaultEntryCache)object4).initializeEntryCache(null);
            DirectoryServer.setEntryCache((EntryCache)object4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            int n = 3408072;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        try {
            object4 = DN.decode("cn=Entry Cache,cn=config");
            configEntry = DirectoryServer.getConfigEntry((DN)object4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408073, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        if (configEntry == null) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408074);
            try {
                ConfigEntry configEntry2 = DirectoryServer.getConfigEntry(((DN)object4).getParent());
                if (configEntry2 != null) {
                    configEntry2.registerAddListener(this);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408075, StaticUtils.stackTraceToSingleLineString(exception));
            }
            return;
        }
        configEntry.registerChangeListener(this);
        try {
            DN dN = ((DN)object4).getParent();
            object3 = DirectoryServer.getConfigEntry(dN);
            if (object3 != null) {
                ((ConfigEntry)object3).registerDeleteListener(this);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408076, StaticUtils.stackTraceToSingleLineString(exception));
        }
        int n = 3408077;
        object3 = new BooleanConfigAttribute("ds-cfg-entry-cache-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408078);
                return;
            }
            if (!((BooleanConfigAttribute)object2).activeValue()) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, 3408079);
                return;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408080, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        n = 3408081;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-entry-cache-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408082);
                return;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408083, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408084, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            entryCache = (EntryCache)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408085, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            entryCache.initializeEntryCache(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408086, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        DirectoryServer.setEntryCache(entryCache);
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }
}

