/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.opends.server.api.SubtreeSpecification;
import org.opends.server.core.DirectoryException;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSubtreeSpecification
extends SubtreeSpecification {
    private static final String CLASS_NAME = SimpleSubtreeSpecification.class.getName();
    private DN baseDN;
    private int minimumDepth;
    private int maximumDepth;
    private TreeMap<DN, DN> chopBefore;
    private TreeMap<DN, DN> chopAfter;

    protected SimpleSubtreeSpecification(DN dN, int n, int n2, Iterable<DN> iterable, Iterable<DN> iterable2) {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.baseDN = dN;
        this.minimumDepth = n;
        this.maximumDepth = n2;
        if (iterable != null && iterable.iterator().hasNext()) {
            this.chopBefore = new TreeMap();
            for (DN dN2 : iterable) {
                this.chopBefore.put(new DN(dN, dN2), dN2);
            }
        } else {
            this.chopBefore = null;
        }
        if (iterable2 != null && iterable2.iterator().hasNext()) {
            this.chopAfter = new TreeMap();
            for (DN dN2 : iterable2) {
                this.chopAfter.put(new DN(dN, dN2), dN2);
            }
        } else {
            this.chopAfter = null;
        }
    }

    protected final boolean isDNWithinScope(DN dN) {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "isDNWithinScope", new String[0]));
        if (!dN.isDescendantOf(this.baseDN)) {
            return false;
        }
        int n2 = this.baseDN.getRDNComponents().length;
        if (this.minimumDepth > 0 && (n = dN.getRDNComponents().length) - n2 < this.minimumDepth) {
            return false;
        }
        if (this.maximumDepth >= 0 && (n = dN.getRDNComponents().length) - n2 > this.maximumDepth) {
            return false;
        }
        if (this.chopBefore != null) {
            for (DN dN2 : this.chopBefore.keySet()) {
                if (!dN.isDescendantOf(dN2)) continue;
                return false;
            }
        }
        if (this.chopAfter != null) {
            for (DN dN2 : this.chopAfter.keySet()) {
                if (dN.equals(dN2) || !dN.isDescendantOf(dN2)) continue;
                return false;
            }
        }
        return true;
    }

    protected final DN getBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDN", new String[0]));
        return this.baseDN;
    }

    protected final boolean commonComponentsEquals(SimpleSubtreeSpecification simpleSubtreeSpecification) {
        assert (Debug.debugEnter(CLASS_NAME, "commonComponentsEquals", new String[0]));
        if (this == simpleSubtreeSpecification) {
            return true;
        }
        if (this.minimumDepth != simpleSubtreeSpecification.minimumDepth) {
            return false;
        }
        if (this.maximumDepth != simpleSubtreeSpecification.maximumDepth) {
            return false;
        }
        if (this.chopBefore != null && simpleSubtreeSpecification.chopBefore != null ? !((Object)this.chopBefore.values()).equals(simpleSubtreeSpecification.chopBefore.values()) : this.chopBefore != simpleSubtreeSpecification.chopBefore) {
            return false;
        }
        return !(this.chopAfter != null && simpleSubtreeSpecification.chopAfter != null ? !((Object)this.chopAfter.values()).equals(simpleSubtreeSpecification.chopAfter.values()) : this.chopAfter != simpleSubtreeSpecification.chopAfter);
    }

    protected final int commonComponentsHashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "commonComponentsHashCode", new String[0]));
        int n = this.minimumDepth * 31 + this.maximumDepth;
        if (this.chopBefore != null) {
            n = n * 31 + ((Object)this.chopBefore.values()).hashCode();
        }
        if (this.chopAfter != null) {
            n = n * 31 + ((Object)this.chopAfter.values()).hashCode();
        }
        return n;
    }

    public final Iterable<DN> getChopAfter() {
        assert (Debug.debugEnter(CLASS_NAME, "getChopAfter", new String[0]));
        if (this.chopAfter != null) {
            return this.chopAfter.values();
        }
        return null;
    }

    public final Iterable<DN> getChopBefore() {
        assert (Debug.debugEnter(CLASS_NAME, "getChopBefore", new String[0]));
        if (this.chopBefore != null) {
            return this.chopBefore.values();
        }
        return null;
    }

    public final int getMaximumDepth() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaximumDepth", new String[0]));
        return this.maximumDepth;
    }

    public final int getMinimumDepth() {
        assert (Debug.debugEnter(CLASS_NAME, "getMinimumDepth", new String[0]));
        return this.minimumDepth;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Parser {
        private Scanner scanner;
        private static Pattern LBRACE = Pattern.compile("\\{.*");
        private static Pattern LBRACE_TOKEN = Pattern.compile("\\{");
        private static Pattern RBRACE = Pattern.compile("\\}.*");
        private static Pattern RBRACE_TOKEN = Pattern.compile("\\}");
        private static Pattern SEP = Pattern.compile(",.*");
        private static Pattern SEP_TOKEN = Pattern.compile(",");
        private static Pattern COLON = Pattern.compile(":.*");
        private static Pattern COLON_TOKEN = Pattern.compile(":");
        private static Pattern INT = Pattern.compile("\\d.*");
        private static Pattern INT_TOKEN = Pattern.compile("\\d+");
        private static Pattern NAME = Pattern.compile("[\\w_;-].*");
        private static Pattern NAME_TOKEN = Pattern.compile("[\\w_;-]+");
        private static Pattern STRING_VALUE = Pattern.compile("\".*");
        private static Pattern STRING_VALUE_TOKEN = Pattern.compile("\"([^\"]|(\"\"))*\"");

        public Parser(String string) {
            this.scanner = new Scanner(string);
        }

        public void skipLeftBrace() throws InputMismatchException, NoSuchElementException {
            this.nextValue(LBRACE, LBRACE_TOKEN);
        }

        public void skipRightBrace() throws InputMismatchException, NoSuchElementException {
            this.nextValue(RBRACE, RBRACE_TOKEN);
        }

        public void skipSeparator() throws InputMismatchException, NoSuchElementException {
            this.nextValue(SEP, SEP_TOKEN);
        }

        public void skipColon() throws InputMismatchException, NoSuchElementException {
            this.nextValue(COLON, COLON_TOKEN);
        }

        public boolean hasNextRightBrace() {
            return this.scanner.hasNext(RBRACE);
        }

        public boolean hasNext() {
            return this.scanner.hasNext();
        }

        public String nextKey() throws InputMismatchException, NoSuchElementException {
            return StaticUtils.toLowerCase(this.scanner.next());
        }

        public String nextName() throws InputMismatchException, NoSuchElementException {
            return this.nextValue(NAME, NAME_TOKEN);
        }

        public int nextInt() throws InputMismatchException, NoSuchElementException {
            String string = this.nextValue(INT, INT_TOKEN);
            return Integer.parseInt(string);
        }

        public String nextStringValue() throws InputMismatchException, NoSuchElementException {
            String string = this.nextValue(STRING_VALUE, STRING_VALUE_TOKEN);
            return string.substring(1, string.length() - 1).replace("\"\"", "\"");
        }

        public void nextSpecificExclusions(Set<DN> set, Set<DN> set2) throws InputMismatchException, NoSuchElementException, DirectoryException {
            block4: {
                this.skipLeftBrace();
                boolean bl = true;
                while (true) {
                    if (this.hasNextRightBrace()) break block4;
                    if (!bl) {
                        this.skipSeparator();
                    } else {
                        bl = false;
                    }
                    String string = StaticUtils.toLowerCase(this.nextName());
                    this.skipColon();
                    if (string.equals("chopbefore")) {
                        set.add(DN.decode(this.nextStringValue()));
                        continue;
                    }
                    if (!string.equals("chopafter")) break;
                    set2.add(DN.decode(this.nextStringValue()));
                }
                throw new InputMismatchException();
            }
            this.skipRightBrace();
        }

        private String nextValue(Pattern pattern, Pattern pattern2) throws InputMismatchException, NoSuchElementException {
            if (!this.scanner.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.scanner.hasNext(pattern)) {
                throw new InputMismatchException();
            }
            String string = this.scanner.findInLine(pattern2);
            if (string == null) {
                throw new InputMismatchException();
            }
            return string;
        }
    }
}

