/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedKeyManagerProvider
extends KeyManagerProvider
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.FileBasedKeyManagerProvider";
    private DN configEntryDN;
    private char[] keyStorePIN;
    private String keyStoreFile;
    private String keyStorePINEnVar;
    private String keyStorePINFile;
    private String keyStorePINProperty;
    private String keyStoreType;

    public FileBasedKeyManagerProvider() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeKeyManagerProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        int n;
        block46: {
            StringConfigAttribute stringConfigAttribute;
            block48: {
                StringConfigAttribute stringConfigAttribute2;
                block47: {
                    Object object2;
                    block45: {
                        block44: {
                            StringConfigAttribute stringConfigAttribute3;
                            assert (Debug.debugEnter(CLASS_NAME, "initializeKeyManagerProvider", String.valueOf(configEntry)));
                            this.configEntryDN = configEntry.getDN();
                            n = 1048619;
                            StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-key-store-file", MessageHandler.getMessage(n), true, false, false);
                            try {
                                stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
                                if (stringConfigAttribute3 == null || (this.keyStoreFile = stringConfigAttribute3.activeValue()) == null) {
                                    n = 1310764;
                                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                                    throw new ConfigException(n, string);
                                }
                                object = StaticUtils.getFileForPath(this.keyStoreFile);
                                if (!((File)object).exists() || !((File)object).isFile()) {
                                    n = 1310765;
                                    String string = MessageHandler.getMessage(n, String.valueOf(this.keyStoreFile), String.valueOf(this.configEntryDN));
                                    throw new InitializationException(n, string);
                                }
                            }
                            catch (ConfigException configException) {
                                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", configException));
                                throw configException;
                            }
                            catch (InitializationException initializationException) {
                                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                                throw initializationException;
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                                n = 1310766;
                                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                                throw new InitializationException(n, string, exception);
                            }
                            this.keyStoreType = KeyStore.getDefaultType();
                            n = 1048623;
                            stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-type", MessageHandler.getMessage(n), false, false, false);
                            try {
                                object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                                if (object == null) break block44;
                                object2 = ((StringConfigAttribute)object).activeValue();
                                try {
                                    KeyStore.getInstance((String)object2);
                                    this.keyStoreType = object2;
                                }
                                catch (KeyStoreException keyStoreException) {
                                    assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", keyStoreException));
                                    n = 1310783;
                                    String string = MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(keyStoreException));
                                    throw new InitializationException(n, string);
                                }
                            }
                            catch (InitializationException initializationException) {
                                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                                throw initializationException;
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                                n = 1310768;
                                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                                throw new InitializationException(n, string, exception);
                            }
                        }
                        this.keyStorePIN = null;
                        this.keyStorePINEnVar = null;
                        this.keyStorePINFile = null;
                        this.keyStorePINProperty = null;
                        n = 0x100031;
                        object = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            object2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
                            if (object2 == null) break block45;
                            String string = ((StringConfigAttribute)object2).activeValue();
                            String string2 = System.getProperty(string);
                            if (string2 == null) {
                                n = 1310770;
                                String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                                throw new InitializationException(n, string3);
                            }
                            this.keyStorePIN = string2.toCharArray();
                            this.keyStorePINProperty = string;
                            break block46;
                        }
                        catch (InitializationException initializationException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                            throw initializationException;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                            n = 1310771;
                            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                            throw new InitializationException(n, string, exception);
                        }
                    }
                    n = 1048628;
                    object2 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
                        if (stringConfigAttribute2 == null) break block47;
                        String string = stringConfigAttribute2.activeValue();
                        String string4 = System.getenv(string);
                        if (string4 == null) {
                            n = 1310773;
                            String string5 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                            throw new InitializationException(n, string5);
                        }
                        this.keyStorePIN = string4.toCharArray();
                        this.keyStorePINEnVar = string;
                        break block46;
                    }
                    catch (InitializationException initializationException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                        throw initializationException;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                        n = 1310774;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                        throw new InitializationException(n, string, exception);
                    }
                }
                n = 1048631;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string;
                    Object object3;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block48;
                    String string6 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string6);
                    if (!file.exists()) {
                        n = 1310776;
                        String string7 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        throw new InitializationException(n, string7);
                    }
                    try {
                        object3 = new BufferedReader(new FileReader(file));
                        string = ((BufferedReader)object3).readLine();
                        ((BufferedReader)object3).close();
                    }
                    catch (IOException iOException) {
                        n = 1310777;
                        String string8 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException));
                        throw new InitializationException(n, string8, iOException);
                    }
                    if (string == null) {
                        n = 1310778;
                        object3 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        throw new InitializationException(n, (String)object3);
                    }
                    this.keyStorePIN = string.toCharArray();
                    this.keyStorePINFile = string6;
                    break block46;
                }
                catch (InitializationException initializationException) {
                    assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                    throw initializationException;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                    n = 1310779;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                    throw new InitializationException(n, string, exception);
                }
            }
            n = 1048636;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute5 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute5 != null) {
                    this.keyStorePIN = stringConfigAttribute5.activeValue().toCharArray();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                n = 1310780;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
        }
        if (this.keyStorePIN == null) {
            n = 1310781;
            object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            throw new ConfigException(n, (String)object);
        }
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeKeyManagerProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeKeyManagerProvider", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public KeyManager[] getKeyManagers() throws DirectoryException {
        Object object;
        KeyStore keyStore;
        assert (Debug.debugEnter(CLASS_NAME, "getKeyManagers", new String[0]));
        try {
            keyStore = KeyStore.getInstance(this.keyStoreType);
            object = new FileInputStream(StaticUtils.getFileForPath(this.keyStoreFile));
            keyStore.load((InputStream)object, this.keyStorePIN);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getKeyManagers", exception));
            int n = 1310782;
            String string = MessageHandler.getMessage(n, this.keyStoreFile, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        try {
            object = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)object);
            keyManagerFactory.init(keyStore, this.keyStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getKeyManagers", exception));
            int n = 1310803;
            String string = MessageHandler.getMessage(n, this.keyStoreFile, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048619;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-file", MessageHandler.getMessage(n), true, false, false, this.keyStoreFile);
        linkedList.add(stringConfigAttribute);
        n = 1048623;
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-type", MessageHandler.getMessage(n), true, false, false, this.keyStoreType);
        linkedList.add(stringConfigAttribute2);
        n = 0x100031;
        StringConfigAttribute stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false, this.keyStorePINProperty);
        linkedList.add(stringConfigAttribute3);
        n = 1048628;
        StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false, this.keyStorePINEnVar);
        linkedList.add(stringConfigAttribute4);
        n = 1048631;
        StringConfigAttribute stringConfigAttribute5 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false, this.keyStorePINFile);
        linkedList.add(stringConfigAttribute5);
        String string = this.keyStorePINProperty == null && this.keyStorePINEnVar == null && this.keyStorePINFile == null ? new String(this.keyStorePIN) : null;
        n = 1048636;
        StringConfigAttribute stringConfigAttribute6 = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false, string);
        linkedList.add(stringConfigAttribute6);
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        int n;
        block36: {
            StringConfigAttribute stringConfigAttribute;
            block38: {
                StringConfigAttribute stringConfigAttribute2;
                block37: {
                    Object object2;
                    block35: {
                        block34: {
                            Object object3;
                            assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
                            n = 1048619;
                            StringConfigAttribute stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-file", MessageHandler.getMessage(n), true, false, false);
                            try {
                                object3 = null;
                                object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                                if (object == null || (object3 = ((StringConfigAttribute)object).activeValue()) == null) {
                                    n = 1310764;
                                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                                    throw new ConfigException(n, string);
                                }
                                object2 = StaticUtils.getFileForPath((String)object3);
                                if (!((File)object2).exists() || !((File)object2).isFile()) {
                                    n = 1310765;
                                    String string = MessageHandler.getMessage(n, String.valueOf(object3), String.valueOf(this.configEntryDN));
                                    list.add(string);
                                    return false;
                                }
                            }
                            catch (ConfigException configException) {
                                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", configException));
                                list.add(configException.getMessage());
                                return false;
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                                n = 1310766;
                                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                                list.add(string);
                                return false;
                            }
                            n = 1048623;
                            object3 = new StringConfigAttribute("ds-cfg-key-store-type", MessageHandler.getMessage(n), false, false, false);
                            try {
                                object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
                                if (object == null) break block34;
                                object2 = ((StringConfigAttribute)object).activeValue();
                                try {
                                    KeyStore.getInstance((String)object2);
                                }
                                catch (KeyStoreException keyStoreException) {
                                    assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", keyStoreException));
                                    n = 1310783;
                                    String string = MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(keyStoreException));
                                    list.add(string);
                                    return false;
                                }
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                                n = 1310768;
                                object2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                                list.add((String)object2);
                                return false;
                            }
                        }
                        n = 0x100031;
                        object = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            object2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
                            if (object2 == null) break block35;
                            String string = ((StringConfigAttribute)object2).activeValue();
                            String string2 = System.getProperty(string);
                            if (string2 == null) {
                                n = 1310770;
                                String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                                list.add(string3);
                                return false;
                            }
                            break block36;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                            n = 1310771;
                            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                            list.add(string);
                            return false;
                        }
                    }
                    n = 1048628;
                    object2 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
                        if (stringConfigAttribute2 == null) break block37;
                        String string = stringConfigAttribute2.activeValue();
                        String string4 = System.getenv(string);
                        if (string4 == null) {
                            n = 1310773;
                            String string5 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                            list.add(string5);
                            return false;
                        }
                        break block36;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                        n = 1310774;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                        list.add(string);
                        return false;
                    }
                }
                n = 1048631;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string;
                    Object object4;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block38;
                    String string6 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string6);
                    if (!file.exists()) {
                        n = 1310776;
                        String string7 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        list.add(string7);
                        return false;
                    }
                    try {
                        object4 = new BufferedReader(new FileReader(file));
                        string = ((BufferedReader)object4).readLine();
                        ((BufferedReader)object4).close();
                    }
                    catch (IOException iOException) {
                        n = 1310777;
                        String string8 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException));
                        list.add(string8);
                        return false;
                    }
                    if (string == null) {
                        n = 1310778;
                        object4 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        list.add((String)object4);
                        return false;
                    }
                    break block36;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                    n = 1310779;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                    list.add(string);
                    return false;
                }
            }
            n = 1048636;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute4 == null) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                n = 1310780;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                list.add(string);
                return false;
            }
        }
        if (this.keyStorePIN == null) {
            n = 1310781;
            object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            list.add((String)object);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        String string;
        String string2;
        String string3;
        Object object;
        Object object2;
        int n;
        String string4;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block57: {
            StringConfigAttribute stringConfigAttribute;
            block59: {
                StringConfigAttribute stringConfigAttribute2;
                block58: {
                    StringConfigAttribute stringConfigAttribute3;
                    block56: {
                        block55: {
                            Object object3;
                            block54: {
                                assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
                                resultCode = ResultCode.SUCCESS;
                                bl2 = false;
                                arrayList = new ArrayList<String>();
                                string4 = null;
                                n = 1048619;
                                StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-key-store-file", MessageHandler.getMessage(n), true, false, false);
                                try {
                                    object2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
                                    if (object2 == null || (string4 = ((StringConfigAttribute)object2).activeValue()) == null) {
                                        n = 1310764;
                                        String string5 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                                        throw new ConfigException(n, string5);
                                    }
                                    object3 = StaticUtils.getFileForPath(string4);
                                    if (!((File)object3).exists() || !((File)object3).isFile()) {
                                        n = 1310765;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string4), String.valueOf(this.configEntryDN)));
                                        if (resultCode == ResultCode.SUCCESS) {
                                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                        }
                                    }
                                }
                                catch (ConfigException configException) {
                                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", configException));
                                    if (resultCode == ResultCode.SUCCESS) {
                                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                    }
                                }
                                catch (Exception exception) {
                                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                                    n = 1310766;
                                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                                    if (resultCode != ResultCode.SUCCESS) break block54;
                                    resultCode = DirectoryServer.getServerErrorResultCode();
                                }
                            }
                            object2 = KeyStore.getDefaultType();
                            n = 1048623;
                            object3 = new StringConfigAttribute("ds-cfg-key-store-type", MessageHandler.getMessage(n), false, false, false);
                            try {
                                object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
                                if (object != null) {
                                    object2 = ((StringConfigAttribute)object).activeValue();
                                    try {
                                        KeyStore.getInstance((String)object2);
                                    }
                                    catch (KeyStoreException keyStoreException) {
                                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", keyStoreException));
                                        n = 1310783;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(keyStoreException)));
                                        if (resultCode == ResultCode.SUCCESS) {
                                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                        }
                                    }
                                }
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                                n = 1310768;
                                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                                if (resultCode != ResultCode.SUCCESS) break block55;
                                resultCode = DirectoryServer.getServerErrorResultCode();
                            }
                        }
                        object = null;
                        string3 = null;
                        string2 = null;
                        string = null;
                        n = 0x100031;
                        StringConfigAttribute stringConfigAttribute5 = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute5);
                            if (stringConfigAttribute3 == null) break block56;
                            String string6 = stringConfigAttribute3.activeValue();
                            String string7 = System.getProperty(string6);
                            if (string7 == null) {
                                n = 1310770;
                                arrayList.add(MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN)));
                                if (resultCode == ResultCode.SUCCESS) {
                                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                }
                                break block57;
                            }
                            object = string7.toCharArray();
                            string = string6;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                            n = 1310771;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = DirectoryServer.getServerErrorResultCode();
                            }
                            break block57;
                        }
                    }
                    n = 1048628;
                    stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                        if (stringConfigAttribute2 == null) break block58;
                        String string8 = stringConfigAttribute2.activeValue();
                        String string9 = System.getenv(string8);
                        if (string9 == null) {
                            n = 1310773;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(string8), String.valueOf(this.configEntryDN)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            }
                            break block57;
                        }
                        object = string9.toCharArray();
                        string3 = string8;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n = 1310774;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                        break block57;
                    }
                }
                n = 1048631;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string10;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block59;
                    String string11 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string11);
                    if (!file.exists()) {
                        n = 1310776;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string11), String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                        break block57;
                    }
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        string10 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        n = 1310777;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string11), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                        break block57;
                    }
                    if (string10 == null) {
                        n = 1310778;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string11), String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                        break block57;
                    }
                    object = string10.toCharArray();
                    string2 = string11;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n = 1310779;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                    break block57;
                }
            }
            n = 1048636;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute6 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute6 != null) {
                    object = stringConfigAttribute6.activeValue().toCharArray();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 1310780;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block57;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (object == null) {
            n = 1310781;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (!this.keyStoreFile.equals(string4)) {
                this.keyStoreFile = string4;
                if (bl) {
                    n = 0x100040;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(string4)));
                }
            }
            if (!this.keyStoreType.equals(object2)) {
                this.keyStoreType = object2;
                if (bl) {
                    n = 0x100041;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(object2)));
                }
            }
            if (!Arrays.equals(this.keyStorePIN, (char[])object)) {
                this.keyStorePIN = (char[])object;
                this.keyStorePINProperty = string;
                this.keyStorePINEnVar = string3;
                this.keyStorePINFile = string2;
                if (bl) {
                    n = 1048642;
                    arrayList.add(MessageHandler.getMessage(n));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

