/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.api.DirectoryThread;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.extensions.TraditionalWorkQueue;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class TraditionalWorkerThread
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.core.WorkerThread";
    private boolean shutdownRequested;
    private boolean stoppedByReducedThreadNumber;
    private boolean waitingForWork;
    private Operation operation;
    private Thread workerThread;
    private TraditionalWorkQueue workQueue;

    public TraditionalWorkerThread(TraditionalWorkQueue traditionalWorkQueue, int n) {
        super("Worker Thread " + n);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(traditionalWorkQueue), String.valueOf(n)));
        this.workQueue = traditionalWorkQueue;
        this.stoppedByReducedThreadNumber = false;
        this.shutdownRequested = false;
        this.waitingForWork = false;
        this.operation = null;
        this.workerThread = null;
    }

    public void setStoppedByReducedThreadNumber() {
        assert (Debug.debugEnter(CLASS_NAME, "setStoppedByReducedThreadNumber", new String[0]));
        this.stoppedByReducedThreadNumber = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "run", this.getName() + " starting."));
        this.workerThread = TraditionalWorkerThread.currentThread();
        while (!this.shutdownRequested) {
            try {
                this.waitingForWork = true;
                this.operation = null;
                this.operation = this.workQueue.nextOperation(this);
                this.waitingForWork = false;
                if (this.operation == null) break;
                try {
                    this.operation.run();
                    this.operation.operationCompleted();
                }
                finally {
                    if (this.operation.getCancelResult() != null) continue;
                    this.operation.setCancelResult(CancelResult.TOO_LATE);
                }
            }
            catch (Exception exception) {
                String string;
                int n;
                block20: {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "run", "Uncaught exception in worker thread while processing operation " + String.valueOf(this.operation) + ":  " + exception));
                    assert (Debug.debugException(CLASS_NAME, "run", exception));
                    try {
                        n = 196716;
                        string = MessageHandler.getMessage(n, this.getName(), String.valueOf(this.operation), StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, string, n);
                        this.operation.setResultCode(DirectoryServer.getServerErrorResultCode());
                        this.operation.appendErrorMessage(string);
                        this.operation.getClientConnection().sendResponse(this.operation);
                    }
                    catch (Exception exception2) {
                        assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "run", "Exception in worker thread while trying to log a message about an uncaught exception " + exception + ":  " + exception2));
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception2)) break block20;
                        throw new AssertionError();
                    }
                }
                try {
                    n = 196716;
                    string = MessageHandler.getMessage(n, this.getName(), String.valueOf(this.operation), StaticUtils.stackTraceToSingleLineString(exception));
                    this.operation.getClientConnection().disconnect(DisconnectReason.SERVER_ERROR, true, string, n);
                }
                catch (Exception exception3) {
                    assert (Debug.debugException(CLASS_NAME, "run", exception3));
                }
            }
        }
        if (this.stoppedByReducedThreadNumber) {
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.INFORMATIONAL, 204, this.getName());
        } else if (!this.workQueue.shutdownRequested()) {
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, 131181, this.getName());
        }
        assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "run", this.getName() + " exiting."));
    }

    public void shutDown() {
        block11: {
            assert (Debug.debugEnter(CLASS_NAME, "shutDown", new String[0]));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "shutDown", this.getName() + " being signaled to shut down."));
            this.shutdownRequested = true;
            if (this.waitingForWork) {
                try {
                    this.workerThread.interrupt();
                }
                catch (Exception exception) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "shutDown", "Caught an exception while trying to interrupt the worker thread waiting for work:  " + exception));
                    assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                }
            } else {
                try {
                    CancelRequest cancelRequest = new CancelRequest(true, MessageHandler.getMessage(107));
                    this.operation.cancel(cancelRequest);
                }
                catch (Exception exception) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "shutDown", "Caught an exception while trying to abandon the operation in progress for the worker thread:  " + exception));
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "shutDown", exception)) break block11;
                    throw new AssertionError();
                }
            }
        }
    }
}

