/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.AccessLogger;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;

public class Access {
    private static CopyOnWriteArrayList<AccessLogger> accessLoggers = new CopyOnWriteArrayList();
    private static ReentrantLock loggerMutex = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAccessLogger(AccessLogger accessLogger) {
        loggerMutex.lock();
        try {
            for (AccessLogger accessLogger2 : accessLoggers) {
                if (!accessLogger2.equals(accessLogger)) continue;
                return;
            }
            accessLoggers.add(accessLogger);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAccessLogger(AccessLogger accessLogger) {
        loggerMutex.lock();
        try {
            accessLoggers.remove(accessLogger);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllAccessLoggers(boolean bl) {
        loggerMutex.lock();
        try {
            if (bl) {
                AccessLogger[] accessLoggerArray = new AccessLogger[accessLoggers.size()];
                accessLoggers.toArray(accessLoggerArray);
                accessLoggers.clear();
                for (AccessLogger accessLogger : accessLoggerArray) {
                    accessLogger.closeAccessLogger();
                }
            } else {
                accessLoggers.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    public static void logConnect(ClientConnection clientConnection) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logConnect(clientConnection);
        }
    }

    public static void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, String string) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logDisconnect(clientConnection, disconnectReason, string);
        }
    }

    public static void logAbandonRequest(AbandonOperation abandonOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logAbandonRequest(abandonOperation);
        }
    }

    public static void logAbandonResult(AbandonOperation abandonOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logAbandonResult(abandonOperation);
        }
    }

    public static void logAddRequest(AddOperation addOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logAddRequest(addOperation);
        }
    }

    public static void logAddResponse(AddOperation addOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logAddResponse(addOperation);
        }
    }

    public static void logBindRequest(BindOperation bindOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logBindRequest(bindOperation);
        }
    }

    public static void logBindResponse(BindOperation bindOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logBindResponse(bindOperation);
        }
    }

    public static void logCompareRequest(CompareOperation compareOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logCompareRequest(compareOperation);
        }
    }

    public static void logCompareResponse(CompareOperation compareOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logCompareResponse(compareOperation);
        }
    }

    public static void logDeleteRequest(DeleteOperation deleteOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logDeleteRequest(deleteOperation);
        }
    }

    public static void logDeleteResponse(DeleteOperation deleteOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logDeleteResponse(deleteOperation);
        }
    }

    public static void logExtendedRequest(ExtendedOperation extendedOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logExtendedRequest(extendedOperation);
        }
    }

    public static void logExtendedResponse(ExtendedOperation extendedOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logExtendedResponse(extendedOperation);
        }
    }

    public static void logModifyRequest(ModifyOperation modifyOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logModifyRequest(modifyOperation);
        }
    }

    public static void logModifyResponse(ModifyOperation modifyOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logModifyResponse(modifyOperation);
        }
    }

    public static void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logModifyDNRequest(modifyDNOperation);
        }
    }

    public static void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logModifyDNResponse(modifyDNOperation);
        }
    }

    public static void logSearchRequest(SearchOperation searchOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logSearchRequest(searchOperation);
        }
    }

    public static void logSearchResultEntry(SearchOperation searchOperation, SearchResultEntry searchResultEntry) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logSearchResultEntry(searchOperation, searchResultEntry);
        }
    }

    public static void logSearchResultReference(SearchOperation searchOperation, SearchResultReference searchResultReference) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logSearchResultReference(searchOperation, searchResultReference);
        }
    }

    public static void logSearchResultDone(SearchOperation searchOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logSearchResultDone(searchOperation);
        }
    }

    public static void logUnbind(UnbindOperation unbindOperation) {
        for (AccessLogger accessLogger : accessLoggers) {
            accessLogger.logUnbind(unbindOperation);
        }
    }
}

