/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.server.api.AccessLogger;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.DirectoryFileFormatter;
import org.opends.server.loggers.DirectoryFileHandler;
import org.opends.server.loggers.DirectoryLogLevel;
import org.opends.server.loggers.LoggerThread;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationConfigUtil;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.SizeBasedRotationPolicy;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryAccessLogger
extends AccessLogger
implements ConfigurableComponent {
    private static final int DEFAULT_TIME_INTERVAL = 30000;
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private boolean suppressInternalOps = true;
    private Logger accessLogger = null;
    private String changedLogFileName = null;
    private DirectoryFileHandler fileHandler = null;
    private DN configDN;

    @Override
    public void initializeAccessLogger(ConfigEntry configEntry) throws ConfigException {
        this.configDN = configEntry.getDN();
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
        StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
        if (stringConfigAttribute2 == null) {
            int n = 3407954;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            throw new ConfigException(n, string);
        }
        this.initializeAccessLogger(stringConfigAttribute2.activeValue(), configEntry);
    }

    @Override
    public void closeAccessLogger() {
        this.fileHandler.close();
    }

    @Override
    public void logConnect(ClientConnection clientConnection) {
        long l = clientConnection.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CONNECT conn=");
        stringBuilder.append(l);
        stringBuilder.append(" from=");
        stringBuilder.append(clientConnection.getClientAddress());
        stringBuilder.append(" to=");
        stringBuilder.append(clientConnection.getServerAddress());
        stringBuilder.append(" protocol=");
        stringBuilder.append(clientConnection.getProtocol());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, String string) {
        long l = clientConnection.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("DISCONNECT conn=");
        stringBuilder.append(l);
        stringBuilder.append(" reason=\"");
        stringBuilder.append((Object)disconnectReason);
        if (string != null) {
            stringBuilder.append("\" msg=\"");
            stringBuilder.append(string);
        }
        stringBuilder.append("\"");
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logAbandonRequest(AbandonOperation abandonOperation) {
        long l = abandonOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("ABANDON conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(abandonOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(abandonOperation.getMessageID());
        stringBuilder.append(" idToAbandon=");
        stringBuilder.append(abandonOperation.getIDToAbandon());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logAbandonResult(AbandonOperation abandonOperation) {
        long l = abandonOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("ABANDON conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(abandonOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(abandonOperation.getMessageID());
        stringBuilder.append(" result=");
        stringBuilder.append((Object)abandonOperation.getResultCode());
        StringBuilder stringBuilder2 = abandonOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append(" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("\"");
        }
        stringBuilder.append(" etime=");
        stringBuilder.append(abandonOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logAddRequest(AddOperation addOperation) {
        long l = addOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("ADD conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(addOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(addOperation.getMessageID());
        stringBuilder.append(" dn=\"");
        addOperation.getRawEntryDN().toString(stringBuilder);
        stringBuilder.append("\"");
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logAddResponse(AddOperation addOperation) {
        long l = addOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("ADD conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(addOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(addOperation.getMessageID());
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)addOperation.getResultCode());
        StringBuilder stringBuilder2 = addOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("\" etime=");
        stringBuilder.append(addOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logBindRequest(BindOperation bindOperation) {
        long l = bindOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("BIND conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(bindOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(bindOperation.getMessageID());
        switch (bindOperation.getAuthenticationType()) {
            case SIMPLE: {
                stringBuilder.append(" type=SIMPLE");
                break;
            }
            case SASL: {
                stringBuilder.append(" type=SASL mechanism=");
                stringBuilder.append(bindOperation.getSASLMechanism());
                break;
            }
            default: {
                stringBuilder.append(" type=");
                stringBuilder.append((Object)bindOperation.getAuthenticationType());
            }
        }
        stringBuilder.append(" dn=\"");
        bindOperation.getRawBindDN().toString(stringBuilder);
        stringBuilder.append("\"");
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logBindResponse(BindOperation bindOperation) {
        int n;
        long l = bindOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("BIND conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(bindOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(bindOperation.getMessageID());
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)bindOperation.getResultCode());
        StringBuilder stringBuilder2 = bindOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        if ((n = bindOperation.getAuthFailureID()) > 0) {
            stringBuilder.append("\" authFailureID=");
            stringBuilder.append(n);
            stringBuilder.append(" authFailureReason=\"");
            String string = bindOperation.getAuthFailureReason();
            if (string != null) {
                stringBuilder.append(string);
            }
        }
        stringBuilder.append("\" etime=");
        stringBuilder.append(bindOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logCompareRequest(CompareOperation compareOperation) {
        long l = compareOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("COMPARE conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(compareOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(compareOperation.getMessageID());
        stringBuilder.append(" dn=\"");
        compareOperation.getRawEntryDN().toString(stringBuilder);
        stringBuilder.append("\" attr=");
        stringBuilder.append(compareOperation.getAttributeType());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logCompareResponse(CompareOperation compareOperation) {
        long l = compareOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("COMPARE conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(compareOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(compareOperation.getMessageID());
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)compareOperation.getResultCode());
        StringBuilder stringBuilder2 = compareOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("\" etime=");
        stringBuilder.append(compareOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logDeleteRequest(DeleteOperation deleteOperation) {
        long l = deleteOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("DELETE conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(deleteOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(deleteOperation.getMessageID());
        stringBuilder.append(" dn=\"");
        deleteOperation.getRawEntryDN().toString(stringBuilder);
        stringBuilder.append("\"");
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logDeleteResponse(DeleteOperation deleteOperation) {
        long l = deleteOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("DELETE conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(deleteOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(deleteOperation.getMessageID());
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)deleteOperation.getResultCode());
        StringBuilder stringBuilder2 = deleteOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("\" etime=");
        stringBuilder.append(deleteOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logExtendedRequest(ExtendedOperation extendedOperation) {
        long l = extendedOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("EXTENDED conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(extendedOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(extendedOperation.getMessageID());
        stringBuilder.append(" oid=\"");
        stringBuilder.append(extendedOperation.getRequestOID());
        stringBuilder.append("\"");
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logExtendedResponse(ExtendedOperation extendedOperation) {
        long l = extendedOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("EXTENDED conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(extendedOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(extendedOperation.getMessageID());
        String string = extendedOperation.getResponseOID();
        if (string != null) {
            stringBuilder.append(" oid=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)extendedOperation.getResultCode());
        StringBuilder stringBuilder2 = extendedOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("\" etime=");
        stringBuilder.append(extendedOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logModifyRequest(ModifyOperation modifyOperation) {
        long l = modifyOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("MODIFY conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(modifyOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(modifyOperation.getMessageID());
        stringBuilder.append(" dn=\"");
        modifyOperation.getRawEntryDN().toString(stringBuilder);
        stringBuilder.append("\"");
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logModifyResponse(ModifyOperation modifyOperation) {
        long l = modifyOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("MODIFY conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(modifyOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(modifyOperation.getMessageID());
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)modifyOperation.getResultCode());
        StringBuilder stringBuilder2 = modifyOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("\" etime=");
        stringBuilder.append(modifyOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
        long l = modifyDNOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("MODIFYDN conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(modifyDNOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(modifyDNOperation.getMessageID());
        stringBuilder.append(" dn=\"");
        modifyDNOperation.getRawEntryDN().toString(stringBuilder);
        stringBuilder.append("\" newRDN=\"");
        modifyDNOperation.getRawNewRDN().toString(stringBuilder);
        stringBuilder.append("\" deleteOldRDN=");
        stringBuilder.append(modifyDNOperation.deleteOldRDN());
        ByteString byteString = modifyDNOperation.getRawNewSuperior();
        if (byteString != null) {
            stringBuilder.append(" newSuperior=\"");
            byteString.toString(stringBuilder);
        }
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        long l = modifyDNOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("MODIFYDN conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(modifyDNOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(modifyDNOperation.getMessageID());
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)modifyDNOperation.getResultCode());
        StringBuilder stringBuilder2 = modifyDNOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("\" etime=");
        stringBuilder.append(modifyDNOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logSearchRequest(SearchOperation searchOperation) {
        long l = searchOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("SEARCH conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(searchOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(searchOperation.getMessageID());
        stringBuilder.append(" base=\"");
        searchOperation.getRawBaseDN().toString(stringBuilder);
        stringBuilder.append("\" scope=");
        stringBuilder.append((Object)searchOperation.getScope());
        stringBuilder.append(" filter=\"");
        searchOperation.getRawFilter().toString(stringBuilder);
        LinkedHashSet<String> linkedHashSet = searchOperation.getAttributes();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            stringBuilder.append("\"");
        } else {
            stringBuilder.append("\" attrs=\"");
            Iterator iterator = linkedHashSet.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                stringBuilder.append((String)iterator.next());
            }
            stringBuilder.append("\"");
        }
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logSearchResultEntry(SearchOperation searchOperation, SearchResultEntry searchResultEntry) {
    }

    @Override
    public void logSearchResultReference(SearchOperation searchOperation, SearchResultReference searchResultReference) {
    }

    @Override
    public void logSearchResultDone(SearchOperation searchOperation) {
        long l = searchOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("SEARCH conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(searchOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(searchOperation.getMessageID());
        stringBuilder.append(" result=\"");
        stringBuilder.append((Object)searchOperation.getResultCode());
        StringBuilder stringBuilder2 = searchOperation.getErrorMessage();
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append("\" message=\"");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("\" nentries=");
        stringBuilder.append(searchOperation.getEntriesSent());
        stringBuilder.append(" etime=");
        stringBuilder.append(searchOperation.getProcessingTime());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public void logUnbind(UnbindOperation unbindOperation) {
        long l = unbindOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("UNBIND conn=");
        stringBuilder.append(l);
        stringBuilder.append(" op=");
        stringBuilder.append(unbindOperation.getOperationID());
        stringBuilder.append(" msgID=");
        stringBuilder.append(unbindOperation.getMessageID());
        this.accessLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.accessLogger.equals(object);
    }

    @Override
    public int hashCode() {
        return this.accessLogger.hashCode();
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return null;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        try {
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute2 == null) {
                int n = 3407954;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                list.add(string);
                return false;
            }
            this.changedLogFileName = stringConfigAttribute2.pendingValue();
        }
        catch (ConfigException configException) {
            int n = 3407926;
            String string = MessageHandler.getMessage(n, this.getClass().getName(), configEntry.getDN().toString(), String.valueOf(configException));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        this.fileHandler.close();
        try {
            this.initializeAccessLogger(this.changedLogFileName, configEntry);
        }
        catch (ConfigException configException) {
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private void initializeAccessLogger(String string, ConfigEntry configEntry) throws ConfigException {
        this.accessLogger = Logger.getLogger("org.opends.server.loggers.DirectoryAccessLogger");
        this.accessLogger.setLevel(Level.ALL);
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(DirectoryServer.getServerRoot() + File.separator + string);
        }
        try {
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-suppress-internal-operations", MessageHandler.getMessage(3146031), false);
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 != null) {
                this.suppressInternalOps = booleanConfigAttribute2.pendingValue();
            }
        }
        catch (Exception exception) {
            int n = 3408176;
            String string2 = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            throw new ConfigException(n, string2);
        }
        try {
            List<Object> list;
            int n = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-buffer-size", 0x40000A);
            if (n == -1) {
                n = 65536;
            }
            CopyOnWriteArrayList<RotationPolicy> copyOnWriteArrayList = RotationConfigUtil.getRotationPolicies(configEntry);
            this.fileHandler = new DirectoryFileHandler(configEntry, file.getAbsolutePath(), n);
            this.fileHandler.setFormatter(new DirectoryFileFormatter(false));
            this.accessLogger.addHandler(this.fileHandler);
            if (copyOnWriteArrayList != null) {
                list = RotationConfigUtil.getPostRotationActions(configEntry);
                this.fileHandler.setPostRotationActions((ArrayList<ActionType>)list);
                for (RotationPolicy object2 : copyOnWriteArrayList) {
                    if (!(object2 instanceof SizeBasedRotationPolicy)) continue;
                    long l = ((SizeBasedRotationPolicy)object2).getMaxFileSize();
                    this.fileHandler.setFileSize(l);
                    copyOnWriteArrayList.remove(object2);
                }
            }
            list = RotationConfigUtil.getRetentionPolicies(configEntry);
            int n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-thread-time-interval", 0x400009);
            if (n2 == -1) {
                n2 = 30000;
            }
            LoggerThread loggerThread = new LoggerThread("AccessLogger Thread", n2, this.fileHandler, copyOnWriteArrayList, (CopyOnWriteArrayList<RetentionPolicy>)list);
            loggerThread.start();
        }
        catch (IOException iOException) {
            int n = 0x440001;
            String string3 = MessageHandler.getMessage(n, String.valueOf(iOException));
            throw new ConfigException(n, string3, iOException);
        }
    }
}

