/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class Error {
    private static CopyOnWriteArrayList<ErrorLogger> errorLoggers = new CopyOnWriteArrayList();
    private static ReentrantLock loggerMutex = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addErrorLogger(ErrorLogger errorLogger) {
        loggerMutex.lock();
        try {
            for (ErrorLogger errorLogger2 : errorLoggers) {
                if (!errorLogger2.equals(errorLogger)) continue;
                return;
            }
            errorLoggers.add(errorLogger);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeErrorLogger(ErrorLogger errorLogger) {
        loggerMutex.lock();
        try {
            errorLoggers.remove(errorLogger);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllErrorLoggers(boolean bl) {
        loggerMutex.lock();
        try {
            if (bl) {
                ErrorLogger[] errorLoggerArray = new ErrorLogger[errorLoggers.size()];
                errorLoggers.toArray(errorLoggerArray);
                errorLoggers.clear();
                for (ErrorLogger errorLogger : errorLoggerArray) {
                    errorLogger.closeErrorLogger();
                }
            } else {
                errorLoggers.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            loggerMutex.unlock();
        }
    }

    public static void logError(ErrorLogCategory errorLogCategory, ErrorLogSeverity errorLogSeverity, int n) {
        String string = MessageHandler.getMessage(n);
        for (ErrorLogger errorLogger : errorLoggers) {
            errorLogger.logError(errorLogCategory, errorLogSeverity, string, n);
        }
    }

    public static void logError(ErrorLogCategory errorLogCategory, ErrorLogSeverity errorLogSeverity, int n, Object ... objectArray) {
        String string = MessageHandler.getMessage(n, objectArray);
        for (ErrorLogger errorLogger : errorLoggers) {
            errorLogger.logError(errorLogCategory, errorLogSeverity, string, n);
        }
    }

    public static void logError(ErrorLogCategory errorLogCategory, ErrorLogSeverity errorLogSeverity, String string, int n) {
        for (ErrorLogger errorLogger : errorLoggers) {
            errorLogger.logError(errorLogCategory, errorLogSeverity, string, n);
        }
    }
}

